/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.accessor.entity.EntityAccessor;
import org.spongepowered.common.data.nbt.validation.DelegateDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationTypes;
import org.spongepowered.common.entity.SpongeEntityArchetype;
import org.spongepowered.common.util.Constants;

public class SpongeEntityArchetypeBuilder
extends AbstractDataBuilder<EntityArchetype>
implements EntityArchetype.Builder {
    EntityType entityType = null;
    DataContainer entityData;
    CompoundNBT compound;
    DataManipulator.Mutable manipulator;

    public SpongeEntityArchetypeBuilder() {
        super(EntityArchetype.class, 1);
    }

    @Override
    public EntityArchetype.Builder reset() {
        this.entityType = null;
        this.entityData = null;
        this.manipulator = null;
        return this;
    }

    @Override
    public EntityArchetype.Builder from(EntityArchetype value) {
        this.entityType = value.getType();
        this.entityData = value.getEntityData();
        this.manipulator = null;
        return this;
    }

    @Override
    protected Optional<EntityArchetype> buildContent(DataView container) throws InvalidDataException {
        SpongeEntityArchetypeBuilder builder = new SpongeEntityArchetypeBuilder();
        if (!container.contains(Constants.Sponge.EntityArchetype.ENTITY_TYPE)) {
            throw new InvalidDataException("Missing the EntityType! Cannot re-construct an EntityArchetype!");
        }
        builder.type((EntityType)container.getRegistryValue(Constants.Sponge.EntityArchetype.ENTITY_TYPE, RegistryTypes.ENTITY_TYPE, Sponge.getGame().registries()).orElseThrow(() -> new InvalidDataException("Could not deserialize an EntityType!")));
        if (container.contains(Constants.Sponge.EntityArchetype.ENTITY_DATA)) {
            builder.entityData(container.getView(Constants.Sponge.EntityArchetype.ENTITY_DATA).orElseThrow(() -> new InvalidDataException("No DataView found for the TileEntity data tag!")));
        }
        return Optional.of(builder.build());
    }

    public EntityArchetype.Builder type(EntityType type) {
        Objects.requireNonNull(type, "EntityType cannot be null!");
        if (this.entityType != type) {
            this.entityData = null;
        }
        this.entityType = type;
        return this;
    }

    @Override
    public EntityArchetype.Builder from(org.spongepowered.api.entity.Entity entity) {
        Objects.requireNonNull(entity, "Cannot build an EntityArchetype for a null entity!");
        this.entityType = Objects.requireNonNull(entity.getType(), "Entity is returning a null EntityType!");
        Entity minecraftEntity = (Entity)entity;
        CompoundNBT compound = new CompoundNBT();
        minecraftEntity.func_184198_c(compound);
        compound.func_74778_a("Id", ((EntityAccessor)minecraftEntity).invoker$getEncodeId());
        compound.func_82580_o("UUID");
        compound.func_82580_o("UUIDMost");
        compound.func_82580_o("UUIDLeast");
        compound.func_74757_a("RequireInitialSpawn", true);
        this.compound = compound;
        return this;
    }

    @Override
    public EntityArchetype.Builder entityData(DataView view) {
        Objects.requireNonNull(view, "Provided DataView cannot be null!");
        DataContainer copy = view.copy();
        new DelegateDataValidator(SpongeEntityArchetype.VALIDATORS, ValidationTypes.ENTITY.get()).validate(copy);
        this.entityData = copy;
        this.compound = null;
        return this;
    }

    @Override
    public <V> EntityArchetype.Builder add(Key<? extends Value<V>> key, V value) {
        if (this.manipulator == null) {
            this.manipulator = DataManipulator.mutableOf();
        }
        this.manipulator.set(key, value);
        return this;
    }

    @Override
    public EntityArchetype build() {
        Objects.requireNonNull(this.entityType);
        if (this.entityData != null) {
            this.entityData.remove(Constants.Entity.Player.UUID);
        }
        SpongeEntityArchetype archetype = new SpongeEntityArchetype(this);
        if (this.manipulator != null) {
            archetype.copyFrom(this.manipulator);
        }
        return archetype;
    }
}

