/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.living.human;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SDestroyEntitiesPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.network.play.server.SSpawnPlayerPacket;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.scoreboard.TeamMember;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.entity.LivingEntityAccessor;
import org.spongepowered.common.accessor.entity.player.PlayerEntityAccessor;
import org.spongepowered.common.accessor.network.play.server.SPlayerListItemPacketAccessor;
import org.spongepowered.common.accessor.network.play.server.SSpawnPlayerPacketAccessor;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.util.SpongeTicks;

public final class HumanEntity
extends CreatureEntity
implements TeamMember,
IRangedAttackMob {
    public static final RegistryKey<EntityType<?>> KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239713_n_, (ResourceLocation)new ResourceLocation("sponge", "human"));
    public static final EntityType<HumanEntity> TYPE = (EntityType)Registry.field_212629_r.func_218381_a(KEY, (Object)EntityType.Builder.func_220322_a(HumanEntity::new, (EntityClassification)EntityClassification.MISC).func_200706_c().func_233606_a_(32).func_206830_a("sponge:human"), Lifecycle.stable());
    public static final AttributeModifierMap ATTRIBUTES = MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f).func_233814_a_(Attributes.field_233825_h_).func_233814_a_(Attributes.field_233828_k_).func_233813_a_();
    private final Map<UUID, List<Stream<IPacket<?>>>> playerPacketMap = new HashMap();
    private GameProfile fakeProfile = new GameProfile(this.field_96093_i, "");
    private boolean aiDisabled = false;
    private boolean leftHanded = false;

    public HumanEntity(EntityType<? extends HumanEntity> type, World world) {
        super(TYPE, world);
        this.func_98053_h(true);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(LivingEntityAccessor.accessor$DATA_LIVING_ENTITY_FLAGS(), (Object)0);
        this.field_70180_af.func_187214_a(LivingEntityAccessor.accessor$DATA_HEALTH_ID(), (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(LivingEntityAccessor.accessor$DATA_EFFECT_COLOR_ID(), (Object)0);
        this.field_70180_af.func_187214_a(LivingEntityAccessor.accessor$DATA_EFFECT_AMBIENCE_ID(), (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(LivingEntityAccessor.accessor$DATA_ARROW_COUNT_ID(), (Object)0);
        this.field_70180_af.func_187214_a(LivingEntityAccessor.accessor$DATA_STINGER_COUNT_ID(), (Object)0);
        this.field_70180_af.func_187214_a(LivingEntityAccessor.accessor$SLEEPING_POS_ID(), Optional.empty());
        this.field_70180_af.func_187214_a(PlayerEntityAccessor.accessor$DATA_PLAYER_ABSORPTION_ID(), (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PlayerEntityAccessor.accessor$DATA_SCORE_ID(), (Object)0);
        this.field_70180_af.func_187214_a(PlayerEntityAccessor.accessor$DATA_PLAYER_MODE_CUSTOMISATION(), (Object)127);
        this.field_70180_af.func_187214_a(PlayerEntityAccessor.accessor$DATA_PLAYER_MAIN_HAND(), (Object)1);
        this.field_70180_af.func_187214_a(PlayerEntityAccessor.accessor$DATA_SHOULDER_LEFT(), (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(PlayerEntityAccessor.accessor$DATA_SHOULDER_RIGHT(), (Object)new CompoundNBT());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    public boolean func_184638_cS() {
        return this.leftHanded;
    }

    public boolean func_175446_cd() {
        return this.aiDisabled;
    }

    @Override
    public Component getTeamRepresentation() {
        return Component.text((String)this.fakeProfile.getName());
    }

    public Team func_96124_cp() {
        return this.field_70170_p.func_96441_U().func_96509_i(this.fakeProfile.getName());
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        ITextComponent customName = this.func_200201_e();
        if (customName == null && name == null || customName != null && customName.equals(name)) {
            return;
        }
        super.func_200203_b(name);
        this.setProfileName(name);
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("profile")) {
            this.fakeProfile = NBTUtil.func_152459_a((CompoundNBT)tag.func_74775_l("profile"));
        }
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_218657_a("profile", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)this.fakeProfile));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_82168_bl();
    }

    public void func_94061_f(boolean disable) {
        this.aiDisabled = disable;
    }

    public void func_184641_n(boolean leftHanded) {
        this.leftHanded = leftHanded;
    }

    public void func_213395_q(boolean aggressive) {
    }

    public int func_82145_z() {
        return 1;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187808_ef;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187806_ee;
    }

    public int func_82147_ab() {
        return 10;
    }

    public void func_70645_a(@Nullable DamageSource cause) {
        super.func_70645_a(cause);
        this.func_226264_Z_();
        if (cause != null) {
            this.func_213293_j(-MathHelper.func_76134_b((float)((this.field_70739_aP + this.field_70177_z) * ((float)Math.PI / 180))) * 0.1f, 0.1f, -MathHelper.func_76126_a((float)((this.field_70739_aP + this.field_70177_z) * ((float)Math.PI / 180))) * 0.1f);
        } else {
            this.func_213293_j(0.0, 0.1, 0.0);
        }
        this.func_70066_B();
        this.func_70052_a(0, false);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187800_eb;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187798_ea;
    }

    public double func_70033_W() {
        return -0.35;
    }

    public float func_70689_ay() {
        return (float)this.func_110148_a(Attributes.field_233821_d_).func_111126_e();
    }

    protected SoundEvent func_184588_d(int height) {
        return height > 4 ? SoundEvents.field_187736_dY : SoundEvents.field_187804_ed;
    }

    public float func_110139_bj() {
        return ((Float)this.func_184212_Q().func_187225_a(PlayerEntityAccessor.accessor$DATA_PLAYER_ABSORPTION_ID())).floatValue();
    }

    public void func_110149_m(float amount) {
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        this.func_184212_Q().func_187227_b(PlayerEntityAccessor.accessor$DATA_PLAYER_ABSORPTION_ID(), (Object)Float.valueOf(amount));
    }

    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        float retValue = super.func_110146_f(p_110146_1_, p_110146_2_);
        this.field_70177_z = this.field_70759_as;
        return retValue;
    }

    public boolean func_70652_k(Entity entityIn) {
        super.func_70652_k(entityIn);
        this.func_184609_a(this.func_184600_cs());
        float f = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        int i = 0;
        i += EnchantmentHelper.func_77501_a((LivingEntity)this);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184586_b(Hand.MAIN_HAND), (CreatureAttribute)this.func_70668_bt()));
        if (flag) {
            int j;
            if (i > 0) {
                entityIn.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if ((j = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    private void setProfileName(@Nullable ITextComponent newName) {
        PropertyMap props = this.fakeProfile.getProperties();
        this.fakeProfile = new GameProfile(this.fakeProfile.getId(), newName == null ? "" : newName.getString());
        this.fakeProfile.getProperties().putAll((Multimap)props);
    }

    public boolean getOrLoadSkin(UUID minecraftAccount) {
        GameProfile gameProfile = SpongeCommon.getServer().func_152358_ax().func_152652_a(minecraftAccount);
        if (gameProfile == null) {
            gameProfile = SpongeCommon.getServer().func_147130_as().fillProfileProperties(new GameProfile(minecraftAccount, ""), true);
            if (gameProfile == null) {
                return false;
            }
            SpongeCommon.getServer().func_152358_ax().func_152649_a(gameProfile);
        }
        this.fakeProfile.getProperties().replaceValues((Object)"textures", (Iterable)gameProfile.getProperties().get((Object)"textures"));
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
        return true;
    }

    public boolean getOrLoadSkin(String minecraftAccount) {
        Objects.requireNonNull(minecraftAccount);
        GameProfile gameProfile = SpongeCommon.getServer().func_152358_ax().func_152655_a(minecraftAccount);
        if (gameProfile == null) {
            return false;
        }
        if (gameProfile.getProperties().isEmpty()) {
            gameProfile = SpongeCommon.getServer().func_147130_as().fillProfileProperties(gameProfile, true);
            SpongeCommon.getServer().func_152358_ax().func_152649_a(gameProfile);
        }
        this.fakeProfile.getProperties().clear();
        this.fakeProfile.getProperties().putAll((Multimap)gameProfile.getProperties());
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
        return true;
    }

    public void removeFromTabListDelayed(@Nullable ServerPlayerEntity player, SPlayerListItemPacket removePacket) {
        int delay = ((WorldConfig)SpongeGameConfigs.getForWorld((World)this.field_70170_p).get()).entity.human.tabListRemoveDelay;
        Runnable removeTask = () -> this.pushPackets(player, new IPacket[]{removePacket});
        if (delay == 0) {
            removeTask.run();
        } else {
            Sponge.getServer().getScheduler().submit(Task.builder().execute(removeTask).delay(new SpongeTicks(delay)).plugin(((Launch)Launch.getInstance()).getCommonPlugin()).build());
        }
    }

    public Property getSkinProperty() {
        Collection properties = this.fakeProfile.getProperties().get((Object)"textures");
        if (properties.isEmpty()) {
            return null;
        }
        return (Property)properties.iterator().next();
    }

    public void setSkinProperty(Property property) {
        this.fakeProfile.getProperties().replaceValues((Object)"textures", Collections.singletonList(property));
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
    }

    private boolean isAliveAndInWorld() {
        return this.field_70170_p.func_73045_a(this.func_145782_y()) == this && !this.field_70128_L;
    }

    private void respawnOnClient() {
        this.pushPackets(new IPacket[]{new SDestroyEntitiesPacket(new int[]{this.func_145782_y()}), this.createPlayerListPacket(SPlayerListItemPacket.Action.ADD_PLAYER)});
        this.pushPackets(new IPacket[]{this.getAddEntityPacket()});
        this.removeFromTabListDelayed(null, this.createPlayerListPacket(SPlayerListItemPacket.Action.REMOVE_PLAYER));
    }

    public boolean canRemoveFromListImmediately() {
        return !this.fakeProfile.getProperties().containsKey((Object)"textures");
    }

    public void untrackFrom(ServerPlayerEntity player) {
        this.playerPacketMap.remove(player.func_110124_au());
        player.field_71135_a.func_147359_a((IPacket)this.createPlayerListPacket(SPlayerListItemPacket.Action.REMOVE_PLAYER));
    }

    public SSpawnPlayerPacket getAddEntityPacket() {
        SSpawnPlayerPacket packet = new SSpawnPlayerPacket();
        SSpawnPlayerPacketAccessor accessor = (SSpawnPlayerPacketAccessor)packet;
        accessor.accessor$entityId(this.func_145782_y());
        accessor.accessor$playerId(this.fakeProfile.getId());
        accessor.accessor$x(this.func_226277_ct_());
        accessor.accessor$y(this.func_226278_cu_());
        accessor.accessor$z(this.func_226281_cx_());
        accessor.accessor$yRot((byte)(this.field_70177_z * 256.0f / 360.0f));
        accessor.accessor$xRot((byte)(this.field_70125_A * 256.0f / 360.0f));
        return packet;
    }

    public SPlayerListItemPacket createPlayerListPacket(SPlayerListItemPacket.Action action) {
        SPlayerListItemPacket packet = new SPlayerListItemPacket(action, new ServerPlayerEntity[0]);
        List<SPlayerListItemPacket.AddPlayerData> list = ((SPlayerListItemPacketAccessor)packet).accessor$entries();
        SPlayerListItemPacket sPlayerListItemPacket = packet;
        sPlayerListItemPacket.getClass();
        list.add(new SPlayerListItemPacket.AddPlayerData(sPlayerListItemPacket, this.fakeProfile, 0, GameType.NOT_SET, this.func_145748_c_()));
        return packet;
    }

    public void pushPackets(IPacket<?> ... packets) {
        this.pushPackets((ServerPlayerEntity)null, packets);
    }

    public void pushPackets(@Nullable ServerPlayerEntity player, IPacket<?> ... packets) {
        List queue = player == null ? this.playerPacketMap.computeIfAbsent(null, k -> new ArrayList()) : this.playerPacketMap.computeIfAbsent(player.func_110124_au(), k -> new ArrayList());
        queue.add(Stream.of(packets));
    }

    public Stream<IPacket<?>> popQueuedPackets(@Nullable ServerPlayerEntity player) {
        List<Stream<IPacket<?>>> queue = this.playerPacketMap.get(player == null ? null : player.func_110124_au());
        return queue == null || queue.isEmpty() ? Stream.empty() : queue.remove(0);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack;
        ArrowEntity entitytippedarrow = new ArrowEntity(this.field_70170_p, (LivingEntity)this);
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - entitytippedarrow.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entitytippedarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (LivingEntity)this);
        int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (LivingEntity)this);
        entitytippedarrow.func_70239_b((double)(distanceFactor * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            entitytippedarrow.func_70239_b(entitytippedarrow.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entitytippedarrow.func_70240_a(j);
        }
        if ((itemstack = this.func_184586_b(Hand.OFF_HAND)).func_77973_b() == Items.field_185167_i) {
            entitytippedarrow.func_184555_a(itemstack);
        }
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)entitytippedarrow);
    }
}

