/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player.tab;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerListHeaderFooterPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.common.accessor.network.play.server.SPlayerListHeaderFooterPacketAccessor;
import org.spongepowered.common.accessor.network.play.server.SPlayerListItemPacketAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.entity.player.tab.SpongeTabListEntry;
import org.spongepowered.common.profile.SpongeGameProfile;

public final class SpongeTabList
implements TabList {
    private static final ITextComponent EMPTY_COMPONENT = new StringTextComponent("");
    private final ServerPlayerEntity player;
    private @Nullable Component header;
    private @Nullable Component footer;
    private final Map<UUID, TabListEntry> entries = Maps.newHashMap();

    public SpongeTabList(ServerPlayerEntity player) {
        this.player = player;
    }

    @Override
    public ServerPlayer getPlayer() {
        return (ServerPlayer)this.player;
    }

    @Override
    public Optional<Component> getHeader() {
        return Optional.ofNullable(this.header);
    }

    @Override
    public TabList setHeader(@Nullable Component header) {
        this.header = header;
        this.refreshClientHeaderFooter();
        return this;
    }

    @Override
    public Optional<Component> getFooter() {
        return Optional.ofNullable(this.footer);
    }

    @Override
    public TabList setFooter(@Nullable Component footer) {
        this.footer = footer;
        this.refreshClientHeaderFooter();
        return this;
    }

    @Override
    public TabList setHeaderAndFooter(@Nullable Component header, @Nullable Component footer) {
        this.header = header;
        this.footer = footer;
        this.refreshClientHeaderFooter();
        return this;
    }

    private void refreshClientHeaderFooter() {
        SPlayerListHeaderFooterPacket packet = new SPlayerListHeaderFooterPacket();
        ((SPlayerListHeaderFooterPacketAccessor)packet).accessor$header(this.header == null ? EMPTY_COMPONENT : SpongeAdventure.asVanilla(this.header));
        ((SPlayerListHeaderFooterPacketAccessor)packet).accessor$footer(this.footer == null ? EMPTY_COMPONENT : SpongeAdventure.asVanilla(this.footer));
        this.player.field_71135_a.func_147359_a((IPacket)packet);
    }

    @Override
    public Collection<TabListEntry> getEntries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    @Override
    public Optional<TabListEntry> getEntry(UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId, (Object)"unique id");
        return Optional.ofNullable(this.entries.get(uniqueId));
    }

    @Override
    public TabList addEntry(TabListEntry entry) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)entry, (Object)"builder");
        Preconditions.checkState((boolean)entry.getList().equals(this), (Object)"the provided tab list entry was not created for this tab list");
        this.addEntry(entry, true);
        return this;
    }

    private void addEntry(SPlayerListItemPacket.AddPlayerData entry) {
        if (!this.entries.containsKey(entry.func_179962_a().getId())) {
            this.addEntry(new SpongeTabListEntry(this, SpongeGameProfile.of(entry.func_179962_a()), entry.func_179961_d() == null ? null : SpongeAdventure.asAdventure(entry.func_179961_d()), entry.func_179963_b(), (GameMode)entry.func_179960_c()), false);
        }
    }

    private void addEntry(TabListEntry entry, boolean exceptionOnDuplicate) {
        UUID uniqueId = entry.getProfile().getUniqueId();
        if (exceptionOnDuplicate) {
            Preconditions.checkArgument((!this.entries.containsKey(uniqueId) ? 1 : 0) != 0, (Object)"cannot add duplicate entry");
        }
        if (!this.entries.containsKey(uniqueId)) {
            this.entries.put(uniqueId, entry);
            this.sendUpdate(entry, SPlayerListItemPacket.Action.ADD_PLAYER);
            entry.getDisplayName().ifPresent(text -> this.sendUpdate(entry, SPlayerListItemPacket.Action.UPDATE_DISPLAY_NAME));
            this.sendUpdate(entry, SPlayerListItemPacket.Action.UPDATE_LATENCY);
            this.sendUpdate(entry, SPlayerListItemPacket.Action.UPDATE_GAME_MODE);
        }
    }

    @Override
    public Optional<TabListEntry> removeEntry(UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId, (Object)"unique id");
        if (this.entries.containsKey(uniqueId)) {
            TabListEntry entry = this.entries.remove(uniqueId);
            this.sendUpdate(entry, SPlayerListItemPacket.Action.REMOVE_PLAYER);
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    void sendUpdate(TabListEntry entry, SPlayerListItemPacket.Action action) {
        SPlayerListItemPacket packet = new SPlayerListItemPacket();
        ((SPlayerListItemPacketAccessor)packet).accessor$action(action);
        SPlayerListItemPacket sPlayerListItemPacket = packet;
        sPlayerListItemPacket.getClass();
        SPlayerListItemPacket.AddPlayerData data = new SPlayerListItemPacket.AddPlayerData(sPlayerListItemPacket, SpongeGameProfile.toMcProfile(entry.getProfile()), entry.getLatency(), (GameType)entry.getGameMode(), entry.getDisplayName().isPresent() ? SpongeAdventure.asVanilla(entry.getDisplayName().get()) : null);
        ((SPlayerListItemPacketAccessor)packet).accessor$entries().add(data);
        this.player.field_71135_a.func_147359_a((IPacket)packet);
    }

    public void updateEntriesOnSend(SPlayerListItemPacket packet) {
        for (SPlayerListItemPacket.AddPlayerData data : ((SPlayerListItemPacketAccessor)packet).accessor$entries()) {
            SPlayerListItemPacket.Action action = ((SPlayerListItemPacketAccessor)packet).accessor$action();
            if (action == SPlayerListItemPacket.Action.ADD_PLAYER) {
                this.addEntry(data);
                continue;
            }
            if (action == SPlayerListItemPacket.Action.REMOVE_PLAYER) {
                this.removeEntry(data.func_179962_a().getId());
                continue;
            }
            this.getEntry(data.func_179962_a().getId()).ifPresent(entry -> {
                if (action == SPlayerListItemPacket.Action.UPDATE_DISPLAY_NAME) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setDisplayName(data.func_179961_d() == null ? null : SpongeAdventure.asAdventure(data.func_179961_d()));
                } else if (action == SPlayerListItemPacket.Action.UPDATE_LATENCY) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setLatency(data.func_179963_b());
                } else if (action == SPlayerListItemPacket.Action.UPDATE_GAME_MODE) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setGameMode((GameMode)data.func_179960_c());
                } else {
                    throw new IllegalArgumentException("unknown packet action: " + action);
                }
            });
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("player", (Object)this.player).add("header", (Object)this.header).add("footer", (Object)this.footer).add("entries", this.entries).toString();
    }
}

