/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.MerchantContainer;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CCreativeInventoryActionPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ChangeEntityEquipmentEvent;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.CraftItemEvent;
import org.spongepowered.api.event.item.inventory.EnchantItemEvent;
import org.spongepowered.api.event.item.inventory.TransferInventoryEvent;
import org.spongepowered.api.event.item.inventory.UpdateAnvilEvent;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.event.item.inventory.container.InteractContainerEvent;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.inventory.AnvilCost;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.crafting.CraftingOutput;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.item.inventory.type.ViewableInventory;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.inventory.container.ContainerBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedContainerBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.inventory.UpdateAnvilEventCost;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.inventory.util.ContainerUtil;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.enchantment.SpongeRandomEnchantmentListBuilder;
import org.spongepowered.common.item.util.ItemStackUtil;

public class InventoryEventFactory {
    public static boolean callPlayerChangeInventoryPickupPreEvent(PlayerEntity player, ItemEntity itemToPickup, int pickupDelay) {
        net.minecraft.item.ItemStack stack = itemToPickup.func_92059_d();
        CauseStackManager causeStackManager = PhaseTracker.getCauseStackManager();
        causeStackManager.pushCause(player);
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
        ChangeInventoryEvent.Pickup.Pre event = SpongeEventFactory.createChangeInventoryEventPickupPre(causeStackManager.getCurrentCause(), Optional.empty(), Collections.singletonList(snapshot), (Inventory)player.field_71071_by, (Item)itemToPickup, snapshot);
        SpongeCommon.postEvent(event);
        causeStackManager.popCause();
        if (event.isCancelled()) {
            return false;
        }
        if (event.getCustom().isPresent()) {
            List<ItemStackSnapshot> list = event.getCustom().get();
            if (list.isEmpty()) {
                itemToPickup.func_92059_d().func_190920_e(0);
                return false;
            }
            boolean fullTransfer = true;
            TrackedInventoryBridge capture = (TrackedInventoryBridge)player.field_71071_by;
            capture.bridge$setCaptureInventory(true);
            for (ItemStackSnapshot item : list) {
                ItemStack itemStack = item.createStack();
                player.field_71071_by.func_70441_a(ItemStackUtil.toNative(itemStack));
                if (itemStack.isEmpty()) continue;
                fullTransfer = false;
                break;
            }
            capture.bridge$setCaptureInventory(false);
            if (!fullTransfer) {
                for (SlotTransaction trans : capture.bridge$getCapturedSlotTransactions()) {
                    trans.getSlot().set(((ItemStackSnapshot)trans.getOriginal()).createStack());
                }
                return false;
            }
            if (!InventoryEventFactory.callPlayerChangeInventoryPickupEvent(player, capture)) {
                return false;
            }
            itemToPickup.func_92059_d().func_190920_e(0);
        }
        return true;
    }

    public static boolean callPlayerChangeInventoryPickupEvent(PlayerEntity player, TrackedInventoryBridge inventory) {
        if (inventory.bridge$getCapturedSlotTransactions().isEmpty()) {
            return true;
        }
        PhaseTracker.getCauseStackManager().pushCause(player);
        ChangeInventoryEvent.Pickup event = SpongeEventFactory.createChangeInventoryEventPickup(PhaseTracker.getCauseStackManager().getCurrentCause(), (Inventory)player.field_71070_bA, inventory.bridge$getCapturedSlotTransactions());
        SpongeCommon.postEvent(event);
        PhaseTracker.getCauseStackManager().popCause();
        InventoryEventFactory.applyTransactions(event);
        inventory.bridge$getCapturedSlotTransactions().clear();
        return !event.isCancelled();
    }

    public static net.minecraft.item.ItemStack callInventoryPickupEvent(IInventory inventory, ItemEntity item, net.minecraft.item.ItemStack stack) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(inventory);
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            ChangeInventoryEvent.Pickup.Pre event = SpongeEventFactory.createChangeInventoryEventPickupPre(frame.getCurrentCause(), Optional.empty(), Collections.singletonList(snapshot), (Inventory)inventory, (Item)item, snapshot);
            SpongeCommon.postEvent(event);
            if (event.isCancelled()) {
                net.minecraft.item.ItemStack itemStack = stack;
                return itemStack;
            }
            int size = inventory.func_70302_i_();
            net.minecraft.item.ItemStack[] prevInventory = new net.minecraft.item.ItemStack[size];
            for (int i = 0; i < size; ++i) {
                prevInventory[i] = inventory.func_70301_a(i);
            }
            if (event.getCustom().isPresent()) {
                net.minecraft.item.ItemStack itemStack;
                if (event.getCustom().get().isEmpty()) {
                    net.minecraft.item.ItemStack i = net.minecraft.item.ItemStack.field_190927_a;
                    return i;
                }
                boolean fullTransfer = true;
                for (ItemStackSnapshot snap : event.getCustom().get()) {
                    net.minecraft.item.ItemStack stackToAdd = ItemStackUtil.fromSnapshotToNative(snap);
                    net.minecraft.item.ItemStack remaining = HopperTileEntity.func_174918_a(null, (IInventory)inventory, (net.minecraft.item.ItemStack)stackToAdd, null);
                    if (remaining.func_190926_b()) continue;
                    fullTransfer = false;
                    break;
                }
                if (!fullTransfer) {
                    for (int i = 0; i < prevInventory.length; ++i) {
                        inventory.func_70299_a(i, prevInventory[i]);
                    }
                    net.minecraft.item.ItemStack itemStack2 = stack;
                    return itemStack2;
                }
                if (InventoryEventFactory.callInventoryPickupEvent(inventory, prevInventory)) {
                    itemStack = net.minecraft.item.ItemStack.field_190927_a;
                    return itemStack;
                }
                itemStack = stack;
                return itemStack;
            }
            net.minecraft.item.ItemStack remainder = HopperTileEntity.func_174918_a(null, (IInventory)inventory, (net.minecraft.item.ItemStack)stack, null);
            if (InventoryEventFactory.callInventoryPickupEvent(inventory, prevInventory)) {
                net.minecraft.item.ItemStack itemStack = remainder;
                return itemStack;
            }
            net.minecraft.item.ItemStack itemStack = stack;
            return itemStack;
        }
    }

    private static boolean callInventoryPickupEvent(IInventory inventory, net.minecraft.item.ItemStack[] prevInventory) {
        Inventory spongeInventory = InventoryUtil.toInventory(inventory, null);
        List<SlotTransaction> trans = InventoryEventFactory.generateTransactions(spongeInventory, inventory, prevInventory);
        if (trans.isEmpty()) {
            return true;
        }
        ChangeInventoryEvent.Pickup event = SpongeEventFactory.createChangeInventoryEventPickup(PhaseTracker.getCauseStackManager().getCurrentCause(), spongeInventory, trans);
        SpongeCommon.postEvent(event);
        InventoryEventFactory.applyTransactions(event);
        return !event.isCancelled();
    }

    private static List<SlotTransaction> generateTransactions(@Nullable Inventory inv, IInventory inventory, net.minecraft.item.ItemStack[] previous) {
        if (inv == null) {
            return Collections.emptyList();
        }
        ArrayList<SlotTransaction> trans = new ArrayList<SlotTransaction>();
        List<Slot> slots = inv.slots();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            net.minecraft.item.ItemStack prevStack;
            Slot slot = slots.get(i);
            net.minecraft.item.ItemStack newStack = inventory.func_70301_a(i);
            if (net.minecraft.item.ItemStack.func_77989_b((net.minecraft.item.ItemStack)newStack, (net.minecraft.item.ItemStack)(prevStack = previous[i]))) continue;
            trans.add(new SlotTransaction(slot, ItemStackUtil.snapshotOf(prevStack), ItemStackUtil.snapshotOf(newStack)));
        }
        return trans;
    }

    private static void applyTransactions(ChangeInventoryEvent.Pickup event) {
        if (event.isCancelled()) {
            for (SlotTransaction trans : event.getTransactions()) {
                trans.getSlot().set(((ItemStackSnapshot)trans.getOriginal()).createStack());
            }
            return;
        }
        for (SlotTransaction trans : event.getTransactions()) {
            if (!trans.isValid()) {
                trans.getSlot().set(((ItemStackSnapshot)trans.getOriginal()).createStack());
                continue;
            }
            if (!trans.getCustom().isPresent()) continue;
            trans.getSlot().set(((ItemStackSnapshot)trans.getFinal()).createStack());
        }
    }

    public static ClickContainerEvent.Creative callCreativeClickContainerEvent(ServerPlayerEntity player, CCreativeInventoryActionPacket packetIn) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.empty(), ItemStackSnapshot.empty());
            Slot slot = null;
            List<SlotTransaction> captures = ((TrackedInventoryBridge)player.field_71070_bA).bridge$getCapturedSlotTransactions();
            if (captures.isEmpty() && packetIn.func_149627_c() >= 0 && packetIn.func_149627_c() < player.field_71070_bA.field_75151_b.size() && (slot = (Slot)((InventoryAdapter)player.field_71070_bA).inventoryAdapter$getSlot(packetIn.func_149627_c()).orElse(null)) != null) {
                ItemStackSnapshot clickedItem = ItemStackUtil.snapshotOf(slot.peek());
                ItemStackSnapshot replacement = ItemStackUtil.snapshotOf(packetIn.func_149625_d());
                SlotTransaction slotTransaction = new SlotTransaction(slot, clickedItem, replacement);
                captures.add(slotTransaction);
            }
            ClickContainerEvent.Creative event = SpongeEventFactory.createClickContainerEventCreative(frame.getCurrentCause(), (Container)player.field_71070_bA, cursorTransaction, Optional.ofNullable(slot), new ArrayList<SlotTransaction>(captures));
            captures.clear();
            ((TrackedInventoryBridge)player.field_71070_bA).bridge$setCaptureInventory(false);
            SpongeCommon.postEvent(event);
            frame.popCause();
            ClickContainerEvent.Creative creative = event;
            return creative;
        }
    }

    public static boolean callInteractContainerOpenEvent(ServerPlayerEntity player) {
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.empty(), newCursor);
        InteractContainerEvent.Open event = SpongeEventFactory.createInteractContainerEventOpen(PhaseTracker.getCauseStackManager().getCurrentCause(), (Container)player.field_71070_bA, cursorTransaction);
        SpongeCommon.postEvent(event);
        if (event.isCancelled()) {
            player.func_71053_j();
            return false;
        }
        if (event.getCursorTransaction().getCustom().isPresent()) {
            PacketPhaseUtil.handleCustomCursor((PlayerEntity)player, event.getCursorTransaction().getFinal());
        }
        return true;
    }

    @Nullable
    public static net.minecraft.inventory.container.Container displayContainer(ServerPlayerEntity player, Inventory inventory, Component displayName) {
        net.minecraft.inventory.container.Container container;
        net.minecraft.inventory.container.Container previousContainer = player.field_71070_bA;
        Optional<ViewableInventory> viewable = inventory.asViewable();
        if (viewable.isPresent()) {
            if (viewable.get() instanceof INamedContainerProvider) {
                INamedContainerProvider namedContainerProvider = (INamedContainerProvider)viewable.get();
                if (displayName != null) {
                    namedContainerProvider = new SimpleNamedContainerProvider((IContainerProvider)namedContainerProvider, SpongeAdventure.asVanilla(displayName));
                }
                player.func_213829_a(namedContainerProvider);
            } else if (viewable.get() instanceof CarriedInventory) {
                Optional carrier = ((CarriedInventory)((Object)viewable.get())).getCarrier();
                if (carrier.get() instanceof AbstractHorseEntity) {
                    player.func_184826_a((AbstractHorseEntity)carrier.get(), (IInventory)viewable.get());
                }
            } else if (viewable.get() instanceof IMerchant) {
                OptionalInt containerId;
                IMerchant merchant = (IMerchant)viewable.get();
                ITextComponent display = null;
                int level = 0;
                if (merchant instanceof VillagerEntity) {
                    display = ((VillagerEntity)merchant).func_145748_c_();
                    level = ((VillagerEntity)merchant).func_213700_eh().func_221132_c();
                } else if (merchant instanceof WanderingTraderEntity) {
                    display = ((WanderingTraderEntity)merchant).func_145748_c_();
                    level = 1;
                }
                if (displayName != null) {
                    display = SpongeAdventure.asVanilla(displayName);
                }
                if ((containerId = player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInv, p) -> new MerchantContainer(id, playerInv, merchant), display))).isPresent() && !merchant.func_213706_dY().isEmpty()) {
                    player.func_213818_a(containerId.getAsInt(), merchant.func_213706_dY(), level, merchant.func_213708_dV(), merchant.func_213705_dZ(), merchant.func_223340_ej());
                }
            }
        }
        if (previousContainer == (container = player.field_71070_bA)) {
            return null;
        }
        if (!InventoryEventFactory.callInteractContainerOpenEvent(player)) {
            return null;
        }
        if (container instanceof ContainerBridge) {
            ((ContainerBridge)container).bridge$setCanInteractWith(p -> !p.field_70128_L);
        }
        return container;
    }

    public static TransferInventoryEvent.Pre callTransferPre(Inventory source, Inventory destination) {
        PhaseTracker.getCauseStackManager().pushCause(source);
        TransferInventoryEvent.Pre event = SpongeEventFactory.createTransferInventoryEventPre(PhaseTracker.getCauseStackManager().getCurrentCause(), source, destination);
        SpongeCommon.postEvent(event);
        PhaseTracker.getCauseStackManager().popCause();
        return event;
    }

    public static void callTransferPost(@Nullable TrackedInventoryBridge captureSource, @Nullable Inventory source, @Nullable Inventory destination, net.minecraft.item.ItemStack sourceStack, SlotTransaction sourceSlotTransaction) {
        if (captureSource == null || source == null || destination == null || sourceSlotTransaction == null) {
            return;
        }
        PhaseTracker.getCauseStackManager().pushCause(source);
        List<SlotTransaction> slotTransactions = captureSource.bridge$getCapturedSlotTransactions();
        sourceStack = sourceStack.func_77946_l();
        sourceStack.func_190920_e(1);
        ItemStackSnapshot transferredStack = ItemStackUtil.snapshotOf(sourceStack);
        Slot sourceSlot = sourceSlotTransaction.getSlot();
        Slot targetSlot = null;
        for (SlotTransaction transaction : slotTransactions) {
            if (transaction == sourceSlotTransaction) continue;
            targetSlot = transaction.getSlot();
            break;
        }
        TransferInventoryEvent.Post event = SpongeEventFactory.createTransferInventoryEventPost(PhaseTracker.getCauseStackManager().getCurrentCause(), source, sourceSlot, destination, targetSlot, transferredStack);
        SpongeCommon.postEvent(event);
        slotTransactions.clear();
        PhaseTracker.getCauseStackManager().popCause();
    }

    public static SlotTransaction captureTransaction(@Nullable TrackedInventoryBridge captureIn, @Nullable Inventory inv, int index, net.minecraft.item.ItemStack originalStack) {
        if (captureIn == null || inv == null) {
            return null;
        }
        Optional<Slot> slot = inv.getSlot(index);
        if (slot.isPresent()) {
            SlotTransaction trans = new SlotTransaction(slot.get(), ItemStackUtil.snapshotOf(originalStack), ItemStackUtil.snapshotOf(slot.get().peek()));
            captureIn.bridge$getCapturedSlotTransactions().add(trans);
            return trans;
        }
        SpongeCommon.getLogger().warn("Unable to capture transaction from " + inv.getClass() + " at index " + index);
        return null;
    }

    public static net.minecraft.item.ItemStack captureTransaction(@Nullable TrackedInventoryBridge captureIn, @Nullable Inventory inv, int index, Supplier<net.minecraft.item.ItemStack> transaction) {
        if (captureIn == null || inv == null) {
            return transaction.get();
        }
        Optional<Slot> slot = inv.getSlot(index);
        if (!slot.isPresent()) {
            SpongeCommon.getLogger().warn("Unable to capture transaction from " + inv.getClass() + " at index " + index);
            return transaction.get();
        }
        ItemStackSnapshot original = ItemStackUtil.snapshotOf(slot.get().peek());
        net.minecraft.item.ItemStack remaining = transaction.get();
        if (remaining.func_190926_b()) {
            ItemStackSnapshot replacement = ItemStackUtil.snapshotOf(slot.get().peek());
            captureIn.bridge$getCapturedSlotTransactions().add(new SlotTransaction(slot.get(), original, replacement));
        }
        return remaining;
    }

    public static CraftItemEvent.Preview callCraftEventPre(PlayerEntity player, CraftingInventory inventory, SlotTransaction previewTransaction, @Nullable CraftingRecipe recipe, net.minecraft.inventory.container.Container container, List<SlotTransaction> transactions) {
        CraftItemEvent.Preview event = SpongeEventFactory.createCraftItemEventPreview(PhaseTracker.getCauseStackManager().getCurrentCause(), inventory, (Inventory)container, previewTransaction, Optional.ofNullable(recipe), transactions);
        SpongeCommon.postEvent(event);
        PacketPhaseUtil.handleSlotRestore(player, container, new ArrayList<SlotTransaction>(transactions), event.isCancelled());
        if (player instanceof ServerPlayerEntity && (event.getPreview().getCustom().isPresent() || event.isCancelled() || !event.getPreview().isValid())) {
            ItemStackSnapshot stack = (ItemStackSnapshot)event.getPreview().getFinal();
            if (event.isCancelled() || !event.getPreview().isValid()) {
                stack = (ItemStackSnapshot)event.getPreview().getOriginal();
            }
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(0, 0, ItemStackUtil.fromSnapshotToNative(stack)));
        }
        return event;
    }

    public static CraftItemEvent.Craft callCraftEventPost(PlayerEntity player, CraftingInventory inventory, ItemStackSnapshot result, @Nullable CraftingRecipe recipe, net.minecraft.inventory.container.Container container, List<SlotTransaction> transactions) {
        net.minecraft.item.ItemStack previousCursor = ((TrackedContainerBridge)container).bridge$getPreviousCursor();
        if (previousCursor == null) {
            previousCursor = player.field_71071_by.func_70445_o();
        }
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(ItemStackUtil.snapshotOf(previousCursor), ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o()));
        CraftingOutput slot = inventory.getResult();
        CraftItemEvent.Craft event = SpongeEventFactory.createCraftItemEventCraft(PhaseTracker.getCauseStackManager().getCurrentCause(), ContainerUtil.fromNative(container), result, inventory, cursorTransaction, Optional.ofNullable(recipe), Optional.of(slot), transactions);
        SpongeCommon.postEvent(event);
        boolean capture = ((TrackedInventoryBridge)container).bridge$capturingInventory();
        ((TrackedInventoryBridge)container).bridge$setCaptureInventory(false);
        PacketPhaseUtil.handleSlotRestore(player, container, new ArrayList<SlotTransaction>(transactions), event.isCancelled());
        if (event.isCancelled() || !event.getCursorTransaction().isValid() || event.getCursorTransaction().getCustom().isPresent()) {
            ItemStackSnapshot newCursor = event.isCancelled() || event.getCursorTransaction().isValid() ? event.getCursorTransaction().getOriginal() : event.getCursorTransaction().getFinal();
            player.field_71071_by.func_70437_b(ItemStackUtil.fromSnapshotToNative(newCursor));
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, player.field_71071_by.func_70445_o()));
            }
        }
        transactions.clear();
        ((TrackedInventoryBridge)container).bridge$setCaptureInventory(capture);
        return event;
    }

    public static UpdateAnvilEvent callUpdateAnvilEvent(RepairContainer anvil, net.minecraft.item.ItemStack slot1, net.minecraft.item.ItemStack slot2, net.minecraft.item.ItemStack result, String name, int levelCost, int materialCost) {
        Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.empty(), ItemStackUtil.snapshotOf(result));
        UpdateAnvilEventCost costs = new UpdateAnvilEventCost(levelCost, materialCost);
        UpdateAnvilEvent event = SpongeEventFactory.createUpdateAnvilEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), new Transaction<AnvilCost>(costs, costs), (Inventory)anvil, name, ItemStackUtil.snapshotOf(slot1), transaction, ItemStackUtil.snapshotOf(slot2));
        SpongeCommon.postEvent(event);
        return event;
    }

    public static ChangeEntityEquipmentEvent callChangeEntityEquipmentEvent(LivingEntity entity, ItemStackSnapshot before, ItemStackSnapshot after, SlotAdapter slot) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entity);
            Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(before, after);
            ChangeEntityEquipmentEvent event = after.isEmpty() ? SpongeEventFactory.createChangeEntityEquipmentEventBreak(frame.getCurrentCause(), (Entity)entity, slot, transaction) : SpongeEventFactory.createChangeEntityEquipmentEvent(frame.getCurrentCause(), (Entity)entity, slot, transaction);
            SpongeCommon.postEvent(event);
            ChangeEntityEquipmentEvent changeEntityEquipmentEvent = event;
            return changeEntityEquipmentEvent;
        }
    }

    public static int callEnchantEventLevelRequirement(EnchantmentContainer container, int seed, int option, int power, net.minecraft.item.ItemStack itemStack, int levelRequirement) {
        Container enchantContainer = ContainerUtil.fromNative((net.minecraft.inventory.container.Container)container);
        PlayerEntity viewer = (PlayerEntity)enchantContainer.getViewer();
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(viewer.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> cursorTrans = new Transaction<ItemStackSnapshot>(cursor, cursor);
        EnchantItemEvent.CalculateLevelRequirement event = SpongeEventFactory.createEnchantItemEventCalculateLevelRequirement(PhaseTracker.getCauseStackManager().getCurrentCause(), levelRequirement, levelRequirement, enchantContainer, cursorTrans, ItemStackUtil.snapshotOf(itemStack), option, power, seed);
        SpongeCommon.postEvent(event);
        return event.getLevelRequirement();
    }

    public static List<EnchantmentData> callEnchantEventEnchantmentList(EnchantmentContainer container, int seed, net.minecraft.item.ItemStack itemStack, int option, int level, List<EnchantmentData> list) {
        List<Enchantment> enchList = Collections.unmodifiableList(SpongeRandomEnchantmentListBuilder.fromNative(list));
        Container enchantContainer = ContainerUtil.fromNative((net.minecraft.inventory.container.Container)container);
        PlayerEntity viewer = (PlayerEntity)enchantContainer.getViewer();
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(viewer.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> cursorTrans = new Transaction<ItemStackSnapshot>(cursor, cursor);
        EnchantItemEvent.CalculateEnchantment event = SpongeEventFactory.createEnchantItemEventCalculateEnchantment(PhaseTracker.getCauseStackManager().getCurrentCause(), enchList, enchList, enchantContainer, cursorTrans, ItemStackUtil.snapshotOf(itemStack), level, option, seed);
        SpongeCommon.postEvent(event);
        if (event.getEnchantments() != event.getOriginalEnchantments()) {
            return SpongeRandomEnchantmentListBuilder.toNative(event.getEnchantments());
        }
        return list;
    }

    public static EnchantItemEvent.Post callEnchantEventEnchantPost(PlayerEntity playerIn, EnchantmentContainer container, SlotTransaction enchantedItem, SlotTransaction lapisItem, int option, int seed) {
        Container enchantContainer = ContainerUtil.fromNative((net.minecraft.inventory.container.Container)container);
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(playerIn.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> cursorTrans = new Transaction<ItemStackSnapshot>(cursor, cursor);
        ArrayList<SlotTransaction> slotTrans = new ArrayList<SlotTransaction>();
        slotTrans.add(lapisItem);
        slotTrans.add(enchantedItem);
        EnchantItemEvent.Post event = SpongeEventFactory.createEnchantItemEventPost(PhaseTracker.getCauseStackManager().getCurrentCause(), enchantContainer, cursorTrans, enchantedItem.getSlot(), Optional.empty(), slotTrans, option, seed);
        SpongeCommon.postEvent(event);
        PacketPhaseUtil.handleSlotRestore(playerIn, (net.minecraft.inventory.container.Container)container, event.getTransactions(), event.isCancelled());
        if (event.isCancelled() || !event.getCursorTransaction().isValid()) {
            PacketPhaseUtil.handleCustomCursor(playerIn, event.getCursorTransaction().getOriginal());
        } else if (event.getCursorTransaction().getCustom().isPresent()) {
            PacketPhaseUtil.handleCustomCursor(playerIn, event.getCursorTransaction().getFinal());
        }
        return event;
    }
}

