/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.LootContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.block.TrackerBlockEventDataBridge;
import org.spongepowered.common.bridge.util.concurrent.TrackedTickDelayedTaskBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickContext;
import org.spongepowered.common.world.BlockChange;

public interface IPhaseState<C extends PhaseContext<C>> {
    public static final BiConsumer<CauseStackManager.StackFrame, ? extends PhaseContext<@NonNull ?>> DEFAULT_OWNER_NOTIFIER = (frame, ctx) -> {
        if (ctx.usedFrame == null) {
            ctx.usedFrame = new ArrayDeque<CauseStackManager.StackFrame>();
        }
        ctx.usedFrame.push((CauseStackManager.StackFrame)frame);
        if (ctx.creator != null) {
            frame.addContext(EventContextKeys.CREATOR, ctx.creator);
        }
        if (ctx.notifier != null) {
            frame.addContext(EventContextKeys.NOTIFIER, ctx.notifier);
        }
    };

    public C createPhaseContext(PhaseTracker var1);

    default public BiConsumer<CauseStackManager.StackFrame, C> getFrameModifier() {
        return DEFAULT_OWNER_NOTIFIER;
    }

    default public boolean isNotReEntrant() {
        return true;
    }

    default public boolean isInteraction() {
        return false;
    }

    default public boolean isTicking() {
        return false;
    }

    default public boolean isWorldGeneration() {
        return false;
    }

    default public boolean includesDecays() {
        return false;
    }

    default public boolean isEvent() {
        return false;
    }

    public void unwind(C var1);

    default public void postBlockTransactionApplication(BlockChange blockChange, Transaction<? extends BlockSnapshot> snapshotTransaction, C context) {
    }

    default public boolean tracksCreatorsAndNotifiers() {
        return true;
    }

    default public boolean doesAllowEntitySpawns() {
        return true;
    }

    default public boolean doesDenyChunkRequests(C context) {
        return false;
    }

    default public boolean doesBlockEventTracking(C context) {
        return true;
    }

    default public boolean isCollision() {
        return false;
    }

    default public boolean ignoresBlockEvent() {
        return false;
    }

    default public boolean ignoresBlockUpdateTick(C context) {
        return false;
    }

    default public boolean ignoresScheduledUpdates() {
        return false;
    }

    default public boolean alreadyCapturingBlockTicks(C context) {
        return false;
    }

    default public boolean alreadyCapturingEntitySpawns() {
        return false;
    }

    default public boolean alreadyCapturingEntityTicks() {
        return false;
    }

    default public boolean alreadyCapturingTileTicks() {
        return false;
    }

    default public boolean requiresPost() {
        return true;
    }

    default public boolean handlesOwnStateCompletion() {
        return false;
    }

    default public void associateNeighborStateNotifier(C unwindingContext, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, ServerWorld minecraftWorld, PlayerTracker.Type notifier) {
    }

    default public void appendContextPreExplosion(ExplosionContext explosionContext, C currentPhaseData) {
    }

    default public void appendNotifierPreBlockTick(ServerWorld world, BlockPos pos, C context, LocationBasedTickContext<@NonNull ?> phaseContext) {
        Chunk chunk = world.func_175726_f(pos);
        ChunkBridge mixinChunk = (ChunkBridge)chunk;
        if (chunk != null && !chunk.func_76621_g()) {
            mixinChunk.bridge$getBlockCreator(pos).ifPresent(phaseContext::creator);
            mixinChunk.bridge$getBlockNotifier(pos).ifPresent(phaseContext::notifier);
        }
    }

    default public void appendNotifierToBlockEvent(C context, TrackedWorldBridge mixinWorldServer, BlockPos pos, TrackerBlockEventDataBridge blockEvent) {
    }

    default public void capturePlayerUsingStackToBreakBlock(ItemStack itemStack, @Nullable ServerPlayerEntity playerIn, C context) {
    }

    default public boolean allowsEventListener() {
        return true;
    }

    default public boolean isRegeneration() {
        return false;
    }

    default public ChangeBlock createTransaction(C phaseContext, SpongeBlockSnapshot originalBlockSnapshot, BlockState newState, BlockChangeFlag flags) {
        ChangeBlock changeBlock = ((PhaseContext)phaseContext).getTransactor().logBlockChange(originalBlockSnapshot, newState, flags);
        return changeBlock;
    }

    default public boolean doesCaptureNeighborNotifications(C context) {
        return false;
    }

    default public BlockChange associateBlockChangeWithSnapshot(C phaseContext, BlockState newState, Block newBlock, BlockState currentState, SpongeBlockSnapshot snapshot, Block originalBlock) {
        if (newBlock == Blocks.field_150350_a) {
            return BlockChange.BREAK;
        }
        if (newBlock != originalBlock && !TrackingUtil.forceModify(originalBlock, newBlock)) {
            return BlockChange.PLACE;
        }
        return BlockChange.MODIFY;
    }

    default public boolean shouldProvideModifiers(C phaseContext) {
        return true;
    }

    default public boolean isRestoring() {
        return false;
    }

    default public boolean shouldCreateWorldDirectories(C phaseContext) {
        return true;
    }

    default public boolean isConvertingMaps() {
        return false;
    }

    default public boolean allowsGettingQueuedRemovedTiles() {
        return false;
    }

    default public void markTeleported(C phaseContext) {
    }

    default public Supplier<SpawnType> getSpawnTypeForTransaction(C context, net.minecraft.entity.Entity entityToSpawn) {
        if (entityToSpawn instanceof ItemEntity) {
            return SpawnTypes.DROPPED_ITEM;
        }
        return SpawnTypes.PASSIVE;
    }

    default public SpawnEntityEvent createSpawnEvent(C context, GameTransaction<@NonNull ?> parent, ImmutableList<Tuple<net.minecraft.entity.Entity, SpawnEntityTransaction.DummySnapshot>> collect, Cause currentCause) {
        return SpongeEventFactory.createSpawnEntityEvent(currentCause, collect.stream().map(t -> (Entity)t.getFirst()).collect(Collectors.toList()));
    }

    default public boolean recordsEntitySpawns(C context) {
        return true;
    }

    default public void populateLootContext(C phaseContext, LootContext.Builder lootBuilder) {
    }

    default public Operation getBlockOperation(SpongeBlockSnapshot original, BlockChange blockChange) {
        return blockChange.toOperation();
    }

    default public void foldContextForThread(C context, TrackedTickDelayedTaskBridge returnValue) {
    }

    default public void associateScheduledTickUpdate(C asContext, NextTickListEntry<?> entry) {
    }
}

