/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.UnwindingPhaseContext;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;

public final class UnwindingState
implements IPhaseState<UnwindingPhaseContext> {
    private final String desc = TrackingUtil.phaseStateToString("General", this);

    public static UnwindingState getInstance() {
        return Holder.INSTANCE;
    }

    private UnwindingState() {
    }

    @Override
    public UnwindingPhaseContext createPhaseContext(PhaseTracker server) {
        throw new UnsupportedOperationException("Use UnwindingPhaseContext#unwind(IPhaseState, PhaseContext)! Cannot create a context based on Post state!");
    }

    @Override
    public boolean requiresPost() {
        return false;
    }

    @Override
    public boolean ignoresBlockUpdateTick(UnwindingPhaseContext context) {
        return true;
    }

    @Override
    public boolean ignoresScheduledUpdates() {
        return false;
    }

    @Override
    public boolean alreadyCapturingEntitySpawns() {
        return true;
    }

    @Override
    public boolean alreadyCapturingEntityTicks() {
        return true;
    }

    @Override
    public boolean alreadyCapturingTileTicks() {
        return true;
    }

    @Override
    public boolean allowsGettingQueuedRemovedTiles() {
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, UnwindingPhaseContext context) {
        @NonNull T unwinding = context.getUnwindingContext();
        unwinding.appendContextPreExplosion(explosionContext);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void associateNeighborStateNotifier(UnwindingPhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, ServerWorld minecraftWorld, PlayerTracker.Type notifier) {
        @NonNull T unwindingContext = context.getUnwindingContext();
        unwindingContext.associateNeighborStateNotifier(sourcePos, block, notifyPos, minecraftWorld, notifier);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void unwind(UnwindingPhaseContext context) {
        @NonNull T unwindingContext = context.getUnwindingContext();
    }

    @Override
    public boolean alreadyCapturingBlockTicks(UnwindingPhaseContext context) {
        return true;
    }

    public String toString() {
        return this.desc;
    }

    private static final class Holder {
        static final UnwindingState INSTANCE = new UnwindingState();

        private Holder() {
        }
    }
}

