/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.block.NotifyNeighborBlockEvent;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;

final class NeighborNotification
extends GameTransaction<NotifyNeighborBlockEvent> {
    final net.minecraft.block.BlockState original;
    final BlockPos notifyPos;
    final Block sourceBlock;
    final BlockPos sourcePos;
    final BlockPos affectedPosition;
    final net.minecraft.block.BlockState originalState;
    private final Supplier<net.minecraft.world.server.ServerWorld> serverWorld;
    private Supplier<LocatableBlock> locatableBlock;

    NeighborNotification(Supplier<net.minecraft.world.server.ServerWorld> serverWorldSupplier, net.minecraft.block.BlockState notifyState, BlockPos notifyPos, Block sourceBlock, BlockPos sourcePos) {
        super(TransactionTypes.NEIGHBOR_NOTIFICATION.get(), ((ServerWorld)serverWorldSupplier.get()).getKey());
        this.affectedPosition = sourcePos;
        this.originalState = notifyState;
        this.serverWorld = serverWorldSupplier;
        this.notifyPos = notifyPos;
        this.sourceBlock = sourceBlock;
        this.sourcePos = sourcePos;
        this.original = serverWorldSupplier.get().func_180495_p(sourcePos);
        this.locatableBlock = () -> {
            LocatableBlock locatableBlock = new SpongeLocatableBlockBuilder().world(this.serverWorld).position(this.sourcePos.func_177958_n(), this.sourcePos.func_177956_o(), this.sourcePos.func_177952_p()).state((BlockState)this.original).build();
            this.locatableBlock = () -> locatableBlock;
            return locatableBlock;
        };
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", NeighborNotification.class.getSimpleName() + "[", "]").add("notifyState=" + this.originalState).add("notifyPos=" + this.notifyPos).add("sourceBlock=" + this.sourceBlock).add("sourcePos=" + this.sourcePos).add("actualSourceState=" + this.originalState).toString();
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of((context, frame) -> frame.pushCause(this.locatableBlock.get()));
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("NeighborNotification").add(" %s : %s, %s", "Source Pos", this.sourceBlock, this.sourcePos).add(" %s : %s, %s", "Notification", this.originalState, this.notifyPos);
    }

    @Override
    public Optional<NotifyNeighborBlockEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<NotifyNeighborBlockEvent>> transactions, Cause currentCause, ImmutableMultimap.Builder<TransactionType, ? extends Event> transactionPostEventBuilder) {
        return Optional.empty();
    }

    @Override
    public void restore() {
    }

    @Override
    public boolean markCancelledTransactions(NotifyNeighborBlockEvent event, ImmutableList<? extends GameTransaction<NotifyNeighborBlockEvent>> blockTransactions) {
        return false;
    }
}

