/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class AddBlockLootDropsEffect
implements ProcessingSideEffect {
    public static AddBlockLootDropsEffect getInstance() {
        return Holder.INSTANCE;
    }

    AddBlockLootDropsEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        PhaseContext<@NonNull ?> phaseContext = PhaseTracker.getInstance().getPhaseContext();
        ServerWorld world = pipeline.getServerWorld();
        @Nullable TileEntity existingTile = oldState.tileEntity;
        BlockPos pos = oldState.pos;
        LootContext.Builder lootBuilder = new LootContext.Builder(world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)VecHelper.toVanillaVector3d(pos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)existingTile);
        phaseContext.populateLootContext(lootBuilder);
        return new EffectResult(newState, oldState.state.func_215693_a(lootBuilder), false);
    }

    private static final class Holder {
        static final AddBlockLootDropsEffect INSTANCE = new AddBlockLootDropsEffect();

        private Holder() {
        }
    }
}

