/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.pipeline;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class ChunkPipeline
implements BlockPipeline {
    private final @Nullable Supplier<Chunk> chunkSupplier;
    private final @Nullable Supplier<ServerWorld> serverWorld;
    private final @Nullable Supplier<ChunkSection> sectionSupplier;
    private final boolean wasEmpty;
    private final List<ResultingTransactionBySideEffect> chunkEffects;
    final ChangeBlock transaction;

    public static ChunkPipeline nullReturn(Chunk chunk, ServerWorld world) {
        return new ChunkPipeline(chunk, world);
    }

    private ChunkPipeline(Chunk chunk, ServerWorld world) {
        WeakReference<Chunk> chunkWeakReference = new WeakReference<Chunk>(chunk);
        this.chunkSupplier = () -> (Chunk)chunkWeakReference.get();
        WeakReference<ServerWorld> serverWorldWeakReference = new WeakReference<ServerWorld>(world);
        this.serverWorld = () -> (ServerWorld)serverWorldWeakReference.get();
        this.sectionSupplier = () -> Chunk.field_186036_a;
        this.wasEmpty = true;
        this.chunkEffects = Collections.emptyList();
        this.transaction = null;
    }

    ChunkPipeline(Builder builder) {
        this.chunkSupplier = builder.chunkSupplier;
        this.chunkEffects = builder.effects;
        this.serverWorld = builder.serverWorld;
        this.sectionSupplier = builder.sectionSupplier;
        this.wasEmpty = Objects.requireNonNull(builder.sectionSupplier).get().func_76663_a();
        this.transaction = builder.transaction;
    }

    public Supplier<Chunk> getChunkSupplier() {
        return this.chunkSupplier;
    }

    public List<ResultingTransactionBySideEffect> getChunkEffects() {
        return this.chunkEffects;
    }

    @Override
    public ServerWorld getServerWorld() {
        return Objects.requireNonNull(this.serverWorld, "ServerWorld Supplier is null in ChunkPipeline").get();
    }

    @Override
    public Chunk getAffectedChunk() {
        return Objects.requireNonNull(this.chunkSupplier, "Chunk Supplier is null in ChunkPipeline").get();
    }

    @Override
    public ChunkSection getAffectedSection() {
        return Objects.requireNonNull(this.sectionSupplier, "ChunkSection Supplier is null in ChunkPipeline").get();
    }

    public @Nullable BlockState processChange(PhaseContext<?> context, BlockState currentState, BlockState proposedState, BlockPos pos, int limit) {
        if (this.chunkEffects.isEmpty()) {
            return null;
        }
        ServerWorld serverWorld = this.serverWorld.get();
        int oldOpacity = currentState.func_200016_a((IBlockReader)serverWorld, pos);
        SpongeBlockChangeFlag flag = this.transaction.getBlockChangeFlag();
        @Nullable TileEntity existing = this.chunkSupplier.get().func_177424_a(pos, Chunk.CreateEntityType.CHECK);
        PipelineCursor formerState = new PipelineCursor(currentState, oldOpacity, pos, existing, null, limit);
        for (ResultingTransactionBySideEffect effect : this.chunkEffects) {
            EffectTransactor ignored = context.getTransactor().pushEffect(effect);
            Throwable throwable = null;
            try {
                EffectResult result = effect.effect.processSideEffect(this, formerState, proposedState, flag, limit);
                if (result.hasResult) {
                    BlockState blockState = result.resultingState;
                    return blockState;
                }
                if (!formerState.drops.isEmpty() || result.drops.isEmpty()) continue;
                formerState = new PipelineCursor(currentState, oldOpacity, pos, existing, null, result.drops, limit);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean wasEmpty() {
        return this.wasEmpty;
    }

    public static final class Builder {
        @Nullable Supplier<ServerWorld> serverWorld;
        @Nullable Supplier<Chunk> chunkSupplier;
        @Nullable Supplier<ChunkSection> sectionSupplier;
        boolean wasSectionEmpty;
        @MonotonicNonNull ChangeBlock transaction;
        List<ResultingTransactionBySideEffect> effects;

        public Builder kickOff(ChangeBlock transaction) {
            this.transaction = Objects.requireNonNull(transaction, "ChangeBlock transaction cannot be null!");
            return this;
        }

        public Builder addEffect(ProcessingSideEffect effect) {
            if (this.effects == null) {
                this.effects = new LinkedList<ResultingTransactionBySideEffect>();
            }
            this.effects.add(new ResultingTransactionBySideEffect(Objects.requireNonNull(effect, "Effect is null")));
            return this;
        }

        public Builder chunk(Chunk chunk) {
            WeakReference<Chunk> worldRef = new WeakReference<Chunk>(chunk);
            this.chunkSupplier = () -> {
                Chunk chunkRef = (Chunk)worldRef.get();
                if (chunkRef == null) {
                    throw new IllegalStateException("ServerWorld dereferenced");
                }
                return chunkRef;
            };
            return this;
        }

        public Builder chunkSection(ChunkSection section) {
            WeakReference<ChunkSection> worldRef = new WeakReference<ChunkSection>(section);
            this.sectionSupplier = () -> {
                ChunkSection chunkRef = (ChunkSection)worldRef.get();
                if (chunkRef == null) {
                    throw new IllegalStateException("ServerWorld dereferenced");
                }
                return chunkRef;
            };
            this.wasSectionEmpty = section.func_76663_a();
            return this;
        }

        public Builder world(ServerWorld world) {
            WeakReference<ServerWorld> worldRef = new WeakReference<ServerWorld>(world);
            this.serverWorld = () -> {
                ServerWorld serverWorld = (ServerWorld)worldRef.get();
                if (serverWorld == null) {
                    throw new IllegalStateException("ServerWorld dereferenced");
                }
                return serverWorld;
            };
            return this;
        }

        public ChunkPipeline build() {
            if (this.effects == null) {
                this.effects = Collections.emptyList();
            }
            Objects.requireNonNull(this.transaction, "ChangeBlock transaction must have been recorded!");
            return new ChunkPipeline(this);
        }
    }
}

