/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.pipeline;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class TileEntityPipeline
implements BlockPipeline {
    private final @Nullable Supplier<Chunk> chunkSupplier;
    private final @Nullable Supplier<ServerWorld> serverWorld;
    private final @Nullable Supplier<ChunkSection> sectionSupplier;
    private final List<ResultingTransactionBySideEffect> effects;

    private TileEntityPipeline(Builder builder) {
        this.chunkSupplier = builder.chunkSupplier;
        this.serverWorld = builder.serverWorld;
        this.sectionSupplier = builder.sectionSupplier;
        this.effects = builder.effects;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder kickOff(ServerWorld world, BlockPos pos) {
        WeakReference<ServerWorld> worldRef = new WeakReference<ServerWorld>(world);
        Chunk chunk = world.func_175726_f(pos);
        WeakReference<Chunk> chunkRef = new WeakReference<Chunk>(chunk);
        WeakReference<ChunkSection> sectionRef = new WeakReference<ChunkSection>(chunk.func_76587_i()[pos.func_177956_o() >> 4]);
        Supplier<ServerWorld> worldSupplier = () -> (ServerWorld)Objects.requireNonNull(worldRef.get(), "ServerWorld de-referenced");
        Supplier<Chunk> chunkSupplier = () -> (Chunk)Objects.requireNonNull(chunkRef.get(), "Chunk de-referenced");
        Supplier<ChunkSection> chunkSectionSupplier = () -> (ChunkSection)Objects.requireNonNull(sectionRef.get(), "ChunkSection de-referenced");
        return TileEntityPipeline.builder().chunk(chunkSupplier).world(worldSupplier).chunkSection(chunkSectionSupplier);
    }

    @Override
    public ServerWorld getServerWorld() {
        return Objects.requireNonNull(this.serverWorld, "ServerWorld Supplier is null in TileEntityPipeline").get();
    }

    @Override
    public Chunk getAffectedChunk() {
        return Objects.requireNonNull(this.chunkSupplier, "Chunk Supplier is null in TileEntityPipeline").get();
    }

    @Override
    public ChunkSection getAffectedSection() {
        return Objects.requireNonNull(this.sectionSupplier, "ChunkSection Supplier is null in TileEntityPipeline").get();
    }

    @Override
    public boolean wasEmpty() {
        return false;
    }

    public boolean processEffects(PhaseContext<?> context, PipelineCursor initialCursor) {
        PipelineCursor currentCursor = initialCursor;
        for (ResultingTransactionBySideEffect effect : this.effects) {
            EffectTransactor ignored = context.getTransactor().pushEffect(effect);
            Throwable throwable = null;
            try {
                EffectResult result = effect.effect.processSideEffect(this, currentCursor, currentCursor.state, (SpongeBlockChangeFlag)BlockChangeFlags.NONE, currentCursor.limit);
                if (result.resultingState != currentCursor.state) {
                    currentCursor = new PipelineCursor(result.resultingState, currentCursor.opacity, currentCursor.pos, currentCursor.tileEntity, currentCursor.destroyer, currentCursor.limit);
                }
                if (!result.hasResult) continue;
                boolean bl = result.resultingState != null;
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        return false;
    }

    public static final class Builder {
        @Nullable Supplier<ServerWorld> serverWorld;
        @Nullable Supplier<Chunk> chunkSupplier;
        @Nullable Supplier<ChunkSection> sectionSupplier;
        List<ResultingTransactionBySideEffect> effects;

        public Builder addEffect(ProcessingSideEffect effect) {
            if (this.effects == null) {
                this.effects = new LinkedList<ResultingTransactionBySideEffect>();
            }
            this.effects.add(new ResultingTransactionBySideEffect(Objects.requireNonNull(effect, "Effect is null")));
            return this;
        }

        public Builder chunk(Supplier<Chunk> chunk) {
            this.chunkSupplier = chunk;
            return this;
        }

        public Builder chunkSection(Supplier<ChunkSection> section) {
            this.sectionSupplier = section;
            return this;
        }

        public Builder world(Supplier<ServerWorld> world) {
            this.serverWorld = world;
            return this;
        }

        public TileEntityPipeline build() {
            if (this.effects == null) {
                this.effects = Collections.emptyList();
            }
            Objects.requireNonNull(this.serverWorld, "ServerWorld must have been recorded!");
            Objects.requireNonNull(this.chunkSupplier, "Chunk must have been recorded!");
            return new TileEntityPipeline(this);
        }
    }
}

