/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.Marker;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.transaction.BlockTransaction;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;

public final class BlockTransactionType
extends TransactionType<ChangeBlockEvent.All> {
    public BlockTransactionType() {
        super(true, "BLOCK");
    }

    @Override
    protected void consumeEventsAndMarker(Collection<? extends ChangeBlockEvent.All> changeBlockEvents, Marker marker) {
        LinkedListMultimap eventsByWorld = LinkedListMultimap.create();
        changeBlockEvents.forEach(arg_0 -> BlockTransactionType.lambda$consumeEventsAndMarker$0((Multimap)eventsByWorld, arg_0));
        eventsByWorld.asMap().forEach((key, events) -> {
            Optional<ServerWorld> serverWorld = ((SpongeServer)SpongeCommon.getServer()).getWorldManager().world((ResourceKey)key);
            if (!serverWorld.isPresent()) {
                return;
            }
            LinkedListMultimap positions = LinkedListMultimap.create();
            events.stream().flatMap(event -> event.getTransactions().stream()).filter(Transaction::isValid).forEach(arg_0 -> BlockTransactionType.lambda$null$2((ListMultimap)positions, arg_0));
            PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
            ImmutableList transactions = (ImmutableList)positions.asMap().values().stream().map(spongeBlockSnapshots -> {
                ArrayList snapshots = new ArrayList(spongeBlockSnapshots);
                if (snapshots.isEmpty() || snapshots.size() < 2) {
                    return Optional.empty();
                }
                SpongeBlockSnapshot original = (SpongeBlockSnapshot)snapshots.get(0);
                SpongeBlockSnapshot result = (SpongeBlockSnapshot)snapshots.get(snapshots.size() - 1);
                Operation operation = context.getBlockOperation(original, original.blockChange);
                BlockTransactionReceipt eventTransaction = new BlockTransactionReceipt(original, result, operation);
                return Optional.of(eventTransaction);
            }).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
            Cause cause = PhaseTracker.getInstance().getCurrentCause();
            SpongeCommon.postEvent(SpongeEventFactory.createChangeBlockEventPost(cause, (List<BlockTransactionReceipt>)transactions, serverWorld.get()));
        });
    }

    private static /* synthetic */ void lambda$null$2(ListMultimap positions, BlockTransaction transactions) {
        SpongeBlockSnapshot original = (SpongeBlockSnapshot)transactions.getOriginal();
        positions.put((Object)original.getBlockPos(), (Object)original);
        positions.put((Object)original.getBlockPos(), (Object)((SpongeBlockSnapshot)transactions.getFinal()));
    }

    private static /* synthetic */ void lambda$consumeEventsAndMarker$0(Multimap eventsByWorld, ChangeBlockEvent.All event) {
        eventsByWorld.put((Object)event.getWorld().getKey(), (Object)event);
    }
}

