/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import com.google.common.base.Preconditions;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;

public class GrowablePhaseContext
extends PhaseContext<GrowablePhaseContext> {
    protected PhaseContext<?> priorContext;
    ItemStackSnapshot usedItem;
    World world;
    BlockState blockState;
    BlockPos pos;
    SpongeBlockSnapshot snapshot;

    protected GrowablePhaseContext(IPhaseState<GrowablePhaseContext> state, PhaseTracker tracker) {
        super(state, tracker);
    }

    public GrowablePhaseContext provideItem(ItemStack stack) {
        this.usedItem = ItemStackUtil.snapshotOf(stack);
        this.priorContext = PhaseTracker.getInstance().getPhaseContext();
        return this;
    }

    public GrowablePhaseContext world(World worldIn) {
        this.world = worldIn;
        return this;
    }

    public GrowablePhaseContext block(BlockState blockState) {
        this.blockState = blockState;
        return this;
    }

    public GrowablePhaseContext pos(BlockPos pos) {
        this.pos = pos;
        return this;
    }

    @Override
    public GrowablePhaseContext buildAndSwitch() {
        Preconditions.checkState((this.pos != null ? 1 : 0) != 0, (Object)"BlockPos is null");
        Preconditions.checkState((this.blockState != null ? 1 : 0) != 0, (Object)"BlockState is null");
        Preconditions.checkState((this.usedItem != null ? 1 : 0) != 0, (Object)"ItemUsed is null");
        Preconditions.checkState((this.priorContext != null ? 1 : 0) != 0, (Object)"Prior context is null");
        Preconditions.checkState((this.world != null ? 1 : 0) != 0, (Object)"World is null");
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled().world((ServerWorld)this.world).position(VecHelper.toVector3i(this.pos)).blockState(this.blockState).flag(BlockChangeFlags.PHYSICS_OBSERVER);
        this.priorContext.applyOwnerIfAvailable(owner -> builder.creator(owner.getUniqueId()));
        this.priorContext.applyNotifierIfAvailable(notifier -> builder.notifier(notifier.getUniqueId()));
        this.snapshot = builder.build();
        return (GrowablePhaseContext)super.buildAndSwitch();
    }

    @Override
    protected void reset() {
        super.reset();
        this.priorContext = null;
        this.usedItem = null;
        this.world = null;
        this.blockState = null;
        this.pos = null;
        this.snapshot = null;
    }

    @Override
    protected GrowablePhaseContext defensiveCopy(PhaseTracker tracker) {
        GrowablePhaseContext newCopy = (GrowablePhaseContext)super.defensiveCopy(tracker);
        return newCopy;
    }
}

