/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.entity;

import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ExperienceOrb;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.cause.entity.SpongeSpawnTypes;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.PooledPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.entity.EntityContext;

public abstract class EntityPhaseState<E extends EntityContext<E>>
extends PooledPhaseState<E>
implements IPhaseState<E> {
    private final String desc = TrackingUtil.phaseStateToString("Entity", this);

    @Override
    public void unwind(E context) {
    }

    public String toString() {
        return this.desc;
    }

    void standardSpawnCapturedEntities(PhaseContext<?> context, List<? extends Entity> entities) {
        List other;
        List<Entity> experience = entities.stream().filter(entity -> entity instanceof ExperienceOrb).collect(Collectors.toList());
        if (!experience.isEmpty()) {
            PhaseTracker.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
            SpongeCommonEventFactory.callSpawnEntity(experience, context);
        }
        if (!(other = entities.stream().filter(entity -> !(entity instanceof ExperienceOrb)).collect(Collectors.toList())).isEmpty()) {
            PhaseTracker.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpongeSpawnTypes.ENTITY_DEATH);
            SpongeCommonEventFactory.callSpawnEntity(experience, context);
        }
    }

    @Override
    public boolean doesDenyChunkRequests(E context) {
        return true;
    }
}

