/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.world.Explosion;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.common.accessor.world.ExplosionAccessor;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhaseContext;
import org.spongepowered.common.util.PrettyPrinter;

public final class ExplosionContext
extends GeneralPhaseContext<ExplosionContext> {
    private Explosion explosion;

    public ExplosionContext(PhaseTracker tracker) {
        super(GeneralPhase.State.EXPLOSION, tracker);
    }

    ExplosionContext populateFromCurrentState() {
        PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
        context.appendContextPreExplosion(this);
        return this;
    }

    public ExplosionContext potentialExplosionSource(ServerWorld worldServer, @Nullable Entity entityIn) {
        if (entityIn != null) {
            this.source(entityIn);
        } else {
            this.source(worldServer);
        }
        return this;
    }

    public ExplosionContext explosion(Explosion explosion) {
        this.explosion = explosion;
        return this;
    }

    public Explosion getExplosion() {
        return this.explosion;
    }

    public org.spongepowered.api.world.explosion.Explosion getSpongeExplosion() {
        return (org.spongepowered.api.world.explosion.Explosion)this.explosion;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s2 = String.format("%1$" + indent + "s", "");
        return super.printCustom(printer, indent).add(s2 + "- %s: %s", "Explosion", this.explosion);
    }

    @Override
    protected void reset() {
        super.reset();
        this.explosion = null;
    }

    @Override
    protected boolean isRunaway(PhaseContext<?> phaseContext) {
        if (phaseContext.getClass() != ExplosionContext.class) {
            return false;
        }
        ExplosionAccessor otherExplosion = (ExplosionAccessor)((ExplosionContext)phaseContext).explosion;
        ExplosionAccessor thisExplosion = (ExplosionAccessor)this.explosion;
        return otherExplosion.accessor$level() == thisExplosion.accessor$level() && otherExplosion.accessor$x() == thisExplosion.accessor$x() && otherExplosion.accessor$y() == thisExplosion.accessor$y() && otherExplosion.accessor$z() == thisExplosion.accessor$z();
    }
}

