/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;

public final class DropItemOutsideWindowState
extends BasicInventoryPacketState {
    public DropItemOutsideWindowState(int stateid) {
        super(stateid);
    }

    @Override
    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, InventoryPacketContext context) {
        super.populateContext(playerMP, packet, context);
    }

    @Override
    public ClickContainerEvent createInventoryEvent(ServerPlayerEntity playerMP, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<Entity> capturedEntities, int usedButton, @Nullable Slot slot) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            Object object;
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            for (Entity currentEntity : capturedEntities) {
                if (currentEntity instanceof CreatorTrackedBridge) {
                    ((CreatorTrackedBridge)((Object)currentEntity)).tracked$setCreatorReference(((ServerPlayer)playerMP).getUser());
                    continue;
                }
                currentEntity.offer(Keys.CREATOR, playerMP.func_110124_au());
            }
            if (usedButton == 0) {
                object = SpongeEventFactory.createClickContainerEventDropOutsidePrimary(frame.getCurrentCause(), openContainer, transaction, capturedEntities, Optional.ofNullable(slot), slotTransactions);
                return object;
            }
            object = SpongeEventFactory.createClickContainerEventDropOutsideSecondary(frame.getCurrentCause(), openContainer, transaction, capturedEntities, Optional.ofNullable(slot), slotTransactions);
            return object;
        }
    }
}

