/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.client.CClickWindowPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.util.Hand;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.entity.PlayerInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.util.ContainerUtil;
import org.spongepowered.common.util.Constants;

public final class DropItemWithHotkeyState
extends BasicInventoryPacketState {
    public DropItemWithHotkeyState() {
        super(Constants.Networking.MODE_DROP | 1 | 2 | 0x10000);
    }

    @Override
    public void unwind(InventoryPacketContext context) {
        ServerPlayerEntity player = context.getPacketPlayer();
        Entity spongePlayer = (Entity)player;
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            Slot slot;
            int usedButton;
            CPlayerDiggingPacket packetIn;
            frame.pushCause(spongePlayer);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            TrackingUtil.processBlockCaptures(context);
            ArrayList items = new ArrayList();
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (ItemEntity item : items) {
                entities.add((Entity)item);
            }
            if (context.getPacket() instanceof CPlayerDiggingPacket) {
                packetIn = (CPlayerDiggingPacket)context.getPacket();
                usedButton = packetIn.func_180762_c() == CPlayerDiggingPacket.Action.DROP_ITEM ? 0 : 1;
                slot = ((PlayerInventory)player.field_71071_by).getEquipment().getSlot(EquipmentTypes.MAIN_HAND).orElse(null);
            } else {
                packetIn = (CClickWindowPacket)context.getPacket();
                usedButton = packetIn.func_149543_e();
                slot = ((InventoryAdapter)player.field_71071_by).inventoryAdapter$getSlot(packetIn.func_149544_d()).orElse(null);
            }
            Transaction<ItemStackSnapshot> cursorTrans = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.empty(), ItemStackSnapshot.empty());
            TrackedInventoryBridge mixinContainer = (TrackedInventoryBridge)player.field_71070_bA;
            List<SlotTransaction> slotTrans = mixinContainer.bridge$getCapturedSlotTransactions();
            ClickContainerEvent dropItemEvent = this.createInventoryEvent(player, ContainerUtil.fromNative(player.field_71070_bA), (Transaction)cursorTrans, (List)Lists.newArrayList(slotTrans), entities, usedButton, slot);
            SpongeCommon.postEvent(dropItemEvent);
            if (dropItemEvent.isCancelled() || PacketPhaseUtil.allTransactionsInvalid(dropItemEvent.getTransactions())) {
                ((ServerPlayerEntityBridge)player).bridge$restorePacketItem(Hand.MAIN_HAND);
                PacketPhaseUtil.handleSlotRestore((PlayerEntity)player, player.field_71070_bA, dropItemEvent.getTransactions(), true);
            } else {
                PacketState.processSpawnedEntities(player, (SpawnEntityEvent)((Object)dropItemEvent));
            }
            for (Entity entity : entities) {
                if (!((EntityBridge)((Object)entity)).bridge$isConstructing()) continue;
                ((EntityBridge)((Object)entity)).bridge$fireConstructors();
            }
            slotTrans.clear();
            mixinContainer.bridge$setCaptureInventory(false);
            TrackedInventoryBridge mixinContainer2 = (TrackedInventoryBridge)player.field_71070_bA;
            mixinContainer2.bridge$setCaptureInventory(false);
            mixinContainer2.bridge$getCapturedSlotTransactions().clear();
        }
    }

    @Override
    public ClickContainerEvent.Drop createInventoryEvent(ServerPlayerEntity serverPlayer, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<Entity> capturedEntities, int usedButton, @Nullable Slot slot) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            for (Entity currentEntity : capturedEntities) {
                if (currentEntity instanceof CreatorTrackedBridge) {
                    ((CreatorTrackedBridge)((Object)currentEntity)).tracked$setCreatorReference(((ServerPlayer)serverPlayer).getUser());
                    continue;
                }
                currentEntity.offer(Keys.CREATOR, serverPlayer.func_110124_au());
            }
            ClickContainerEvent.Drop event = usedButton == 0 ? SpongeEventFactory.createClickContainerEventDropSingle(frame.getCurrentCause(), openContainer, transaction, capturedEntities, Optional.ofNullable(slot), slotTransactions) : SpongeEventFactory.createClickContainerEventDropFull(frame.getCurrentCause(), openContainer, transaction, capturedEntities, Optional.ofNullable(slot), slotTransactions);
            ClickContainerEvent.Drop drop = event;
            return drop;
        }
    }
}

