/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CHeldItemChangePacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class SwitchHotbarScrollState
extends BasicInventoryPacketState {
    @Override
    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, InventoryPacketContext context) {
        super.populateContext(playerMP, packet, context);
        context.setOldHighlightedSlot(playerMP.field_71071_by.field_70461_c);
    }

    @Override
    public ClickContainerEvent createInventoryEvent(ServerPlayerEntity playerMP, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<Entity> capturedEntities, int usedButton, @Nullable Slot slot) {
        return SpongeEventFactory.createClickContainerEventNumberPress(PhaseTracker.getCauseStackManager().getCurrentCause(), openContainer, transaction, Optional.ofNullable(slot), slotTransactions, usedButton);
    }

    @Override
    public void unwind(InventoryPacketContext context) {
        ServerPlayerEntity player = context.getPacketPlayer();
        CHeldItemChangePacket itemChange = (CHeldItemChangePacket)context.getPacket();
        int previousSlot = context.getOldHighlightedSlotId();
        net.minecraft.inventory.container.Container inventoryContainer = player.field_71070_bA;
        PlayerInventory inventory = player.field_71071_by;
        int preHotbarSize = inventory.field_70462_a.size() - PlayerInventory.func_70451_h() + inventory.field_70460_b.size() + 4 + 1;
        net.minecraft.inventory.container.Slot sourceSlot = inventoryContainer.func_75139_a(previousSlot + preHotbarSize);
        net.minecraft.inventory.container.Slot targetSlot = inventoryContainer.func_75139_a(itemChange.func_149614_c() + preHotbarSize);
        ItemStackSnapshot sourceSnapshot = ItemStackUtil.snapshotOf(sourceSlot.func_75211_c());
        ItemStackSnapshot targetSnapshot = ItemStackUtil.snapshotOf(targetSlot.func_75211_c());
        Slot slotPrev = (Slot)inventoryContainer.func_75139_a(previousSlot + preHotbarSize);
        SlotTransaction sourceTransaction = new SlotTransaction(slotPrev, sourceSnapshot, sourceSnapshot);
        Slot slotNew = (Slot)inventoryContainer.func_75139_a(itemChange.func_149614_c() + preHotbarSize);
        SlotTransaction targetTransaction = new SlotTransaction(slotNew, targetSnapshot, targetSnapshot);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            ImmutableList transactions = new ImmutableList.Builder().add((Object)sourceTransaction).add((Object)targetTransaction).build();
            ChangeInventoryEvent.Held changeInventoryEventHeld = SpongeEventFactory.createChangeInventoryEventHeld(frame.getCurrentCause(), slotNew, (Inventory)inventoryContainer, slotPrev, (List<SlotTransaction>)transactions);
            net.minecraft.inventory.container.Container openContainer = player.field_71070_bA;
            SpongeCommon.postEvent(changeInventoryEventHeld);
            if (changeInventoryEventHeld.isCancelled() || PacketPhaseUtil.allTransactionsInvalid(changeInventoryEventHeld.getTransactions())) {
                player.field_71135_a.func_147359_a((IPacket)new SHeldItemChangePacket(previousSlot));
                inventory.field_70461_c = previousSlot;
            } else {
                PacketPhaseUtil.handleSlotRestore((PlayerEntity)player, openContainer, changeInventoryEventHeld.getTransactions(), false);
                inventory.field_70461_c = itemChange.func_149614_c();
                player.func_143004_u();
            }
            ((TrackedInventoryBridge)openContainer).bridge$setCaptureInventory(false);
        }
    }
}

