/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.world.World;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class AttackEntityPacketState
extends BasicPacketState {
    private BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> ATTACK_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        frame.addContext(EventContextKeys.USED_ITEM, ctx.getItemUsedSnapshot());
        frame.addContext(EventContextKeys.USED_HAND, ctx.getHandUsed());
    });

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> getFrameModifier() {
        return this.ATTACK_MODIFIER;
    }

    @Override
    public boolean isPacketIgnored(IPacket<?> packetIn, ServerPlayerEntity packetPlayer) {
        CUseEntityPacket useEntityPacket = (CUseEntityPacket)packetIn;
        Entity entity = useEntityPacket.func_149564_a(packetPlayer.field_70170_p);
        return entity == null;
    }

    @Override
    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, BasicPacketContext context) {
        ((BasicPacketContext)context.itemUsed(ItemStackUtil.cloneDefensive(playerMP.func_184614_ca()))).handUsed(HandTypes.MAIN_HAND.get());
    }

    @Override
    public void unwind(BasicPacketContext context) {
        ServerPlayerEntity player = context.getPacketPlayer();
        CUseEntityPacket useEntityPacket = (CUseEntityPacket)context.getPacket();
        Entity entity = useEntityPacket.func_149564_a(player.field_70170_p);
        if (entity == null) {
            return;
        }
        World spongeWorld = (World)player.field_70170_p;
        if (entity instanceof CreatorTrackedBridge) {
            ((CreatorTrackedBridge)entity).tracked$setCreatorReference(((ServerPlayerEntityBridge)player).bridge$getUser());
        } else {
            ((org.spongepowered.api.entity.Entity)entity).offer(Keys.NOTIFIER, player.func_110124_au());
        }
        TrackingUtil.processBlockCaptures(context);
    }
}

