/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.block.transaction.Operations;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.block.TrackerBlockEventDataBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.FluidTickContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.world.BlockChange;

class FluidTickPhaseState
extends LocationBasedTickPhaseState<FluidTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, FluidTickContext> LOCATION_MODIFIER = super.getFrameModifier().andThen((frame, context) -> frame.pushCause(this.getLocatableBlockSourceFromContext((PhaseContext<?>)context)));
    private final String desc;

    FluidTickPhaseState(String name) {
        this.desc = TrackingUtil.phaseStateToString("Tick", name, this);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, FluidTickContext> getFrameModifier() {
        return this.LOCATION_MODIFIER;
    }

    @Override
    public FluidTickContext createNewContext(PhaseTracker tracker) {
        return (FluidTickContext)new FluidTickContext(this, tracker).addCaptures();
    }

    @Override
    public boolean shouldProvideModifiers(FluidTickContext phaseContext) {
        return phaseContext.providesModifier;
    }

    @Override
    public boolean doesCaptureNeighborNotifications(FluidTickContext context) {
        return context.allowsBulkBlockCaptures();
    }

    @Override
    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext<?> context) {
        return context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context));
    }

    @Override
    public void unwind(FluidTickContext context) {
        TrackingUtil.processBlockCaptures(context);
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, FluidTickContext context) {
        context.applyOwnerIfAvailable(explosionContext::creator);
        context.applyNotifierIfAvailable(explosionContext::notifier);
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        explosionContext.source(locatableBlock);
    }

    @Override
    public void appendNotifierToBlockEvent(FluidTickContext context, TrackedWorldBridge mixinWorldServer, BlockPos pos, TrackerBlockEventDataBridge blockEvent) {
        LocatableBlock source = this.getLocatableBlockSourceFromContext(context);
        blockEvent.bridge$setTickingLocatable(source);
    }

    @Override
    public boolean doesBlockEventTracking(FluidTickContext context) {
        return context.allowsBlockEvents();
    }

    @Override
    public BlockChange associateBlockChangeWithSnapshot(FluidTickContext phaseContext, BlockState newState, Block newBlock, BlockState currentState, SpongeBlockSnapshot snapshot, Block originalBlock) {
        if (phaseContext.tickingBlock.func_206886_c() instanceof FlowingFluid) {
            if (newBlock == Blocks.field_150350_a) {
                return BlockChange.BREAK;
            }
            if (currentState.func_177230_c() instanceof FlowingFluidBlock) {
                if (newState.func_177230_c() instanceof FlowingFluidBlock) {
                    return BlockChange.MODIFY;
                }
                if (newState.func_196958_f()) {
                    return BlockChange.DECAY;
                }
                return BlockChange.PLACE;
            }
            if (currentState.func_196958_f() && newState.func_177230_c() instanceof FlowingFluidBlock) {
                return BlockChange.PLACE;
            }
        }
        return super.associateBlockChangeWithSnapshot(phaseContext, newState, newBlock, currentState, snapshot, originalBlock);
    }

    @Override
    public Operation getBlockOperation(SpongeBlockSnapshot original, BlockChange blockChange) {
        FluidState fluidState = original.getState().getFluidState();
        if (!fluidState.isEmpty() && blockChange == BlockChange.DECAY) {
            return Operations.LIQUID_DECAY.get();
        }
        if (fluidState.isEmpty() && blockChange == BlockChange.PLACE) {
            return Operations.LIQUID_SPREAD.get();
        }
        if (!fluidState.isEmpty() && blockChange == BlockChange.MODIFY) {
            return Operations.LIQUID_SPREAD.get();
        }
        return super.getBlockOperation(original, blockChange);
    }

    @Override
    public String toString() {
        return this.desc;
    }
}

