/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.fluid;

import java.util.Objects;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.fluid.FluidStack;
import org.spongepowered.api.fluid.FluidStackSnapshot;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.fluid.FluidTypes;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.data.holder.SpongeImmutableDataHolder;
import org.spongepowered.common.fluid.SpongeFluidStackBuilder;
import org.spongepowered.common.fluid.SpongeFluidStackSnapshotBuilder;
import org.spongepowered.common.util.Constants;

public class SpongeFluidStackSnapshot
implements FluidStackSnapshot,
SpongeImmutableDataHolder<FluidStackSnapshot> {
    public static final FluidStackSnapshot DEFAULT = (FluidStackSnapshot)new SpongeFluidStackSnapshotBuilder().fluid(FluidTypes.WATER).volume(1000).build();
    private final FluidType fluidType;
    private final int volume;
    @Nullable
    private final DataContainer extraData;

    SpongeFluidStackSnapshot(SpongeFluidStackSnapshotBuilder builder) {
        this.fluidType = builder.fluidType;
        this.volume = builder.volume;
        this.extraData = builder.container == null ? null : builder.container.copy();
    }

    private SpongeFluidStackSnapshot(FluidType fluidType, int volume, @Nullable DataContainer extraData) {
        this.fluidType = fluidType;
        this.volume = volume;
        this.extraData = extraData == null ? null : extraData.copy();
    }

    @Override
    public @NonNull FluidType getFluid() {
        return this.fluidType;
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    @Override
    public @NonNull FluidStack createStack() {
        return new SpongeFluidStackBuilder().from(this).build();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public @NonNull DataContainer toContainer() {
        ResourceKey resourceKey = Sponge.getGame().registries().registry(RegistryTypes.FLUID_TYPE).valueKey(this.fluidType);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Constants.Fluids.FLUID_TYPE, resourceKey).set(Constants.Fluids.FLUID_VOLUME, this.volume);
        if (this.extraData != null) {
            container.set(Constants.Sponge.UNSAFE_NBT, this.extraData);
        }
        return container;
    }

    public int hashCode() {
        return Objects.hash(this.fluidType, this.volume, this.extraData);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpongeFluidStackSnapshot other = (SpongeFluidStackSnapshot)obj;
        return Objects.equals(this.fluidType, other.fluidType) && Objects.equals(this.volume, other.volume) && Objects.equals(this.extraData, other.extraData);
    }

    @Override
    public @NonNull FluidStackSnapshot copy() {
        return new SpongeFluidStackSnapshot(this.fluidType, this.volume, this.extraData);
    }

    @Override
    public boolean validateRawData(DataView container) {
        return container.contains(Queries.CONTENT_VERSION, Constants.Fluids.FLUID_TYPE, Constants.Fluids.FLUID_VOLUME);
    }

    @Override
    public @NonNull FluidStackSnapshot withRawData(@NonNull DataView container) throws InvalidDataException {
        FluidStack stack = this.createStack();
        stack.setRawData(container);
        return stack.createSnapshot();
    }
}

