/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.adapter.impl.comp;

import java.util.Optional;
import org.spongepowered.api.data.KeyValueMatcher;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.item.inventory.Equipable;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.equipment.EquipmentInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.common.inventory.adapter.impl.BasicInventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.impl.comp.ArmorInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.EquipmentInventoryLens;

public class EquipmentInventoryAdapter
extends BasicInventoryAdapter
implements EquipmentInventory {
    private final Equipable carrier;

    public EquipmentInventoryAdapter(Equipable carrier, Fabric fabric, EquipmentInventoryLens root, Inventory parent) {
        super(fabric, root, parent);
        this.carrier = carrier;
    }

    public EquipmentInventoryAdapter(Equipable carrier, Fabric fabric, ArmorInventoryLens root, Inventory parent) {
        super(fabric, root, parent);
        this.carrier = carrier;
    }

    @Override
    public Optional<Equipable> getCarrier() {
        return Optional.ofNullable(this.carrier);
    }

    @Override
    public InventoryTransactionResult.Poll poll(EquipmentType equipmentType) {
        return this.queryForType(equipmentType).poll();
    }

    @Override
    public InventoryTransactionResult.Poll poll(EquipmentType equipmentType, int limit) {
        return this.queryForType(equipmentType).poll(limit);
    }

    @Override
    public Optional<ItemStack> peek(EquipmentType equipmentType) {
        Inventory query = this.queryForType(equipmentType);
        if (query.capacity() == 0) {
            return Optional.empty();
        }
        return Optional.of(query.peek());
    }

    @Override
    public InventoryTransactionResult set(EquipmentType equipmentType, ItemStack stack) {
        Inventory query = this.queryForType(equipmentType);
        if (query.capacity() == 0) {
            return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.NO_SLOT).build();
        }
        return query.set(0, stack);
    }

    @Override
    public Optional<Slot> getSlot(EquipmentType equipmentType) {
        Inventory slot = this.queryForType(equipmentType);
        if (slot instanceof Slot) {
            return Optional.of((Slot)slot);
        }
        return Optional.empty();
    }

    private Inventory queryForType(EquipmentType equipmentType) {
        return this.query(KeyValueMatcher.of(Keys.EQUIPMENT_TYPE, equipmentType));
    }
}

