/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.adapter.impl.slots;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.inventory.container.Container;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.inventory.adapter.impl.BasicInventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.util.ItemStackUtil;

public class SlotAdapter
extends BasicInventoryAdapter
implements Slot {
    private final int ordinal;
    private final ImmutableList<Slot> slots;
    private final SlotLens slot;

    public SlotAdapter(Fabric fabric, SlotLens lens, Inventory parent) {
        super(fabric, lens, parent);
        this.slot = lens;
        this.ordinal = lens.getOrdinal(fabric);
        this.slots = ImmutableList.of((Object)this);
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public List<Slot> slots() {
        return this.slots;
    }

    @Override
    public InventoryTransactionResult.Poll poll() {
        net.minecraft.item.ItemStack stack = this.inventoryAdapter$getFabric().fabric$getStack(this.ordinal);
        if (stack.func_190926_b()) {
            return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS).poll(ItemStackSnapshot.empty()).build();
        }
        this.inventoryAdapter$getFabric().fabric$setStack(this.ordinal, net.minecraft.item.ItemStack.field_190927_a);
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS).transaction(new SlotTransaction(this, ItemStackUtil.snapshotOf(stack), ItemStackSnapshot.empty())).poll(ItemStackUtil.snapshotOf(stack)).build();
    }

    @Override
    public ItemStack peek() {
        net.minecraft.item.ItemStack stack = this.slot.getStack(this.inventoryAdapter$getFabric());
        return ItemStackUtil.cloneDefensive(stack);
    }

    @Override
    public InventoryTransactionResult offer(ItemStack ... stacks) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        for (ItemStack stack : stacks) {
            ItemStackSnapshot oldStack;
            net.minecraft.item.ItemStack nativeStack = ItemStackUtil.toNative(stack);
            int maxStackSize = this.slot.getMaxStackSize(this.inventoryAdapter$getFabric());
            int remaining = stack.getQuantity();
            net.minecraft.item.ItemStack old = this.slot.getStack(this.inventoryAdapter$getFabric());
            ItemStackSnapshot newStack = oldStack = ItemStackUtil.snapshotOf(old);
            int push = Math.min(remaining, maxStackSize);
            if (old.func_190926_b() && this.slot.setStack(this.inventoryAdapter$getFabric(), ItemStackUtil.cloneDefensiveNative(nativeStack, push))) {
                remaining -= push;
                newStack = ItemStackUtil.snapshotOf(stack);
            } else if (!old.func_190926_b() && ItemStackUtil.compareIgnoreQuantity(old, stack)) {
                this.inventoryAdapter$getFabric().fabric$markDirty();
                push = Math.max(Math.min(maxStackSize - old.func_190916_E(), remaining), 0);
                old.func_190920_e(old.func_190916_E() + push);
                remaining -= push;
                newStack = ItemStackUtil.snapshotOf(old);
            }
            result.transaction(new SlotTransaction(this, oldStack, newStack));
            if (remaining != stack.getQuantity()) continue;
            result.reject(ItemStackUtil.cloneDefensive(nativeStack));
            result.type(InventoryTransactionResult.Type.FAILURE);
        }
        return result.build();
    }

    @Override
    public boolean canFit(ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        int maxStackSize = this.inventoryAdapter$getFabric().fabric$getMaxStackSize();
        net.minecraft.item.ItemStack old = this.slot.getStack(this.inventoryAdapter$getFabric());
        if (old.func_190926_b()) {
            return maxStackSize >= stack.getQuantity();
        }
        return ItemStackUtil.compareIgnoreQuantity(old, stack) && maxStackSize - old.func_190916_E() >= stack.getQuantity();
    }

    @Override
    public InventoryTransactionResult set(ItemStack stack) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        net.minecraft.item.ItemStack nativeStack = ItemStackUtil.toNative(stack);
        net.minecraft.item.ItemStack old = this.slot.getStack(this.inventoryAdapter$getFabric());
        ItemStackSnapshot oldSnap = ItemStackUtil.snapshotOf(old);
        if (stack.isEmpty()) {
            this.clear();
            SlotTransaction trans = new SlotTransaction(this, oldSnap, ItemStackSnapshot.empty());
            return result.transaction(trans).build();
        }
        int remaining = stack.getQuantity();
        int push = Math.min(remaining, this.slot.getMaxStackSize(this.inventoryAdapter$getFabric()));
        net.minecraft.item.ItemStack newStack = ItemStackUtil.cloneDefensiveNative(nativeStack, push);
        if (this.slot.setStack(this.inventoryAdapter$getFabric(), newStack)) {
            result.transaction(new SlotTransaction(this, oldSnap, ItemStackUtil.snapshotOf(newStack)));
            remaining -= push;
        }
        if (remaining > 0) {
            result.reject(ItemStackUtil.cloneDefensive(nativeStack, remaining));
        }
        return result.build();
    }

    @Override
    public void clear() {
        this.slot.setStack(this.inventoryAdapter$getFabric(), net.minecraft.item.ItemStack.field_190927_a);
    }

    @Override
    public int freeCapacity() {
        return !this.slot.getStack(this.inventoryAdapter$getFabric()).func_190926_b() ? 1 : 0;
    }

    @Override
    public int totalQuantity() {
        return this.slot.getStack(this.inventoryAdapter$getFabric()).func_190916_E();
    }

    @Override
    public int capacity() {
        return 1;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean contains(ItemStack stack) {
        net.minecraft.item.ItemStack slotStack = this.slot.getStack(this.inventoryAdapter$getFabric());
        return slotStack.func_190926_b() ? ItemStackUtil.toNative(stack).func_190926_b() : ItemStackUtil.compareIgnoreQuantity(slotStack, stack) && slotStack.func_190916_E() >= stack.getQuantity();
    }

    @Override
    public boolean containsAny(ItemStack stack) {
        net.minecraft.item.ItemStack slotStack = this.slot.getStack(this.inventoryAdapter$getFabric());
        return slotStack.func_190926_b() ? ItemStackUtil.toNative(stack).func_190926_b() : ItemStackUtil.compareIgnoreQuantity(slotStack, stack);
    }

    @Override
    public boolean contains(ItemType type) {
        net.minecraft.item.ItemStack slotStack = this.slot.getStack(this.inventoryAdapter$getFabric());
        return slotStack.func_190926_b() ? type == null || type == ItemTypes.AIR : slotStack.func_77973_b().equals(type);
    }

    @Override
    public Slot viewedSlot() {
        Fabric fabric = this.inventoryAdapter$getFabric();
        if (fabric instanceof net.minecraft.inventory.container.Slot) {
            return (Slot)((Object)fabric);
        }
        if (fabric instanceof Container) {
            return (Slot)((Container)fabric).func_75139_a(this.ordinal);
        }
        return this;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", SlotAdapter.class.getSimpleName() + "[", "]").add("ordinal=" + this.ordinal).toString();
    }
}

