/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.BlastFurnaceTileEntity;
import net.minecraft.tileentity.BrewingStandTileEntity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.DropperTileEntity;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.tileentity.SmokerTileEntity;
import net.minecraft.tileentity.TrappedChestTileEntity;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.DefaultEmptyLens;
import org.spongepowered.common.inventory.lens.impl.DefaultIndexedLens;
import org.spongepowered.common.inventory.lens.impl.comp.CraftingGridInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.CraftingInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.PrimaryPlayerInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.BrewingStandInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.FurnaceInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.LargeChestInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.SingleGridLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.SingleIndexedLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.container.ContainerLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.container.ContainerPlayerInventoryLens;
import org.spongepowered.common.inventory.lens.impl.slot.BasicSlotLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.inventory.util.ContainerUtil;

public class LensRegistrar {
    private static Map<Class<?>, Int2ObjectMap<Lens>> lenses = new HashMap();
    private static Map<Class<?>, LensFactory> lensFactories = new HashMap();

    private static Lens lensSlot(Object inventory, int size, SlotLensProvider slotLensProvider) {
        return slotLensProvider.getSlotLens(0);
    }

    public static void register(LensFactory lensFactory, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            lensFactories.put(clazz, lensFactory);
        }
    }

    public static LensFactory restricted(LensFactory original, Predicate<Integer> sizeRestriction) {
        return (inventory, size, slotLensProvider) -> {
            if (sizeRestriction.test(size)) {
                return original.apply(inventory, size, slotLensProvider);
            }
            return null;
        };
    }

    public static Lens getLens(Object inventory, SlotLensProvider slotLensProvider, int size) {
        return (Lens)LensRegistrar.getLenses(inventory.getClass()).computeIfAbsent(size, k -> LensRegistrar.generateLens(inventory, size, slotLensProvider));
    }

    private static Int2ObjectMap<Lens> getLenses(Class<?> inventory) {
        return lenses.computeIfAbsent(inventory, k -> new Int2ObjectOpenHashMap());
    }

    private static Lens generateLens(Object inventory, int size, SlotLensProvider slotLensProvider) {
        if (size == 0) {
            return new DefaultEmptyLens();
        }
        LensFactory lensFactory = lensFactories.get(inventory.getClass());
        Lens lens = null;
        if (lensFactory != null && (lens = lensFactory.apply(inventory.getClass(), size, slotLensProvider)) != null) {
            return lens;
        }
        if (inventory instanceof CraftingInventory) {
            lens = LensRegistrar.lensCraftingInventory(size, ((CraftingInventory)inventory).func_174922_i(), ((CraftingInventory)inventory).func_174923_h(), slotLensProvider);
        } else if (inventory instanceof Container) {
            lens = ContainerUtil.generateLens((Container)inventory, slotLensProvider);
        } else if (size == 1) {
            return slotLensProvider.getSlotLens(0);
        }
        if (lens != null) {
            return lens;
        }
        return new SingleIndexedLens(0, size, inventory.getClass(), slotLensProvider);
    }

    private static @Nullable Lens lensCraftingInventory(int size, int width, int height, SlotLensProvider slotLensProvider) {
        if (size != width * height) {
            return null;
        }
        return new CraftingGridInventoryLens(0, width, height, slotLensProvider);
    }

    private static @Nullable Lens lensGrid(Object inventory, int size, int width, int height, SlotLensProvider slotLensProvider) {
        if (size != width * height) {
            return null;
        }
        return new SingleGridLens(0, width, height, inventory.getClass(), slotLensProvider);
    }

    private static Lens lensBrewingStandTileEntity(Object inventory, int size, SlotLensProvider slotLensProvider) {
        return new BrewingStandInventoryLens(size, inventory.getClass(), slotLensProvider);
    }

    private static Lens lensFurnace(Object inventory, int size, SlotLensProvider slotLensProvider) {
        return new FurnaceInventoryLens(size, inventory.getClass(), slotLensProvider);
    }

    private static Lens lensDoubleSided(Object inventory, int size, SlotLensProvider slotLensProvider) {
        return new LargeChestInventoryLens(size, inventory.getClass(), slotLensProvider);
    }

    private static Lens lensRepairContainer(Object inventory, int size, SlotLensProvider slotLensProvider) {
        ArrayList<Lens> lenses = new ArrayList<Lens>();
        lenses.add(new DefaultIndexedLens(0, 3, slotLensProvider));
        lenses.add(new PrimaryPlayerInventoryLens(3, slotLensProvider, true));
        return new ContainerLens(size, inventory.getClass(), slotLensProvider, lenses);
    }

    private static Lens lensWorkbenchContainer(Object inventory, int size, SlotLensProvider slotLensProvider) {
        ArrayList<Lens> lenses = new ArrayList<Lens>();
        lenses.add(new CraftingInventoryLens(0, 1, 3, 3, slotLensProvider));
        lenses.add(new PrimaryPlayerInventoryLens(10, slotLensProvider, true));
        return new ContainerLens(size, inventory.getClass(), slotLensProvider, lenses);
    }

    private static Lens lensPlayerContainer(Object inventory, int size, SlotLensProvider slotLensProvider) {
        return new ContainerPlayerInventoryLens(size, inventory.getClass(), slotLensProvider);
    }

    static {
        LensRegistrar.register((inv, size, slp) -> LensRegistrar.lensGrid(inv, size, 9, 3, slp), ChestTileEntity.class, ShulkerBoxTileEntity.class, TrappedChestTileEntity.class, BarrelTileEntity.class, EnderChestInventory.class, ChestMinecartEntity.class);
        LensRegistrar.register((inv, size, slp) -> LensRegistrar.lensGrid(inv, size, 3, 3, slp), DispenserTileEntity.class, DropperTileEntity.class);
        LensRegistrar.register((inv, size, slp) -> LensRegistrar.lensCraftingInventory(size, 2, 2, slp), CraftingInventory.class);
        LensRegistrar.register((inv, size, slp) -> LensRegistrar.lensCraftingInventory(size, 3, 3, slp), CraftingInventory.class);
        LensRegistrar.register((inv, size, slp) -> LensRegistrar.lensGrid(inv, size, 5, 1, slp), HopperTileEntity.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::lensFurnace, s2 -> s2 == 3), AbstractFurnaceTileEntity.class, SmokerTileEntity.class, FurnaceTileEntity.class, BlastFurnaceTileEntity.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::lensBrewingStandTileEntity, s2 -> s2 == 5), BrewingStandTileEntity.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::lensDoubleSided, s2 -> s2 == 54), DoubleSidedInventory.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::lensRepairContainer, s2 -> s2 == 30), RepairContainer.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::lensWorkbenchContainer, s2 -> s2 == 37), WorkbenchContainer.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::lensPlayerContainer, s2 -> s2 == 46), PlayerContainer.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::generateLens, s2 -> s2 == 8), AbstractVillagerEntity.class, VillagerEntity.class, WanderingTraderEntity.class);
        LensRegistrar.register(LensRegistrar.restricted(LensRegistrar::lensSlot, s2 -> s2 == 1), CraftResultInventory.class);
    }

    public static class BasicSlotLensProvider
    implements SlotLensProvider {
        private static Map<Integer, BasicSlotLens> basicSlotLenses = new ConcurrentHashMap<Integer, BasicSlotLens>();
        public final int base;
        public final int size;

        public BasicSlotLensProvider(int size) {
            this(0, size);
        }

        public BasicSlotLensProvider(int base, int size) {
            this.base = base;
            this.size = size;
        }

        @Override
        public SlotLens getSlotLens(int index) {
            return basicSlotLenses.computeIfAbsent(index, BasicSlotLens::new);
        }

        public String toString() {
            return "SlotLensProvider[base=" + this.base + "][size=" + this.size + "]";
        }
    }

    private static interface LensFactory {
        public @Nullable Lens apply(Object var1, int var2, SlotLensProvider var3);
    }
}

