/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.query.type;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.inventory.container.Container;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.KeyValueMatcher;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.DelegatingLens;
import org.spongepowered.common.inventory.query.SpongeQuery;

public final class KeyValueMatcherQuery<T>
extends SpongeQuery {
    private final KeyValueMatcher<T> matcher;

    public KeyValueMatcherQuery(KeyValueMatcher<T> matcher) {
        this.matcher = matcher;
    }

    @Override
    public Inventory execute(Inventory inventory, InventoryAdapter adapter) {
        Fabric fabric = adapter.inventoryAdapter$getFabric();
        Lens lens = adapter.inventoryAdapter$getRootLens();
        if (this.matches(lens, null, inventory)) {
            return lens.getAdapter(fabric, inventory);
        }
        return this.toResult(inventory, fabric, this.reduce(fabric, lens, this.search(inventory, lens)));
    }

    private Map<Lens, Integer> search(Inventory inventory, Lens lens) {
        if (inventory instanceof Container) {
            LinkedHashMap<Lens, Integer> matches = new LinkedHashMap<Lens, Integer>();
            for (net.minecraft.inventory.container.Slot slot : ((Container)inventory).field_75151_b) {
                if (!this.matches(null, null, (Inventory)slot)) continue;
                matches.put(((InventoryAdapter)slot).inventoryAdapter$getRootLens(), 0);
            }
            if (!matches.isEmpty()) {
                return matches;
            }
            HashSet<Inventory> viewedInventories = new HashSet<Inventory>();
            for (Slot slot : inventory.slots()) {
                viewedInventories.add(slot.viewedSlot().parent());
            }
            for (Inventory viewedInventory : viewedInventories) {
                if (!this.matches(null, null, viewedInventory)) continue;
                matches.put(((InventoryAdapter)((Object)viewedInventory)).inventoryAdapter$getRootLens(), 0);
            }
            if (!matches.isEmpty()) {
                this.delegateOffset(lens, matches);
                return matches;
            }
        }
        return this.depthLaterSearch(inventory, lens);
    }

    private Map<Lens, Integer> depthLaterSearch(Inventory inventory, Lens lens) {
        LinkedHashMap<Lens, Integer> matches = new LinkedHashMap<Lens, Integer>();
        for (Lens child : lens.getChildren()) {
            if (child == null || !this.matches(child, lens, inventory)) continue;
            matches.put(child, 0);
        }
        if (matches.isEmpty()) {
            for (Lens child : lens.getChildren()) {
                if (child == null || child.getChildren().isEmpty()) continue;
                matches.putAll(this.depthLaterSearch(inventory, child));
            }
        }
        this.delegateOffset(lens, matches);
        return matches;
    }

    private void delegateOffset(Lens lens, Map<Lens, Integer> matches) {
        if (lens.base() != 0 && !matches.isEmpty() && lens instanceof DelegatingLens) {
            matches.entrySet().forEach(entry -> entry.setValue((Integer)entry.getValue() + lens.base()));
        }
    }

    public boolean matches(Lens lens, Lens parent, Inventory inventory) {
        Key<Value<T>> key = this.matcher.getKey();
        if (this.matcher.matches(inventory.get(key).orElse(null))) {
            return true;
        }
        if (parent == null) {
            return false;
        }
        Object value = parent.getDataFor(lens).get(key);
        return this.matcher.matches(value);
    }
}

