/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.BeaconContainer;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.item.inventory.BlockCarrier;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.inventory.container.AbstractFurnaceContainerAccessor;
import org.spongepowered.common.accessor.inventory.container.AbstractRepairContainerAccessor;
import org.spongepowered.common.accessor.inventory.container.BeaconContainerAccessor;
import org.spongepowered.common.accessor.inventory.container.BrewingStandContainerAccessor;
import org.spongepowered.common.accessor.inventory.container.ContainerAccessor;
import org.spongepowered.common.accessor.inventory.container.CraftingResultSlotAccessor;
import org.spongepowered.common.accessor.inventory.container.DispenserContainerAccessor;
import org.spongepowered.common.accessor.inventory.container.HopperContainerAccessor;
import org.spongepowered.common.accessor.inventory.container.HorseInventoryContainerAccessor;
import org.spongepowered.common.accessor.inventory.container.MerchantContainerAccessor;
import org.spongepowered.common.bridge.inventory.InventoryBridge;
import org.spongepowered.common.bridge.inventory.container.ContainerBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.inventory.SpongeBlockEntityCarrier;
import org.spongepowered.common.inventory.SpongeLocationCarrier;
import org.spongepowered.common.inventory.custom.CustomContainer;
import org.spongepowered.common.inventory.lens.CompoundSlotLensProvider;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.CompoundLens;
import org.spongepowered.common.inventory.lens.impl.DelegatingLens;
import org.spongepowered.common.inventory.lens.impl.comp.CraftingInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.GridInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.PrimaryPlayerInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.SingleGridLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.container.ContainerLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;

public final class ContainerUtil {
    private static final Random RANDOM = new Random();

    private ContainerUtil() {
    }

    public static Container fromNative(net.minecraft.inventory.container.Container container) {
        return (Container)container;
    }

    public static net.minecraft.inventory.container.Container toNative(Container container) {
        return (net.minecraft.inventory.container.Container)container;
    }

    public static void performBlockInventoryDrops(ServerWorld worldServer, double x, double y, double z, IInventory inventory) {
        PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
        if (context.doesBlockEventTracking()) {
            for (int j = 0; j < inventory.func_70302_i_(); ++j) {
                ItemStack itemStack = inventory.func_70301_a(j);
                if (itemStack.func_190926_b()) continue;
                float f = RANDOM.nextFloat() * 0.8f + 0.1f;
                float f1 = RANDOM.nextFloat() * 0.8f + 0.1f;
                float f2 = RANDOM.nextFloat() * 0.8f + 0.1f;
                while (!itemStack.func_190926_b()) {
                    int i = RANDOM.nextInt(21) + 10;
                    ItemEntity entityitem = new ItemEntity((World)worldServer, x + (double)f, y + (double)f1, z + (double)f2, itemStack.func_77979_a(i));
                    entityitem.func_213293_j(RANDOM.nextGaussian() * 0.05, RANDOM.nextGaussian() * 0.05 + 0.2, RANDOM.nextGaussian() * 0.05);
                    worldServer.func_217376_c((Entity)entityitem);
                }
            }
            return;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)worldServer, (double)x, (double)y, (double)z, (ItemStack)itemStack);
        }
    }

    public static Lens generateLens(net.minecraft.inventory.container.Container container, SlotLensProvider slots) {
        Map viewed = container.field_75151_b.stream().collect(Collectors.groupingBy(i -> Optional.ofNullable(i.field_75224_c), LinkedHashMap::new, Collectors.toList()));
        int index = 0;
        CraftingInventoryData crafting = new CraftingInventoryData();
        int chestHeight = 0;
        ArrayList<Lens> lenses = new ArrayList<Lens>();
        for (Map.Entry entry : viewed.entrySet()) {
            List slotList = (List)entry.getValue();
            int slotCount = slotList.size();
            IInventory subInventory = ((Optional)entry.getKey()).orElse(null);
            Lens lens = ContainerUtil.generateAdapterLens(slots, index, crafting, slotList, subInventory);
            if (lens.slotCount() != slotCount) {
                CompoundSlotLensProvider slotProvider = new CompoundSlotLensProvider().add(((InventoryBridge)subInventory).bridge$getAdapter());
                CompoundLens.Builder lensBuilder = CompoundLens.builder();
                for (Slot slot : slotList) {
                    lensBuilder.add(((InventoryBridge)slot).bridge$getAdapter().inventoryAdapter$getRootLens());
                }
                lens = lensBuilder.build(slotProvider);
            }
            lenses.add(lens);
            index += slotCount;
            if (chestHeight == -1) continue;
            if (lens instanceof DelegatingLens) {
                Lens delegated = ((DelegatingLens)lens).getDelegate();
                if (delegated instanceof PrimaryPlayerInventoryLens) {
                    delegated = ((PrimaryPlayerInventoryLens)delegated).getFullGrid();
                }
                if (delegated instanceof SingleGridLens) {
                    delegated = delegated.getSpanningChildren().get(0);
                }
                if (delegated instanceof GridInventoryLens) {
                    if (((GridInventoryLens)delegated).getWidth() == 9) {
                        chestHeight += ((GridInventoryLens)delegated).getHeight();
                        continue;
                    }
                    chestHeight = -1;
                    continue;
                }
                chestHeight = -1;
                continue;
            }
            chestHeight = -1;
        }
        ArrayList<Lens> additional = new ArrayList<Lens>();
        try {
            if (crafting.out != null && crafting.base != null && crafting.grid != null) {
                additional.add(new CraftingInventoryLens((int)crafting.out, (int)crafting.base, crafting.grid.func_174922_i(), crafting.grid.func_174923_h(), slots));
            } else if (crafting.base != null && crafting.grid != null) {
                additional.add(new GridInventoryLens(crafting.base, crafting.grid.func_174922_i(), crafting.grid.func_174923_h(), slots));
            }
        }
        catch (Exception e) {
            SpongeCommon.getLogger().error("Error while creating CraftingInventoryLensImpl or GridInventoryLensImpl for " + container.getClass().getName(), (Throwable)e);
        }
        if (chestHeight > 0) {
            additional.add(new GridInventoryLens(0, 9, chestHeight, slots));
        }
        return new ContainerLens(container.field_75151_b.size(), container.getClass(), slots, lenses, additional);
    }

    private static Lens generateAdapterLens(SlotLensProvider slots, int index, CraftingInventoryData crafting, List<Slot> slotList, @Nullable IInventory subInventory) {
        Slot slot;
        Lens lens = ((InventoryBridge)subInventory).bridge$getAdapter().inventoryAdapter$getRootLens();
        if (lens instanceof PlayerInventoryLens) {
            if (slotList.size() == 36) {
                return new DelegatingLens(index, new PrimaryPlayerInventoryLens(0, slots, true), slots);
            }
            return lens;
        }
        if (subInventory instanceof CraftResultInventory && (slot = slotList.get(0)) instanceof CraftingResultSlotAccessor) {
            crafting.out = index;
            if (crafting.base == null) {
                crafting.base = index + 1;
                crafting.grid = ((CraftingResultSlotAccessor)slot).accessor$craftSlots();
            }
        }
        if (subInventory instanceof CraftingInventory) {
            crafting.base = index;
            crafting.grid = (CraftingInventory)subInventory;
        }
        return new DelegatingLens(index, slotList, lens, slots);
    }

    @Nullable
    public static Carrier getCarrier(Container container) {
        ServerLocation loc;
        Object player;
        if (container instanceof BlockCarrier) {
            return (BlockCarrier)((Object)container);
        }
        if (container instanceof CustomContainer) {
            return ((CustomContainer)((Object)container)).inv.getCarrier();
        }
        if (container instanceof ChestContainer) {
            IInventory inventory = ((ChestContainer)container).func_85151_d();
            if (inventory instanceof Carrier) {
                if (inventory instanceof ChestTileEntity) {
                    return (Carrier)inventory;
                }
                if (inventory instanceof DoubleSidedInventory) {
                    return (BlockCarrier)inventory;
                }
            }
            return ContainerUtil.carrierOrNull(inventory);
        }
        if (container instanceof HopperContainerAccessor) {
            return ContainerUtil.carrierOrNull(((HopperContainerAccessor)((Object)container)).accessor$hopper());
        }
        if (container instanceof DispenserContainerAccessor) {
            return ContainerUtil.carrierOrNull(((DispenserContainerAccessor)((Object)container)).accessor$dispenser());
        }
        if (container instanceof AbstractFurnaceContainerAccessor) {
            return ContainerUtil.carrierOrNull(((AbstractFurnaceContainerAccessor)((Object)container)).accessor$container());
        }
        if (container instanceof BrewingStandContainerAccessor) {
            return ContainerUtil.carrierOrNull(((BrewingStandContainerAccessor)((Object)container)).accessor$brewingStand());
        }
        if (container instanceof BeaconContainer) {
            return new SpongeBlockEntityCarrier(((BeaconContainerAccessor)((Object)container)).accessor$access().func_221484_a(World::func_175625_s).orElse(null), container);
        }
        if (container instanceof HorseInventoryContainerAccessor) {
            return (Carrier)((HorseInventoryContainerAccessor)((Object)container)).accessor$horse();
        }
        if (container instanceof MerchantContainerAccessor && ((MerchantContainerAccessor)((Object)container)).accessor$trader() instanceof Carrier) {
            return (Carrier)((MerchantContainerAccessor)((Object)container)).accessor$trader();
        }
        if (container instanceof AbstractRepairContainerAccessor && (player = ((AbstractRepairContainerAccessor)((Object)container)).accessor$player()) instanceof ServerPlayerEntity) {
            return (Carrier)player;
        }
        if (container instanceof ContainerAccessor) {
            for (Slot slot : ((ContainerAccessor)((Object)container)).accessor$slots()) {
                if (slot.field_75224_c instanceof Carrier) {
                    return (Carrier)slot.field_75224_c;
                }
                if (!(slot.field_75224_c instanceof TileEntity)) continue;
                return new SpongeBlockEntityCarrier((TileEntity)slot.field_75224_c, container);
            }
        }
        if ((loc = ((ContainerBridge)((Object)container)).bridge$getOpenLocation()) != null) {
            return new SpongeLocationCarrier(loc, container);
        }
        return null;
    }

    private static Carrier carrierOrNull(IInventory inventory) {
        if (inventory instanceof Carrier) {
            return (Carrier)inventory;
        }
        if (inventory instanceof CarriedInventory) {
            Optional carrier = ((CarriedInventory)inventory).getCarrier();
            return carrier.orElse(null);
        }
        return null;
    }

    private static class CraftingInventoryData {
        @Nullable
        private Integer out;
        @Nullable
        private Integer base;
        @Nullable
        private CraftingInventory grid;

        private CraftingInventoryData() {
        }
    }
}

