/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.command;

import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.command.CommandSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.LocatableSnapshot;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.bridge.command.CommandSourceBridge;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={CommandSource.class})
public abstract class CommandSourceMixin_API
implements CommandCause {
    @Override
    public Cause getCause() {
        return ((CommandSourceBridge)((Object)this)).bridge$getCause();
    }

    @Override
    public Subject getSubject() {
        return this.getCause().getContext().get(EventContextKeys.SUBJECT).orElseGet(() -> this.getCause().first(Subject.class).orElseGet(Sponge::getSystemSubject));
    }

    @Override
    public Audience getAudience() {
        return this.getCause().getContext().get(EventContextKeys.AUDIENCE).orElseGet(() -> this.getCause().first(Audience.class).orElseGet(Sponge::getSystemSubject));
    }

    @Override
    public Optional<ServerLocation> getLocation() {
        Cause cause = this.getCause();
        EventContext eventContext = cause.getContext();
        if (eventContext.containsKey(EventContextKeys.LOCATION)) {
            return eventContext.get(EventContextKeys.LOCATION);
        }
        Optional<ServerLocation> optionalLocation = this.getTargetBlock().flatMap(LocatableSnapshot::getLocation);
        if (optionalLocation.isPresent()) {
            return optionalLocation;
        }
        return cause.first(Locatable.class).map(Locatable::getServerLocation);
    }

    @Override
    public Optional<Vector3d> getRotation() {
        Cause cause = this.getCause();
        EventContext eventContext = cause.getContext();
        if (eventContext.containsKey(EventContextKeys.ROTATION)) {
            return eventContext.get(EventContextKeys.ROTATION);
        }
        return cause.first(Entity.class).map(Entity::getRotation);
    }

    @Override
    public Optional<BlockSnapshot> getTargetBlock() {
        return Optional.ofNullable(this.getCause().getContext().get(EventContextKeys.BLOCK_TARGET).orElseGet(() -> this.getCause().first(BlockSnapshot.class).orElse(null)));
    }

    @Override
    public void sendMessage(@NonNull Identified identity, @NonNull Component message) {
        this.getAudience().sendMessage(identity, message);
    }

    @Override
    public void sendMessage(@NonNull Identity identity, @NonNull Component message) {
        this.getAudience().sendMessage(identity, message);
    }
}

