/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.entity;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Transform;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={net.minecraft.entity.Entity.class})
@Implements(value={@Interface(iface=Entity.class, prefix="entity$")})
public abstract class EntityMixin_API
implements Entity {
    @Shadow
    public float field_70177_z;
    @Shadow
    public float field_70125_A;
    @Shadow
    public boolean field_70128_L;
    @Final
    @Shadow
    protected Random field_70146_Z;
    @Shadow
    public int field_70173_aa;
    @Shadow
    protected UUID field_96093_i;
    @Shadow
    @Final
    private net.minecraft.entity.EntityType<?> field_200606_g;
    @Shadow
    public net.minecraft.world.World field_70170_p;

    @Shadow
    public abstract double shadow$func_226277_ct_();

    @Shadow
    public abstract double shadow$func_226278_cu_();

    @Shadow
    public abstract double shadow$func_226281_cx_();

    @Shadow
    public abstract net.minecraft.world.World shadow$func_130014_f_();

    @Shadow
    @Nullable
    public abstract MinecraftServer shadow$func_184102_h();

    @Shadow
    public abstract void shadow$func_70107_b(double var1, double var3, double var5);

    @Shadow
    public abstract void shadow$func_70106_y();

    @Shadow
    public abstract UUID shadow$func_110124_au();

    @Shadow
    public abstract void shadow$func_241209_g_(int var1);

    @Shadow
    public abstract boolean shadow$func_70097_a(DamageSource var1, float var2);

    @Shadow
    public abstract int shadow$func_145782_y();

    @Shadow
    public abstract void shadow$func_184185_a(SoundEvent var1, float var2, float var3);

    @Shadow
    protected abstract void shadow$func_70101_b(float var1, float var2);

    @Shadow
    public abstract AxisAlignedBB shadow$func_174813_aQ();

    @Shadow
    public abstract boolean shadow$func_184198_c(CompoundNBT var1);

    @Shadow
    @Nullable
    public abstract ITextComponent shadow$func_200201_e();

    @Shadow
    public abstract ITextComponent shadow$func_145748_c_();

    @Override
    public Random getRandom() {
        return this.field_70146_Z;
    }

    @Override
    public Vector3d getPosition() {
        return new Vector3d(this.shadow$func_226277_ct_(), this.shadow$func_226278_cu_(), this.shadow$func_226281_cx_());
    }

    @Override
    public World<?, ?> getWorld() {
        return (World)this.field_70170_p;
    }

    public ServerLocation getLocation() {
        return ServerLocation.of((ServerWorld)this.shadow$func_130014_f_(), this.getPosition());
    }

    @Override
    public boolean setLocation(ServerLocation location) {
        Preconditions.checkNotNull((Object)location, (Object)"The location was null!");
        return ((EntityBridge)((Object)this)).bridge$setLocation(location);
    }

    @Override
    public boolean setLocationAndRotation(ServerLocation location, Vector3d rotation) {
        if (this.setLocation(location)) {
            this.setRotation(rotation);
            return true;
        }
        return false;
    }

    @Override
    public Vector3d getScale() {
        return Vector3d.ONE;
    }

    @Override
    public void setScale(Vector3d scale) {
    }

    @Override
    public Transform getTransform() {
        return Transform.of(this.getPosition(), this.getRotation(), this.getScale());
    }

    @Override
    public boolean setTransform(Transform transform) {
        if (!PhaseTracker.SERVER.onSidedThread()) {
            return false;
        }
        Preconditions.checkNotNull((Object)transform, (Object)"The transform cannot be null!");
        Vector3d position = transform.getPosition();
        this.shadow$func_70107_b(position.getX(), position.getY(), position.getZ());
        this.setRotation(transform.getRotation());
        this.setScale(transform.getScale());
        if (!((WorldBridge)this.shadow$func_130014_f_()).bridge$isFake()) {
            ((net.minecraft.world.server.ServerWorld)this.shadow$func_130014_f_()).func_217464_b((net.minecraft.entity.Entity)this);
        }
        return true;
    }

    @Override
    public boolean transferToWorld(ServerWorld world, Vector3d position) {
        Preconditions.checkNotNull((Object)world, (Object)"World was null!");
        Preconditions.checkNotNull((Object)position, (Object)"Position was null!");
        return this.setLocation(ServerLocation.of(world, position));
    }

    @Override
    public Vector3d getRotation() {
        return new Vector3d(this.field_70125_A, this.field_70177_z, 0.0f);
    }

    @Override
    public void setRotation(Vector3d rotation) {
        Preconditions.checkNotNull((Object)rotation, (Object)"Rotation was null!");
        if (this.isRemoved()) {
            return;
        }
        if ((net.minecraft.entity.Entity)this instanceof ServerPlayerEntity && ((ServerPlayerEntity)((net.minecraft.entity.Entity)this)).field_71135_a != null) {
            ((ServerPlayerEntity)((net.minecraft.entity.Entity)this)).field_71135_a.func_175089_a(this.getPosition().getX(), this.getPosition().getY(), this.getPosition().getZ(), (float)rotation.getY(), (float)rotation.getX(), EnumSet.noneOf(SPlayerPositionLookPacket.Flags.class));
        } else {
            if (!this.shadow$func_130014_f_().field_72995_K) {
                ((ServerWorldBridge)((Object)this.getWorld())).bridge$addEntityRotationUpdate((net.minecraft.entity.Entity)this, rotation);
            }
            this.shadow$func_70101_b((float)rotation.getY(), (float)rotation.getX());
        }
    }

    @Override
    public Optional<AABB> getBoundingBox() {
        AxisAlignedBB boundingBox = this.shadow$func_174813_aQ();
        if (boundingBox == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(VecHelper.toSpongeAABB(boundingBox));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    @Override
    public boolean isRemoved() {
        return this.field_70128_L;
    }

    @Override
    public boolean isLoaded() {
        return !this.isRemoved();
    }

    @Intrinsic
    public void entity$remove() {
        this.shadow$func_70106_y();
    }

    @Override
    public boolean damage(double damage, org.spongepowered.api.event.cause.entity.damage.source.DamageSource damageSource) {
        if (!(damageSource instanceof DamageSource)) {
            SpongeCommon.getLogger().error("An illegal DamageSource was provided in the cause! The damage source must extend AbstractDamageSource!");
            return false;
        }
        return this.shadow$func_70097_a((DamageSource)damageSource, (float)damage);
    }

    public EntityType getType() {
        return (EntityType)this.field_200606_g;
    }

    @Override
    public UUID getUniqueId() {
        return this.field_96093_i;
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        Transform transform = this.getTransform();
        CompoundNBT compound = new CompoundNBT();
        this.shadow$func_184198_c(compound);
        DataContainer unsafeNbt = NBTTranslator.INSTANCE.translateFrom(compound);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Constants.Entity.CLASS, this.getClass().getName()).set(Queries.WORLD_KEY, ((ServerWorld)this.getWorld()).getKey().getFormatted()).createView(Constants.Sponge.SNAPSHOT_WORLD_POSITION).set(Queries.POSITION_X, transform.getPosition().getX()).set(Queries.POSITION_Y, transform.getPosition().getY()).set(Queries.POSITION_Z, transform.getPosition().getZ()).getContainer().createView(Constants.Entity.ROTATION).set(Queries.POSITION_X, transform.getRotation().getX()).set(Queries.POSITION_Y, transform.getRotation().getY()).set(Queries.POSITION_Z, transform.getRotation().getZ()).getContainer().createView(Constants.Entity.SCALE).set(Queries.POSITION_X, transform.getScale().getX()).set(Queries.POSITION_Y, transform.getScale().getY()).set(Queries.POSITION_Z, transform.getScale().getZ()).getContainer().set(Constants.Entity.TYPE, Registry.field_212629_r.func_177774_c((Object)((net.minecraft.entity.EntityType)this.getType()))).set(Constants.Sponge.UNSAFE_NBT, unsafeNbt);
        return container;
    }

    @Override
    public Entity copy() {
        if (this instanceof Player) {
            throw new IllegalArgumentException("Cannot copy player entities!");
        }
        try {
            CompoundNBT compound = new CompoundNBT();
            this.shadow$func_184198_c(compound);
            net.minecraft.entity.Entity entity = net.minecraft.entity.EntityType.func_220335_a((CompoundNBT)compound, (net.minecraft.world.World)this.shadow$func_130014_f_(), createdEntity -> {
                compound.func_186854_a("UUID", createdEntity.func_110124_au());
                createdEntity.func_70020_e(compound);
                return createdEntity;
            });
            return (Entity)entity;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not copy the entity:", e);
        }
    }

    @Override
    public boolean canSee(Entity entity) {
        Optional optional = entity.get(Keys.VANISH);
        return (!optional.isPresent() || (Boolean)optional.get() == false) && !((VanishableBridge)((Object)entity)).bridge$isVanished();
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return this.api$getVanillaValues();
    }

    @Override
    public EntitySnapshot createSnapshot() {
        return (EntitySnapshot)EntitySnapshot.builder().from(this).build();
    }

    @Override
    public EntityArchetype createArchetype() {
        return EntityArchetype.builder().from(this).build();
    }

    @Override
    public HoverEvent<HoverEvent.ShowEntity> asHoverEvent(UnaryOperator<HoverEvent.ShowEntity> op) {
        ResourceLocation entityTypeKey = Registry.field_212629_r.func_177774_c((Object)((net.minecraft.entity.EntityType)this.getType()));
        return HoverEvent.showEntity((HoverEvent.ShowEntity)((HoverEvent.ShowEntity)op.apply(HoverEvent.ShowEntity.of((Key)((Key)entityTypeKey), (UUID)this.getUniqueId(), (Component)((Component)this.displayName().get())))));
    }

    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        HashSet values = new HashSet();
        values.add(this.displayName().asImmutable());
        values.add(this.fallDistance().asImmutable());
        values.add(this.passengers().asImmutable());
        values.add(this.onGround().asImmutable());
        values.add(this.velocity().asImmutable());
        values.add(this.gravityAffected().asImmutable());
        values.add(this.silent().asImmutable());
        this.baseVehicle().map(Value::asImmutable).ifPresent(values::add);
        this.creator().map(Value::asImmutable).ifPresent(values::add);
        this.notifier().map(Value::asImmutable).ifPresent(values::add);
        this.fireTicks().map(Value::asImmutable).ifPresent(values::add);
        this.fireImmuneTicks().map(Value::asImmutable).ifPresent(values::add);
        return values;
    }
}

