/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.entity;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.potion.EffectInstance;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.entity.projectile.ProjectileUtil;
import org.spongepowered.common.mixin.api.mcp.entity.EntityMixin_API;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin_API
extends EntityMixin_API
implements Living {
    @Shadow
    public abstract float shadow$func_110143_aJ();

    @Shadow
    public abstract ModifiableAttributeInstance shadow$func_110148_a(Attribute var1);

    @Shadow
    public abstract boolean func_195064_c(EffectInstance var1);

    @Override
    public Component getTeamRepresentation() {
        return Component.text((String)this.shadow$func_110124_au().toString());
    }

    @Override
    public Optional<org.spongepowered.api.entity.attribute.Attribute> getAttribute(AttributeType type) {
        Preconditions.checkNotNull((Object)type, (Object)"AttributeType cannot be null");
        return Optional.ofNullable((org.spongepowered.api.entity.attribute.Attribute)this.shadow$func_110148_a((Attribute)type));
    }

    @Override
    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        Set<Value.Immutable<?>> values = super.api$getVanillaValues();
        values.add(this.health().asImmutable());
        values.add(this.maxHealth().asImmutable());
        values.add(this.lastAttacker().asImmutable());
        values.add(this.headRotation().asImmutable());
        this.lastDamageReceived().map(Value::asImmutable).ifPresent(values::add);
        return values;
    }

    @Override
    public <T extends Projectile> Optional<T> launchProjectile(EntityType<T> projectileType) {
        return ProjectileUtil.launch(Objects.requireNonNull(projectileType, "projectileType"), this, null);
    }

    @Override
    public <T extends Projectile> Optional<T> launchProjectile(EntityType<T> projectileType, Vector3d velocity) {
        return ProjectileUtil.launch(Objects.requireNonNull(projectileType, "projectileType"), this, Objects.requireNonNull(velocity, "velocity"));
    }

    @Override
    public <T extends Projectile> Optional<T> launchProjectileTo(EntityType<T> projectileType, Entity target) {
        return Optional.empty();
    }
}

