/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.registry.Registry;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.SerializableDataHolder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.item.SpongeItemStackSnapshot;
import org.spongepowered.common.util.Constants;

@Mixin(value={net.minecraft.item.ItemStack.class})
@Implements(value={@Interface(iface=ItemStack.class, prefix="itemStack$")})
public abstract class ItemStackMixin_API
implements SerializableDataHolder.Mutable {
    @Shadow
    public abstract int shadow$func_190916_E();

    @Shadow
    public abstract void shadow$func_190920_e(int var1);

    @Shadow
    public abstract void shadow$func_196085_b(int var1);

    @Shadow
    public abstract void shadow$func_77982_d(@Nullable CompoundNBT var1);

    @Shadow
    public abstract int shadow$func_77952_i();

    @Shadow
    public abstract int shadow$func_77976_d();

    @Shadow
    public abstract boolean shadow$func_77942_o();

    @Shadow
    public abstract boolean shadow$func_190926_b();

    @Shadow
    public abstract CompoundNBT shadow$func_77978_p();

    @Shadow
    public abstract net.minecraft.item.ItemStack shadow$func_77946_l();

    @Shadow
    public abstract Item shadow$func_77973_b();

    @Shadow
    public abstract Multimap<String, AttributeModifier> shadow$func_111283_C(EquipmentSlotType var1);

    @Shadow
    public abstract void shadow$func_185129_a(Attribute var1, AttributeModifier var2, @Nullable EquipmentSlotType var3);

    public int itemStack$getQuantity() {
        return this.shadow$func_190916_E();
    }

    public ItemType itemStack$getType() {
        return (ItemType)this.shadow$func_77973_b();
    }

    public void itemStack$setQuantity(int quantity) throws IllegalArgumentException {
        this.shadow$func_190920_e(quantity);
    }

    public int itemStack$getMaxStackQuantity() {
        return this.shadow$func_77976_d();
    }

    @Override
    public boolean validateRawData(DataView container) {
        Preconditions.checkNotNull((Object)container);
        return false;
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull((Object)container);
        if (this.shadow$func_190926_b()) {
            throw new IllegalArgumentException("Cannot set data on empty item stacks!");
        }
        if (!container.contains(Constants.Sponge.UNSAFE_NBT)) {
            throw new InvalidDataException("There's no NBT Data set in the provided container");
        }
        DataView nbtData = container.getView(Constants.Sponge.UNSAFE_NBT).get();
        try {
            int integer = container.getInt(Constants.ItemStack.DAMAGE_VALUE).orElse(this.shadow$func_77952_i());
            this.shadow$func_196085_b(integer);
            CompoundNBT stackCompound = NBTTranslator.INSTANCE.translate(nbtData);
            this.shadow$func_77982_d(stackCompound);
        }
        catch (Exception e) {
            throw new InvalidDataException("Unable to set raw data or translate raw data for ItemStack setting", e);
        }
    }

    @Override
    public SerializableDataHolder.Mutable copy() {
        return this.itemStack$copy();
    }

    public ItemStack itemStack$copy() {
        return (ItemStack)this.shadow$func_77946_l();
    }

    public Collection<org.spongepowered.api.entity.attribute.AttributeModifier> itemStack$getAttributeModifiers(AttributeType attributeType, EquipmentType equipmentType) {
        Preconditions.checkNotNull((Object)attributeType, (Object)"Attribute type cannot be null");
        Preconditions.checkNotNull((Object)equipmentType, (Object)"Equipment type cannot be null");
        ImmutableList.Builder builder = ImmutableList.builder();
        return builder.build();
    }

    public void itemStack$addAttributeModifier(AttributeType attributeType, org.spongepowered.api.entity.attribute.AttributeModifier modifier, EquipmentType equipmentType) {
        Preconditions.checkNotNull((Object)attributeType, (Object)"Attribute type cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"Attribute modifier cannot be null");
        Preconditions.checkNotNull((Object)equipmentType, (Object)"Equipment type cannot be null");
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        ResourceKey key = (ResourceKey)Registry.field_212630_s.func_177774_c((Object)((Item)this.itemStack$getType()));
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Constants.ItemStack.TYPE, key).set(Constants.ItemStack.COUNT, this.itemStack$getQuantity()).set(Constants.ItemStack.DAMAGE_VALUE, this.shadow$func_77952_i());
        if (this.shadow$func_77942_o()) {
            CompoundNBT spongeCompound;
            CompoundNBT compound = this.shadow$func_77978_p().func_74737_b();
            if (compound.func_74764_b("SpongeData") && (spongeCompound = compound.func_74775_l("SpongeData")).func_74764_b("CustomManipulators")) {
                spongeCompound.func_82580_o("CustomManipulators");
            }
            Constants.NBT.filterSpongeCustomData(compound);
            if (!compound.isEmpty()) {
                DataContainer unsafeNbt = NBTTranslator.INSTANCE.translateFrom(compound);
                container.set(Constants.Sponge.UNSAFE_NBT, unsafeNbt);
            }
        }
        try {
            PlatformHooks.INSTANCE.getItemHooks().writeItemStackCapabilitiesToDataView(container, (net.minecraft.item.ItemStack)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return container;
    }

    public ItemStackSnapshot itemStack$createSnapshot() {
        return new SpongeItemStackSnapshot((ItemStack)((Object)this));
    }

    public boolean itemStack$equalTo(ItemStack that) {
        return net.minecraft.item.ItemStack.func_77970_a((net.minecraft.item.ItemStack)((net.minecraft.item.ItemStack)this), (net.minecraft.item.ItemStack)((net.minecraft.item.ItemStack)that));
    }

    @Intrinsic
    public boolean itemStack$isEmpty() {
        return this.shadow$func_190926_b();
    }
}

