/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.item.crafting;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.StonecutterContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.CampfireTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.RecipeRegistry;
import org.spongepowered.api.item.recipe.RecipeType;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.accessor.inventory.container.PlayerContainerAccessor;
import org.spongepowered.common.accessor.inventory.container.WorkbenchContainerAccessor;
import org.spongepowered.common.accessor.tileentity.AbstractFurnaceTileEntityAccessor;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={RecipeManager.class})
public abstract class RecipeManagerMixin_API
implements RecipeRegistry {
    @Shadow
    private Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> field_199522_d;

    @Shadow
    public abstract Optional<? extends IRecipe<?>> shadow$func_215367_a(ResourceLocation var1);

    @Shadow
    protected abstract <C extends IInventory, T extends IRecipe<C>> Map<ResourceLocation, IRecipe<C>> shadow$func_215366_a(IRecipeType<T> var1);

    @Shadow
    public abstract Collection<IRecipe<?>> shadow$func_199510_b();

    @Shadow
    public abstract <C extends IInventory, T extends IRecipe<C>> Optional<T> shadow$func_215371_a(IRecipeType<T> var1, C var2, World var3);

    @Override
    public Optional<Recipe> getByKey(ResourceKey key) {
        Preconditions.checkNotNull((Object)key);
        return this.shadow$func_215367_a((ResourceLocation)key).map(Recipe.class::cast);
    }

    @Override
    public Collection<Recipe> getAll() {
        return this.shadow$func_199510_b();
    }

    @Override
    public <T extends Recipe> Collection<T> getAllOfType(RecipeType<T> type) {
        Preconditions.checkNotNull(type);
        return this.shadow$func_215366_a((IRecipeType)type).values();
    }

    @Override
    public <T extends Recipe> Collection<T> findByResult(RecipeType<T> type, ItemStackSnapshot result) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull((Object)result);
        return this.getAllOfType(type).stream().filter(r -> r.getExemplaryResult().equals(result)).collect(Collectors.toList());
    }

    @Override
    public Optional<Recipe> findMatchingRecipe(Inventory inventory, ServerWorld world) {
        Preconditions.checkNotNull((Object)inventory);
        Preconditions.checkNotNull((Object)world);
        if (inventory instanceof AbstractFurnaceTileEntity) {
            IRecipeType<? extends AbstractCookingRecipe> type = ((AbstractFurnaceTileEntityAccessor)((Object)inventory)).accessor$recipeType();
            return this.shadow$func_215371_a(type, (IInventory)inventory, (World)world).map(Recipe.class::cast);
        }
        if (inventory instanceof CampfireTileEntity) {
            return this.shadow$func_215371_a(IRecipeType.field_222153_e, (IInventory)inventory, (World)world).map(Recipe.class::cast);
        }
        if (inventory instanceof WorkbenchContainer) {
            CraftingInventory craftingInventory = ((WorkbenchContainerAccessor)((Object)inventory)).accessor$craftSlots();
            return this.shadow$func_215371_a(IRecipeType.field_222149_a, craftingInventory, (World)world).map(Recipe.class::cast);
        }
        if (inventory instanceof PlayerContainer) {
            CraftingInventory craftingInventory = ((PlayerContainerAccessor)((Object)inventory)).accessor$craftSlots();
            return this.shadow$func_215371_a(IRecipeType.field_222149_a, craftingInventory, (World)world).map(Recipe.class::cast);
        }
        if (inventory instanceof StonecutterContainer) {
            IInventory stonecutterInventory = ((StonecutterContainer)inventory).field_217087_f;
            return this.shadow$func_215371_a(IRecipeType.field_222154_f, stonecutterInventory, (World)world).map(Recipe.class::cast);
        }
        return Optional.empty();
    }

    @Override
    public <T extends Recipe> Optional<T> findMatchingRecipe(RecipeType<T> type, Inventory inventory, ServerWorld world) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull((Object)inventory);
        Preconditions.checkNotNull((Object)world);
        if (!(inventory instanceof IInventory)) {
            return Optional.empty();
        }
        return this.shadow$func_215371_a((IRecipeType)type, (IInventory)inventory, (World)world);
    }

    @Override
    public <T extends CookingRecipe> Optional<T> findCookingRecipe(RecipeType<T> type, ItemStackSnapshot ingredient) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull((Object)ingredient);
        net.minecraft.inventory.Inventory fakeFurnace = new net.minecraft.inventory.Inventory(1);
        fakeFurnace.func_70299_a(0, ItemStackUtil.fromSnapshotToNative(ingredient));
        return this.shadow$func_215371_a((IRecipeType)type, fakeFurnace, null);
    }

    @Redirect(method={"apply"}, at=@At(value="INVOKE", target="Ljava/util/Map;size()I"))
    public int impl$getActualRecipeCount(Map<IRecipeType<?>, ImmutableMap.Builder<ResourceLocation, IRecipe<?>>> map) {
        return this.field_199522_d.values().stream().mapToInt(Map::size).sum();
    }
}

