/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.server.management;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.management.PlayerProfileCache;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.server.management.PlayerProfileCache_ProfileEntryAccessor;
import org.spongepowered.common.profile.SpongeGameProfile;

@Mixin(value={PlayerProfileCache.class})
public abstract class PlayerProfileCacheMixin_API
implements GameProfileCache {
    @Shadow
    @Final
    @Mutable
    private final Map<String, PlayerProfileCache_ProfileEntryAccessor> field_152661_c = new ConcurrentHashMap<String, PlayerProfileCache_ProfileEntryAccessor>();
    @Shadow
    @Final
    @Mutable
    private final Map<UUID, PlayerProfileCache_ProfileEntryAccessor> field_152662_d = new ConcurrentHashMap<UUID, PlayerProfileCache_ProfileEntryAccessor>();

    @Nullable
    @Shadow
    public abstract com.mojang.authlib.GameProfile shadow$func_152652_a(UUID var1);

    @Shadow
    protected abstract long shadow$func_242123_d();

    @Override
    public boolean remove(GameProfile profile) {
        Objects.requireNonNull(profile, "profile");
        UUID uniqueId = profile.getUniqueId();
        PlayerProfileCache_ProfileEntryAccessor entry = this.field_152662_d.remove(uniqueId);
        if (entry != null) {
            if (profile.getName().isPresent()) {
                this.field_152661_c.remove(profile.getName().get().toLowerCase(Locale.ROOT));
            }
            return entry.invoker$getExpirationDate().getTime() >= System.currentTimeMillis();
        }
        return false;
    }

    @Override
    public Collection<GameProfile> remove(Iterable<GameProfile> profiles) {
        Objects.requireNonNull(profiles, "profiles");
        ArrayList<GameProfile> result = new ArrayList<GameProfile>();
        for (GameProfile profile : profiles) {
            if (!this.remove(profile)) continue;
            result.add(profile);
        }
        return result;
    }

    @Override
    public Collection<GameProfile> removeIf(Predicate<GameProfile> filter) {
        Objects.requireNonNull(filter, "filter");
        ArrayList<GameProfile> result = new ArrayList<GameProfile>();
        Iterator<PlayerProfileCache_ProfileEntryAccessor> it = this.field_152662_d.values().iterator();
        while (it.hasNext()) {
            boolean isExpired;
            PlayerProfileCache_ProfileEntryAccessor entry = it.next();
            SpongeGameProfile profile = SpongeGameProfile.of(entry.invoker$getProfile());
            boolean bl = isExpired = entry.invoker$getExpirationDate().getTime() < System.currentTimeMillis();
            if (!isExpired && !filter.test(profile)) continue;
            it.remove();
            profile.getName().ifPresent(name -> this.field_152661_c.remove(name, entry));
            if (isExpired) continue;
            result.add(profile);
        }
        return result;
    }

    @Override
    public void clear() {
        this.field_152662_d.clear();
        this.field_152661_c.clear();
    }

    @Override
    public Optional<GameProfile> getById(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        return Optional.ofNullable(this.shadow$func_152652_a(uniqueId)).map(SpongeGameProfile::of);
    }

    @Override
    public Map<UUID, Optional<GameProfile>> getByIds(Iterable<UUID> uniqueIds) {
        Objects.requireNonNull(uniqueIds, "uniqueIds");
        HashMap<UUID, Optional<GameProfile>> result = new HashMap<UUID, Optional<GameProfile>>();
        for (UUID uniqueId : uniqueIds) {
            result.put(uniqueId, Optional.ofNullable(this.shadow$func_152652_a(uniqueId)).map(SpongeGameProfile::of));
        }
        return result.isEmpty() ? ImmutableMap.of() : ImmutableMap.copyOf(result);
    }

    @Override
    public Optional<GameProfile> getByName(String name) {
        Objects.requireNonNull(name, "name");
        PlayerProfileCache_ProfileEntryAccessor entry = this.field_152661_c.get(name.toLowerCase(Locale.ROOT));
        if (entry != null && System.currentTimeMillis() >= entry.invoker$getExpirationDate().getTime()) {
            com.mojang.authlib.GameProfile profile = entry.invoker$getProfile();
            this.field_152662_d.remove(profile.getId());
            this.field_152661_c.remove(profile.getName().toLowerCase(Locale.ROOT));
            entry = null;
        }
        return Optional.ofNullable(this.api$updateLastAccess(entry));
    }

    @Override
    public Map<String, Optional<GameProfile>> getByNames(Iterable<String> names) {
        Objects.requireNonNull(names, "names");
        HashMap result = Maps.newHashMap();
        for (String name : names) {
            result.put(name, this.getByName(name));
        }
        return ImmutableMap.copyOf((Map)result);
    }

    @Override
    public Stream<GameProfile> stream() {
        return this.field_152661_c.values().stream().map(entry -> SpongeGameProfile.of(entry.invoker$getProfile()));
    }

    @Override
    public Collection<GameProfile> all() {
        return (Collection)this.field_152661_c.values().stream().map(this::api$updateLastAccess).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Stream<GameProfile> streamOfMatches(String name) {
        String search = Objects.requireNonNull(name, "name").toLowerCase(Locale.ROOT);
        return this.field_152661_c.values().stream().filter(profile -> profile.invoker$getProfile().getName() != null).filter(profile -> profile.invoker$getProfile().getName().toLowerCase(Locale.ROOT).startsWith(search)).map(this::api$updateLastAccess);
    }

    @Override
    public Collection<GameProfile> allMatches(String name) {
        return (Collection)this.streamOfMatches(name).collect(ImmutableSet.toImmutableSet());
    }

    @Nullable
    private SpongeGameProfile api$updateLastAccess(@Nullable PlayerProfileCache_ProfileEntryAccessor entry) {
        if (entry == null) {
            return null;
        }
        entry.invoker$setLastAccess(this.shadow$func_242123_d());
        return SpongeGameProfile.of(entry.invoker$getProfile());
    }
}

