/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.tileentity;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.block.entity.SpongeBlockEntityArchetypeBuilder;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={TileEntity.class})
public abstract class TileEntityMixin_API
implements BlockEntity {
    @Shadow
    @Final
    private TileEntityType<?> field_200663_e;
    @Shadow
    protected World field_145850_b;
    @Shadow
    protected boolean field_145846_f;
    @Nullable
    private LocatableBlock api$LocatableBlock;

    @Shadow
    public abstract BlockPos shadow$func_174877_v();

    @Shadow
    public abstract CompoundNBT shadow$func_189515_b(CompoundNBT var1);

    public ServerLocation getLocation() {
        return ServerLocation.of((ServerWorld)this.field_145850_b, VecHelper.toVector3i(this.shadow$func_174877_v()));
    }

    @Override
    public ServerLocation getServerLocation() {
        if (this.field_145850_b == null) {
            throw new RuntimeException("The TileEntity has not been spawned in a world yet!");
        }
        if (this.field_145850_b.field_72995_K) {
            throw new RuntimeException("You should not attempt to make a server-side location on the client!");
        }
        BlockPos pos = this.shadow$func_174877_v();
        return ServerLocation.of((ServerWorld)this.field_145850_b, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public org.spongepowered.api.world.World<?, ?> getWorld() {
        return (org.spongepowered.api.world.World)this.field_145850_b;
    }

    @Override
    public Vector3i getBlockPosition() {
        return VecHelper.toVector3i(this.shadow$func_174877_v());
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        ResourceKey key = (ResourceKey)Registry.field_212626_o.func_177774_c(this.field_200663_e);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Queries.WORLD_KEY, ((ServerWorld)this.field_145850_b).getKey()).set(Queries.POSITION_X, this.shadow$func_174877_v().func_177958_n()).set(Queries.POSITION_Y, this.shadow$func_174877_v().func_177956_o()).set(Queries.POSITION_Z, this.shadow$func_174877_v().func_177952_p()).set(Constants.TileEntity.TILE_TYPE, key);
        CompoundNBT compound = new CompoundNBT();
        this.shadow$func_189515_b(compound);
        Constants.NBT.filterSpongeCustomData(compound);
        container.set(Constants.Sponge.UNSAFE_NBT, NBTTranslator.INSTANCE.translateFrom(compound));
        return container;
    }

    @Override
    public boolean validateRawData(DataView container) {
        return container.contains(Queries.WORLD_KEY) && container.contains(Queries.POSITION_X) && container.contains(Queries.POSITION_Y) && container.contains(Queries.POSITION_Z) && container.contains(Constants.TileEntity.TILE_TYPE) && container.contains(Constants.Sponge.UNSAFE_NBT);
    }

    @Override
    public boolean isValid() {
        return !this.field_145846_f;
    }

    @Override
    public void setValid(boolean valid) {
        this.field_145846_f = valid;
    }

    @Override
    public final BlockEntityType getType() {
        return (BlockEntityType)this.field_200663_e;
    }

    @Override
    public BlockState getBlock() {
        return (BlockState)this.field_145850_b.func_180495_p(this.shadow$func_174877_v());
    }

    @Override
    public BlockEntityArchetype createArchetype() {
        BlockEntityArchetype build = new SpongeBlockEntityArchetypeBuilder().blockEntity(this).build();
        return build;
    }

    @Override
    public LocatableBlock getLocatableBlock() {
        if (this.api$LocatableBlock == null) {
            BlockState blockState = this.getBlock();
            this.api$LocatableBlock = new SpongeLocatableBlockBuilder().world((ServerWorld)this.field_145850_b).position(this.shadow$func_174877_v().func_177958_n(), this.shadow$func_174877_v().func_177956_o(), this.shadow$func_174877_v().func_177952_p()).state(blockState).build();
        }
        return this.api$LocatableBlock;
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return this.api$getVanillaValues();
    }

    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        return new HashSet();
    }
}

