/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.util.registry;

import com.mojang.serialization.Lifecycle;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.ValueNotFoundException;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.accessor.util.RegistryKeyAccessor;
import org.spongepowered.common.bridge.util.registry.RegistryBridge;
import org.spongepowered.common.registry.SpongeRegistryType;

@Mixin(value={Registry.class})
@Implements(value={@Interface(iface=org.spongepowered.api.registry.Registry.class, prefix="registry$")})
public abstract class RegistryMixin_API<T>
implements org.spongepowered.api.registry.Registry<T> {
    private RegistryType<T> api$type;

    @Shadow
    public abstract RegistryKey<? extends Registry<T>> shadow$func_243578_f();

    @Shadow
    @Nullable
    public abstract ResourceLocation shadow$func_177774_c(T var1);

    @Shadow
    @Nullable
    public abstract T func_82594_a(@org.checkerframework.checker.nullness.qual.Nullable ResourceLocation var1);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void api$setType(RegistryKey<? extends Registry<T>> key, Lifecycle p_i232510_2_, CallbackInfo ci) {
        this.api$type = new SpongeRegistryType((ResourceKey)((RegistryKeyAccessor)key).accessor$registryName(), (ResourceKey)key.func_240901_a_());
    }

    @Override
    public RegistryType<T> type() {
        return this.api$type;
    }

    @Override
    public ResourceKey valueKey(T value) {
        Objects.requireNonNull(value, "value");
        ResourceLocation key = this.shadow$func_177774_c(value);
        if (key == null) {
            throw new IllegalStateException(String.format("No key was found for '%s'!", value));
        }
        return (ResourceKey)key;
    }

    @Override
    public Optional<ResourceKey> findValueKey(T value) {
        Objects.requireNonNull(value, "value");
        return Optional.ofNullable(this.shadow$func_177774_c(value)).map(l -> (ResourceKey)l);
    }

    @Override
    public <V extends T> Optional<RegistryEntry<V>> findEntry(ResourceKey key) {
        Objects.requireNonNull(key, "key");
        return Optional.ofNullable(((RegistryBridge)((Object)this)).bridge$getEntries().get(key));
    }

    @Override
    public <V extends T> Optional<V> findValue(ResourceKey key) {
        Objects.requireNonNull(key, "key");
        return Optional.ofNullable(this.func_82594_a((ResourceLocation)key));
    }

    @Override
    public <V extends T> V value(ResourceKey key) {
        Objects.requireNonNull(key, "key");
        T value = this.func_82594_a((ResourceLocation)key);
        if (value == null) {
            throw new ValueNotFoundException(String.format("No value was found for key '%s'!", key));
        }
        return (V)value;
    }

    @Override
    public Stream<RegistryEntry<T>> streamEntries() {
        return ((RegistryBridge)((Object)this)).bridge$getEntries().values().stream();
    }

    @Intrinsic
    public Stream<T> registry$stream() {
        return ((RegistryBridge)((Object)this)).bridge$getEntries().values().stream().map(RegistryEntry::value);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public <V extends T> Optional<RegistryEntry<V>> register(ResourceKey key, V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        return Optional.empty();
    }
}

