/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.storage.IWorldInfo;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.ProtoWorld;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.chunk.ProtoChunk;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.biome.BiomeContainerAccessor;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vectori;

@Mixin(value={IWorld.class})
@Implements(value={@Interface(iface=ProtoWorld.class, prefix="protoWorld$")})
public interface IWorldMixin_API {
    @Shadow
    public boolean shadow$func_217354_b(int var1, int var2);

    @Shadow
    public Random shadow$func_201674_k();

    @Shadow
    public IWorldInfo shadow$func_72912_H();

    default public boolean protoWorld$setBiome(int x, int y, int z, Biome biome) {
        Objects.requireNonNull(biome, "biome");
        IChunk iChunk = ((IWorldReader)this).func_217353_a(x >> 4, z >> 4, ChunkStatus.field_222608_d, true);
        if (iChunk == null) {
            return false;
        }
        if (iChunk instanceof ProtoChunk) {
            return ((ProtoChunk)iChunk).setBiome(x, y, z, biome);
        }
        net.minecraft.world.biome.Biome[] biomes = ((BiomeContainerAccessor)iChunk.func_225549_i_()).accessor$biomes();
        int maskedX = x & BiomeContainer.field_227050_b_;
        int maskedY = MathHelper.func_76125_a((int)y, (int)0, (int)BiomeContainer.field_227051_c_);
        int maskedZ = z & BiomeContainer.field_227050_b_;
        int WIDTH_BITS = BiomeContainerAccessor.accessor$WIDTH_BITS();
        int posKey = maskedY << WIDTH_BITS + WIDTH_BITS | maskedZ << WIDTH_BITS | maskedX;
        biomes[posKey] = (net.minecraft.world.biome.Biome)biome;
        return true;
    }

    default public Vector3i protoWorld$getBlockMin() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of IWorld that isn't part of Sponge API: " + this.getClass());
    }

    default public Vector3i protoWorld$getBlockMax() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of IWorld that isn't part of Sponge API: " + this.getClass());
    }

    default public Vector3i protoWorld$getBlockSize() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of IWorld that isn't part of Sponge API: " + this.getClass());
    }

    default public boolean protoWorld$containsBlock(int x, int y, int z) {
        return this.shadow$func_217354_b(x >> 4, z >> 4);
    }

    default public boolean protoWorld$isAreaAvailable(int x, int y, int z) {
        return this.shadow$func_217354_b(x >> 4, z >> 4);
    }

    default public Optional<Entity> protoWorld$getEntity(UUID uuid) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of IWorld that isn't part of Sponge API: " + this.getClass());
    }

    @Intrinsic
    default public Random protoWorld$getRandom() {
        return this.shadow$func_201674_k();
    }

    default public Difficulty protoWorld$getDifficulty() {
        return (Difficulty)this.shadow$func_72912_H().func_176130_y();
    }

    default public Collection<Entity> protoWorld$spawnEntities(Iterable<? extends Entity> entities) {
        Objects.requireNonNull(entities, "entities");
        ArrayList<Entity> entitiesToSpawn = new ArrayList<Entity>();
        entities.forEach(entitiesToSpawn::add);
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(PhaseTracker.getCauseStackManager().getCurrentCause(), entitiesToSpawn);
        if (Sponge.getEventManager().post(event)) {
            return Collections.emptyList();
        }
        for (Entity entity : event.getEntities()) {
            EntityUtil.processEntitySpawn(entity, Optional::empty);
        }
        return Collections.unmodifiableCollection(new ArrayList<Entity>(event.getEntities()));
    }

    default public boolean protoWorld$spawnEntity(Entity entity) {
        return ((IWorld)this).func_217376_c((net.minecraft.entity.Entity)Objects.requireNonNull(entity, "entity"));
    }

    default public boolean protoWorld$setBlock(int x, int y, int z, BlockState blockState, BlockChangeFlag flag) {
        Objects.requireNonNull(blockState, "blockState");
        Objects.requireNonNull(flag, "flag");
        if (!World.func_175701_a((BlockPos)new BlockPos(x, y, z))) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)Constants.World.BLOCK_MIN, (Vectori)Constants.World.BLOCK_MAX);
        }
        try (@Nullable PhaseContext<@NonNull ?> context = PluginPhase.State.BLOCK_WORKER.switchIfNecessary(PhaseTracker.SERVER);){
            if (context != null) {
                context.buildAndSwitch();
            }
            boolean bl = ((IWorld)this).func_180501_a(new BlockPos(x, y, z), (net.minecraft.block.BlockState)blockState, ((SpongeBlockChangeFlag)flag).getRawFlag());
            return bl;
        }
    }
}

