/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.HeightType;
import org.spongepowered.api.world.ProtoWorld;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.chunk.ProtoChunk;
import org.spongepowered.api.world.volume.game.Region;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.tileentity.TileEntityAccessor;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.ObjectArrayMutableBiomeBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.volume.buffer.blockentity.ObjectArrayMutableBlockEntityBuffer;
import org.spongepowered.common.world.volume.buffer.entity.ObjectArrayMutableEntityBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={IWorldReader.class})
@Implements(value={@Interface(iface=Region.class, prefix="region$")})
public interface IWorldReaderMixin_API<R extends Region<R>>
extends Region<R> {
    @Shadow
    public @Nullable IChunk shadow$func_217353_a(int var1, int var2, ChunkStatus var3, boolean var4);

    @Deprecated
    @Shadow
    public boolean shadow$func_217354_b(int var1, int var2);

    @Shadow
    public int shadow$func_201676_a(Heightmap.Type var1, int var2, int var3);

    @Shadow
    public int shadow$func_175657_ab();

    @Shadow
    public int shadow$func_181545_F();

    @Shadow
    public boolean shadow$func_201671_F(BlockPos var1);

    @Deprecated
    @Shadow
    public boolean shadow$func_217344_a(int var1, int var2, int var3, int var4, int var5, int var6);

    @Shadow
    public DimensionType shadow$func_230315_m_();

    @Shadow
    public boolean shadow$func_72953_d(AxisAlignedBB var1);

    @Shadow
    public net.minecraft.world.biome.Biome shadow$func_226691_t_(BlockPos var1);

    @Override
    default public WorldType getWorldType() {
        return (WorldType)this.shadow$func_230315_m_();
    }

    @Override
    default public WorldBorder getBorder() {
        return (WorldBorder)((ICollisionReader)this).func_175723_af();
    }

    @Override
    default public boolean isInBorder(Entity entity) {
        return ((ICollisionReader)this).func_175723_af().func_177743_a(((net.minecraft.entity.Entity)Objects.requireNonNull(entity, "entity")).func_174813_aQ());
    }

    @Override
    default public boolean canSeeSky(int x, int y, int z) {
        return ((IBlockDisplayReader)this).func_226660_f_(new BlockPos(x, y, z));
    }

    @Override
    default public boolean hasLiquid(int x, int y, int z) {
        return this.shadow$func_201671_F(new BlockPos(x, y, z));
    }

    @Override
    default public boolean containsAnyLiquids(AABB aabb) {
        Vector3d max = Objects.requireNonNull(aabb, "aabb").getMax();
        Vector3d min2 = aabb.getMin();
        return this.shadow$func_72953_d(new AxisAlignedBB(min2.getX(), min2.getY(), min2.getZ(), max.getX(), max.getY(), max.getZ()));
    }

    @Override
    default public int getSkylightSubtracted() {
        return this.shadow$func_175657_ab();
    }

    @Intrinsic
    default public int region$getSeaLevel() {
        return this.shadow$func_181545_F();
    }

    @Override
    default public boolean isAreaLoaded(int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, boolean allowEmpty) {
        return this.shadow$func_217344_a(xStart, yStart, zStart, xEnd, yEnd, zEnd);
    }

    @Override
    default public Random getRandom() {
        return new Random();
    }

    @Override
    default public Optional<Entity> getEntity(UUID uuid) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of IWorldReaderBase that isn't part of Sponge API");
    }

    @Override
    default public Collection<? extends Player> getPlayers() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of IWorldReaderBase that isn't part of Sponge API");
    }

    @Override
    default public ProtoChunk<@NonNull ?> getChunk(int x, int y, int z) {
        return (ProtoChunk)this.shadow$func_217353_a(x >> 4, z >> 4, ChunkStatus.field_223226_a_, true);
    }

    @Override
    default public boolean isChunkLoaded(int x, int y, int z, boolean allowEmpty) {
        return this.shadow$func_217354_b(x >> 4, z >> 4);
    }

    @Override
    default public boolean hasChunk(int x, int y, int z) {
        return this.shadow$func_217354_b(x >> 4, z >> 4);
    }

    @Override
    default public boolean hasChunk(Vector3i position) {
        Objects.requireNonNull(position, "position");
        return this.shadow$func_217354_b(position.getX() >> 4, position.getZ() >> 4);
    }

    @Override
    default public int getHeight(HeightType type, int x, int z) {
        return this.shadow$func_201676_a((Heightmap.Type)Objects.requireNonNull(type, "type"), x, z);
    }

    @Override
    default public Biome getBiome(int x, int y, int z) {
        return (Biome)this.shadow$func_226691_t_(new BlockPos(x, y, z));
    }

    @Override
    default public VolumeStream<R, Biome> getBiomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min2, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min2).add(1, 1, 1);
        ObjectArrayMutableBiomeBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableBiomeBuffer(min2, size) : null;
        return VolumeStreamUtils.generateStream(min2, max, options, this, (pos, biome) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBiome((BlockPos)pos, (net.minecraft.world.biome.Biome)biome);
            }
        }, VolumeStreamUtils.getChunkAccessorByStatus((IWorldReader)this, options.loadingStyle().generateArea()), (key, biome) -> key, VolumeStreamUtils.getBiomesForChunkByPos((IWorldReader)this, min2, max), (blockPos, world) -> {
            net.minecraft.world.biome.Biome biome = shouldCarbonCopy ? backingVolume.getNativeBiome(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()) : ((IWorldReader)world).func_226691_t_(blockPos);
            return new Tuple(blockPos, (Object)biome);
        });
    }

    @Override
    default public VolumeStream<R, BlockState> getBlockStateStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min2, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min2).add(1, 1, 1);
        ArrayMutableBlockBuffer backingVolume = shouldCarbonCopy ? new ArrayMutableBlockBuffer(min2, size) : null;
        return VolumeStreamUtils.generateStream(min2, max, options, this, (pos, blockState) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBlock((BlockPos)pos, (net.minecraft.block.BlockState)blockState);
            }
        }, VolumeStreamUtils.getChunkAccessorByStatus((IWorldReader)this, options.loadingStyle().generateArea()), (key, biome) -> key, VolumeStreamUtils.getBlockStatesForSections(min2, max), (blockPos, world) -> {
            net.minecraft.block.BlockState tileEntity = shouldCarbonCopy ? backingVolume.getBlock((BlockPos)blockPos) : ((IWorldReader)world).func_180495_p(blockPos);
            return new Tuple(blockPos, (Object)tileEntity);
        });
    }

    @Override
    default public VolumeStream<R, BlockEntity> getBlockEntityStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min2, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min2).add(1, 1, 1);
        ObjectArrayMutableBlockEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableBlockEntityBuffer(min2, size) : null;
        return VolumeStreamUtils.generateStream(min2, max, options, this, shouldCarbonCopy ? (pos, tile) -> {
            CompoundNBT nbt = tile.func_189515_b(new CompoundNBT());
            @Nullable TileEntity cloned = tile.func_200662_C().func_200968_a();
            net.minecraft.block.BlockState state = tile.func_195044_w();
            Objects.requireNonNull(cloned, () -> String.format("TileEntityType[%s] creates a null TileEntity!", TileEntityType.func_200969_a((TileEntityType)tile.func_200662_C()))).func_230337_a_(state, nbt);
            if (this instanceof World) {
                ((TileEntityAccessor)cloned).accessor$level((World)this);
            }
            backingVolume.addBlockEntity(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (BlockEntity)cloned);
        } : (pos, tile) -> {}, VolumeStreamUtils.getChunkAccessorByStatus((IWorldReader)this, options.loadingStyle().generateArea()), (key, tileEntity) -> key, chunk -> chunk instanceof Chunk ? ((Chunk)chunk).func_177434_r().entrySet().stream() : Stream.empty(), (blockPos, world) -> {
            @Nullable TileEntity tileEntity = shouldCarbonCopy ? backingVolume.getTileEntity((BlockPos)blockPos) : ((IWorldReader)world).func_175625_s(blockPos);
            return new Tuple(blockPos, (Object)tileEntity);
        });
    }

    @Override
    default public VolumeStream<R, Entity> getEntityStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min2, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min2).add(1, 1, 1);
        ObjectArrayMutableEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableEntityBuffer(min2, size) : null;
        return VolumeStreamUtils.generateStream(min2, max, options, this, shouldCarbonCopy ? (pos, entity) -> {
            CompoundNBT nbt = new CompoundNBT();
            entity.func_70039_c(nbt);
            net.minecraft.entity.Entity cloned = entity.func_200600_R().func_200721_a((World)((IWorldReader)this));
            Objects.requireNonNull(cloned, () -> String.format("EntityType[%s] creates a null Entity!", EntityType.func_200718_a((EntityType)entity.func_200600_R()))).func_70020_e(nbt);
            backingVolume.spawnEntity((Entity)cloned);
        } : (pos, tile) -> {}, VolumeStreamUtils.getChunkAccessorByStatus((IWorldReader)this, options.loadingStyle().generateArea()), (key, entity) -> entity.func_110124_au(), chunk -> chunk instanceof Chunk ? Arrays.stream(((Chunk)chunk).func_177429_s()).flatMap(Collection::stream).filter(entity -> VecHelper.inBounds(entity.func_233580_cy_(), min2, max)).filter(entity -> !(entity instanceof PlayerEntity)).map(entity -> new AbstractMap.SimpleEntry<BlockPos, net.minecraft.entity.Entity>(entity.func_233580_cy_(), (net.minecraft.entity.Entity)entity)) : Stream.empty(), (entityUuid, world) -> {
            net.minecraft.entity.Entity tileEntity = shouldCarbonCopy ? (net.minecraft.entity.Entity)backingVolume.getEntity((UUID)entityUuid).orElse(null) : (net.minecraft.entity.Entity)((ProtoWorld)world).getEntity((UUID)entityUuid).orElse(null);
            return new Tuple((Object)tileEntity.func_233580_cy_(), (Object)tileEntity);
        });
    }
}

