/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.command.impl;

import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.impl.TeleportCommand;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.TicketType;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.RotateEntityEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={TeleportCommand.class})
public abstract class TeleportCommandMixin {
    @Overwrite
    private static void func_201127_a(CommandSource source, Entity entityIn, net.minecraft.world.server.ServerWorld worldIn, double x, double y, double z, Set<SPlayerPositionLookPacket.Flags> relativeList, float yaw, float pitch, @Nullable TeleportCommand.Facing facing) {
        double actualX = x;
        double actualY = y;
        double actualZ = z;
        double actualYaw = yaw;
        double actualPitch = pitch;
        if (!(entityIn instanceof ServerPlayerEntity)) {
            actualYaw = MathHelper.func_76142_g((float)yaw);
            actualPitch = MathHelper.func_76142_g((float)pitch);
            actualPitch = MathHelper.func_151237_a((double)actualPitch, (double)-90.0, (double)90.0);
        }
        if (worldIn == entityIn.field_70170_p) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.COMMAND);
                if (ShouldFire.MOVE_ENTITY_EVENT) {
                    MoveEntityEvent posEvent = SpongeEventFactory.createMoveEntityEvent(frame.getCurrentCause(), (org.spongepowered.api.entity.Entity)entityIn, VecHelper.toVector3d(entityIn.func_213303_ch()), new Vector3d(x, y, z), new Vector3d(x, y, z));
                    if (SpongeCommon.postEvent(posEvent)) {
                        return;
                    }
                    actualX = posEvent.getDestinationPosition().getX();
                    actualY = posEvent.getDestinationPosition().getY();
                    actualZ = posEvent.getDestinationPosition().getZ();
                }
                if (ShouldFire.ROTATE_ENTITY_EVENT) {
                    RotateEntityEvent rotateEvent = SpongeEventFactory.createRotateEntityEvent(frame.getCurrentCause(), (org.spongepowered.api.entity.Entity)entityIn, new Vector3d(actualPitch, actualYaw, 0.0), new Vector3d(pitch, yaw, 0.0f));
                    SpongeCommon.postEvent(rotateEvent);
                    actualYaw = rotateEvent.isCancelled() ? (double)entityIn.field_70177_z : rotateEvent.getToRotation().getY();
                    double d = actualPitch = rotateEvent.isCancelled() ? (double)entityIn.field_70125_A : rotateEvent.getToRotation().getX();
                }
                if (entityIn instanceof ServerPlayerEntity) {
                    ChunkPos chunkpos = new ChunkPos(new BlockPos(actualX, actualY, actualZ));
                    worldIn.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkpos, 1, (Object)entityIn.func_145782_y());
                    entityIn.func_184210_p();
                    if (((ServerPlayerEntity)entityIn).func_70608_bn()) {
                        ((ServerPlayerEntity)entityIn).func_225652_a_(true, true);
                    }
                    ((ServerPlayerEntity)entityIn).field_71135_a.func_175089_a(actualX, actualY, actualZ, (float)actualYaw, (float)actualPitch, relativeList);
                } else {
                    entityIn.func_70012_b(actualX, actualY, actualZ, (float)actualYaw, (float)actualPitch);
                }
                entityIn.func_70034_d((float)actualYaw);
            }
        }
        if (entityIn instanceof ServerPlayerEntity) {
            PhaseTracker.getCauseStackManager().addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.COMMAND);
            ((ServerPlayerEntity)entityIn).func_200619_a(worldIn, x, y, z, yaw, pitch);
            PhaseTracker.getCauseStackManager().removeContext(EventContextKeys.MOVEMENT_TYPE);
        } else {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.COMMAND);
                net.minecraft.world.server.ServerWorld fromWorld = (net.minecraft.world.server.ServerWorld)entityIn.func_130014_f_();
                ChangeEntityWorldEvent.Pre preEvent = PlatformHooks.INSTANCE.getEventHooks().callChangeEntityWorldEventPre(entityIn, worldIn);
                if (SpongeCommon.postEvent(preEvent)) {
                    return;
                }
                ChangeEntityWorldEvent.Reposition posEvent = SpongeEventFactory.createChangeEntityWorldEventReposition(frame.getCurrentCause(), (org.spongepowered.api.entity.Entity)entityIn, (ServerWorld)entityIn.func_130014_f_(), VecHelper.toVector3d(entityIn.func_213303_ch()), new Vector3d(x, y, z), preEvent.getOriginalDestinationWorld(), new Vector3d(x, y, z), preEvent.getDestinationWorld());
                if (SpongeCommon.postEvent(posEvent)) {
                    return;
                }
                entityIn.func_213319_R();
                Entity result = entityIn.func_200600_R().func_200721_a((World)worldIn);
                if (result == null) {
                    return;
                }
                if (ShouldFire.ROTATE_ENTITY_EVENT) {
                    RotateEntityEvent rotateEvent = SpongeEventFactory.createRotateEntityEvent(frame.getCurrentCause(), (org.spongepowered.api.entity.Entity)entityIn, new Vector3d(entityIn.field_70125_A, entityIn.field_70177_z, 0.0f), new Vector3d(actualPitch, actualYaw, 0.0));
                    if (!SpongeCommon.postEvent(rotateEvent)) {
                        actualYaw = MathHelper.func_76138_g((double)rotateEvent.getToRotation().getY());
                        actualPitch = MathHelper.func_76138_g((double)rotateEvent.getToRotation().getX());
                        actualPitch = MathHelper.func_151237_a((double)actualPitch, (double)-90.0, (double)90.0);
                    } else {
                        actualYaw = entityIn.field_70177_z;
                        actualPitch = entityIn.field_70125_A;
                    }
                }
                result.func_180432_n(entityIn);
                result.func_70012_b(posEvent.getDestinationPosition().getX(), posEvent.getDestinationPosition().getY(), posEvent.getDestinationPosition().getZ(), (float)actualYaw, (float)actualPitch);
                result.func_70034_d((float)actualYaw);
                worldIn.func_217460_e(result);
                entityIn.field_70128_L = true;
                PlatformHooks.INSTANCE.getEventHooks().callChangeEntityWorldEventPost(result, fromWorld, (net.minecraft.world.server.ServerWorld)preEvent.getOriginalDestinationWorld());
            }
        }
        if (facing != null) {
            facing.func_201124_a(source, entityIn);
        }
        if (!(entityIn instanceof LivingEntity) || !((LivingEntity)entityIn).func_184613_cA()) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            entityIn.func_230245_c_(true);
        }
        if (entityIn instanceof CreatureEntity) {
            ((CreatureEntity)entityIn).func_70661_as().func_75499_g();
        }
    }
}

