/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.projectile.ThrowableEntityMixin;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.portal.PlatformTeleporter;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={EnderPearlEntity.class})
public abstract class EnderPearlEntityMixin
extends ThrowableEntityMixin {
    private double impl$damageAmount;

    @ModifyArg(method={"onHit"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;hurt(Lnet/minecraft/util/DamageSource;F)Z"))
    private float impl$onAttackEntityFromWithDamage(float damage) {
        return (float)this.impl$damageAmount;
    }

    @Override
    public void impl$readFromSpongeCompound(CompoundNBT compound) {
        super.impl$readFromSpongeCompound(compound);
        if (compound.func_74764_b("damageAmount")) {
            this.impl$damageAmount = compound.func_74769_h("damageAmount");
        }
    }

    @Override
    public void impl$writeToSpongeCompound(CompoundNBT compound) {
        super.impl$writeToSpongeCompound(compound);
        compound.func_74780_a("damageAmount", this.impl$damageAmount);
    }

    @Inject(method={"onHit"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;teleportTo(DDD)V")}, cancellable=true)
    private void impl$callMoveEntityEventForThrower(RayTraceResult result, CallbackInfo ci) {
        if (this.shadow$func_130014_f_().field_72995_K || !ShouldFire.MOVE_ENTITY_EVENT) {
            return;
        }
        Entity entity = this.shadow$func_234616_v_();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(entity);
            frame.pushCause(this);
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.ENDER_PEARL);
            MoveEntityEvent event = SpongeEventFactory.createMoveEntityEvent(frame.getCurrentCause(), (org.spongepowered.api.entity.Entity)entity, VecHelper.toVector3d(entity.func_213303_ch()), VecHelper.toVector3d(this.shadow$func_213303_ch()), VecHelper.toVector3d(this.shadow$func_213303_ch()));
            if (SpongeCommon.postEvent(event)) {
                this.shadow$func_70106_y();
                return;
            }
            Vector3d destinationPosition = event.getDestinationPosition();
            this.shadow$func_70107_b(destinationPosition.getX(), destinationPosition.getY(), destinationPosition.getZ());
        }
    }

    @Override
    @Nullable
    public Entity bridge$changeDimension(ServerWorld dimensionIn, PlatformTeleporter teleporter) {
        Entity entity = super.bridge$changeDimension(dimensionIn, teleporter);
        if (entity instanceof EnderPearlEntity) {
            this.shadow$func_212361_a(null);
        }
        return entity;
    }
}

