/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.player;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SEntityPropertiesPacket;
import net.minecraft.network.play.server.SUpdateHealthPacket;
import net.minecraft.util.FoodStats;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityHealthScaleBridge;
import org.spongepowered.common.mixin.core.entity.player.PlayerEntityMixin;

@Mixin(value={ServerPlayerEntity.class})
public abstract class ServerPlayerEntityMixin_HealthScale
extends PlayerEntityMixin
implements ServerPlayerEntityHealthScaleBridge {
    @Shadow
    private float field_71149_ch;
    @Shadow
    public ServerPlayNetHandler field_71135_a;
    private Double impl$healthScale = null;
    private float impl$cachedModifiedHealth = -1.0f;

    @Override
    public void impl$writeToSpongeCompound(CompoundNBT compound) {
        super.impl$writeToSpongeCompound(compound);
        if (this.bridge$isHealthScaled()) {
            compound.func_74780_a("HealthScale", this.impl$healthScale.doubleValue());
        }
    }

    @Override
    public void impl$readFromSpongeCompound(CompoundNBT compound) {
        super.impl$readFromSpongeCompound(compound);
        if (compound.func_150297_b("HealthScale", 6)) {
            this.impl$healthScale = compound.func_74769_h("HealthScale");
        }
    }

    @Inject(method={"doTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;getArmorValue()I", ordinal=1)})
    private void updateHealthPriorToArmor(CallbackInfo ci) {
        this.bridge$refreshScaledHealth();
    }

    @Redirect(method={"doTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;getHealth()F"))
    public float impl$onGetHealth(ServerPlayerEntity serverPlayerEntity) {
        return this.bridge$getInternalScaledHealth();
    }

    @Override
    public void bridge$setHealthScale(Double scale) {
        this.impl$healthScale = scale;
        this.impl$cachedModifiedHealth = -1.0f;
        this.field_71149_ch = -1.0f;
        if (scale == null) {
            if (this.data$hasSpongeData()) {
                this.data$getSpongeData().func_82580_o("HealthScale");
            }
        } else {
            this.data$getSpongeData().func_74780_a("HealthScale", scale.doubleValue());
        }
        this.bridge$refreshScaledHealth();
    }

    @Override
    public void bridge$refreshScaledHealth() {
        Set dirtyInstances = this.shadow$func_233645_dx_().func_233778_a_();
        this.bridge$injectScaledHealth(dirtyInstances);
        FoodStats foodData = this.shadow$func_71024_bL();
        this.field_71135_a.func_147359_a((IPacket)new SUpdateHealthPacket(this.bridge$getInternalScaledHealth(), foodData.func_75116_a(), foodData.func_75115_e()));
        this.field_71135_a.func_147359_a((IPacket)new SEntityPropertiesPacket(this.shadow$func_145782_y(), (Collection)dirtyInstances));
        dirtyInstances.clear();
    }

    @Override
    public void bridge$injectScaledHealth(Collection<ModifiableAttributeInstance> set) {
        @Nullable Set modifiers = null;
        boolean foundMax = false;
        Iterator<ModifiableAttributeInstance> iter = set.iterator();
        while (iter.hasNext()) {
            ModifiableAttributeInstance dirtyInstance = iter.next();
            if (!"attribute.name.generic.maxHealth".equals(dirtyInstance.func_111123_a().func_233754_c_())) continue;
            foundMax = true;
            modifiers = dirtyInstance.func_225505_c_();
            iter.remove();
            break;
        }
        if (!foundMax) {
            modifiers = this.shadow$func_110148_a(Attributes.field_233818_a_).func_225505_c_();
        }
        ModifiableAttributeInstance attribute = new ModifiableAttributeInstance(Attributes.field_233818_a_, i -> {});
        if (this.bridge$isHealthScaled()) {
            attribute.func_111128_a(this.impl$healthScale.doubleValue());
        }
        if (!modifiers.isEmpty()) {
            modifiers.forEach(arg_0 -> ((ModifiableAttributeInstance)attribute).func_233767_b_(arg_0));
        }
        set.add(attribute);
    }

    @Override
    public Double bridge$getHealthScale() {
        return this.impl$healthScale;
    }

    @Override
    public float bridge$getInternalScaledHealth() {
        if (!this.bridge$isHealthScaled()) {
            return this.shadow$func_110143_aJ();
        }
        if (this.impl$cachedModifiedHealth == -1.0f) {
            ModifiableAttributeInstance maxAttribute = this.shadow$func_110148_a(Attributes.field_233818_a_);
            double modifiedScale = this.impl$healthScale;
            for (AttributeModifier modifier : maxAttribute.func_225504_a_(AttributeModifier.Operation.ADDITION)) {
                modifiedScale += modifier.func_111164_d();
            }
            for (AttributeModifier modifier : maxAttribute.func_225504_a_(AttributeModifier.Operation.MULTIPLY_BASE)) {
                modifiedScale += modifiedScale * modifier.func_111164_d();
            }
            for (AttributeModifier modifier : maxAttribute.func_225504_a_(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
                modifiedScale *= 1.0 + modifier.func_111164_d();
            }
            this.impl$cachedModifiedHealth = (float)modifiedScale;
        }
        return this.shadow$func_110143_aJ() / this.shadow$func_110138_aP() * this.impl$cachedModifiedHealth;
    }

    @Override
    public boolean bridge$isHealthScaled() {
        return this.impl$healthScale != null;
    }
}

