/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network;

import com.google.common.collect.Sets;
import io.netty.channel.Channel;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeMinecraftVersion;
import org.spongepowered.common.bridge.network.NetworkManagerBridge;
import org.spongepowered.common.entity.player.ClientType;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.util.Constants;

@Mixin(value={NetworkManager.class})
public abstract class NetworkManagerMixin
extends SimpleChannelInboundHandler<IPacket<?>>
implements NetworkManagerBridge {
    @Shadow
    private INetHandler field_150744_m;
    @Shadow
    private Channel field_150746_k;
    private final TransactionStore impl$transactionStore = new TransactionStore(() -> (EngineConnection)this.field_150744_m);
    private final Set<ResourceKey> impl$registeredChannels = Sets.newConcurrentHashSet();
    @Nullable
    private InetSocketAddress impl$virtualHost;
    @Nullable
    private MinecraftVersion impl$version;
    private ClientType impl$clientType = ClientType.VANILLA;

    @Shadow
    public abstract SocketAddress func_74430_c();

    @Override
    public TransactionStore bridge$getTransactionStore() {
        return this.impl$transactionStore;
    }

    @Override
    public Set<ResourceKey> bridge$getRegisteredChannels() {
        return this.impl$registeredChannels;
    }

    @Override
    public ClientType bridge$getClientType() {
        return this.impl$clientType;
    }

    @Override
    public void bridge$setClientType(ClientType clientType) {
        this.impl$clientType = clientType;
    }

    @Override
    public InetSocketAddress bridge$getAddress() {
        SocketAddress remoteAddress = this.func_74430_c();
        if (remoteAddress instanceof LocalAddress) {
            return Constants.Networking.LOCALHOST;
        }
        return (InetSocketAddress)remoteAddress;
    }

    @Override
    public InetSocketAddress bridge$getVirtualHost() {
        if (this.impl$virtualHost != null) {
            return this.impl$virtualHost;
        }
        SocketAddress local = this.field_150746_k.localAddress();
        if (local instanceof LocalAddress) {
            return Constants.Networking.LOCALHOST;
        }
        return (InetSocketAddress)local;
    }

    @Override
    public void bridge$setVirtualHost(String host, int port) {
        try {
            this.impl$virtualHost = new InetSocketAddress(InetAddress.getByAddress(host, ((InetSocketAddress)this.field_150746_k.localAddress()).getAddress().getAddress()), port);
        }
        catch (UnknownHostException e) {
            this.impl$virtualHost = InetSocketAddress.createUnresolved(host, port);
        }
    }

    @Override
    public MinecraftVersion bridge$getVersion() {
        return this.impl$version;
    }

    @Override
    public void bridge$setVersion(int version) {
        this.impl$version = new SpongeMinecraftVersion(String.valueOf(version), version);
    }
}

