/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import com.google.inject.Injector;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectProxy;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.adventure.NativeComponentRenderer;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.command.CommandSourceProviderBridge;
import org.spongepowered.common.bridge.command.ICommandSourceBridge;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.bridge.server.management.PlayerProfileCacheBridge;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.storage.ServerWorldInfoBridge;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.datapack.SpongeDataPackManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsManager;
import org.spongepowered.common.resourcepack.SpongeResourcePack;
import org.spongepowered.common.service.server.SpongeServerScopedServiceProvider;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
implements SpongeServer,
MinecraftServerBridge,
CommandSourceProviderBridge,
SubjectProxy,
ICommandSourceBridge {
    @Shadow
    @Final
    private Map<RegistryKey<World>, net.minecraft.world.server.ServerWorld> field_71305_c;
    @Shadow
    @Final
    private PlayerProfileCache field_152366_X;
    @Shadow
    @Final
    private static Logger field_147145_h;
    @Shadow
    private int field_71315_w;
    @Shadow
    @Final
    protected SaveFormat.LevelSave field_71310_m;
    @Nullable
    private SpongeServerScopedServiceProvider impl$serviceProvider;
    @Nullable
    private ResourcePack impl$resourcePack;

    @Shadow
    public abstract CommandSource shadow$func_195573_aM();

    @Shadow
    public abstract Iterable<net.minecraft.world.server.ServerWorld> shadow$func_212370_w();

    @Shadow
    public abstract boolean shadow$func_71262_S();

    @Shadow
    public abstract boolean shadow$func_71278_l();

    @Shadow
    public abstract PlayerList shadow$func_184103_al();

    @Shadow
    public abstract ResourcePackList shadow$func_195561_aH();

    @Override
    public Subject getSubject() {
        return SpongeCommon.getGame().getSystemSubject();
    }

    @Inject(method={"spin"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static void impl$setThreadOnServerPhaseTracker(Function<Thread, MinecraftServer> p_240784_0_, CallbackInfoReturnable<MinecraftServerMixin> cir, AtomicReference<MinecraftServer> atomicReference, Thread thread) {
        try {
            PhaseTracker.SERVER.setThread(thread);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not initialize the server PhaseTracker!");
        }
    }

    @Inject(method={"setResourcePack(Ljava/lang/String;Ljava/lang/String;)V"}, at={@At(value="HEAD")})
    private void impl$createSpongeResourcePackWrapper(String url, String hash, CallbackInfo ci) {
        if (url.length() == 0) {
            this.impl$resourcePack = null;
        } else {
            try {
                this.impl$resourcePack = SpongeResourcePack.create(url, hash);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ResourcePack bridge$getResourcePack() {
        return this.impl$resourcePack;
    }

    @Inject(method={"tickServer"}, at={@At(value="HEAD")})
    private void impl$onServerTickStart(CallbackInfo ci) {
        TimingsManager.FULL_SERVER_TICK.startTiming();
    }

    @Inject(method={"tickServer"}, at={@At(value="TAIL")})
    private void impl$tickServerScheduler(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        this.getScheduler().tick();
    }

    @Override
    public CommandSource bridge$getCommandSource(Cause cause) {
        return this.shadow$func_195573_aM();
    }

    @Override
    public void bridge$addToCauseStack(CauseStackManager.StackFrame frame) {
        frame.pushCause(Sponge.getSystemSubject());
    }

    @Inject(method={"saveAllChunks"}, at={@At(value="RETURN")})
    private void impl$saveUsernameCacheOnSave(boolean suppressLog, boolean flush, boolean forced, CallbackInfoReturnable<Boolean> cir) {
        ((PlayerProfileCacheBridge)this.field_152366_X).bridge$setCanSave(true);
        this.field_152366_X.func_152658_c();
        ((PlayerProfileCacheBridge)this.field_152366_X).bridge$setCanSave(false);
    }

    @Overwrite
    public String getServerModName() {
        return "sponge";
    }

    @Inject(method={"tickServer"}, at={@At(value="RETURN")})
    private void impl$completeTickCheckAnimation(CallbackInfo ci) {
        TimingsManager.FULL_SERVER_TICK.stopTiming();
    }

    @Inject(method={"stopServer"}, at={@At(value="TAIL")})
    private void impl$closeLevelSaveForOtherWorlds(CallbackInfo ci) {
        for (Map.Entry<RegistryKey<World>, net.minecraft.world.server.ServerWorld> entry : this.field_71305_c.entrySet()) {
            if (entry.getKey() == World.field_234918_g_) continue;
            SaveFormat.LevelSave levelSave = ((ServerWorldBridge)entry.getValue()).bridge$getLevelSave();
            try {
                levelSave.close();
            }
            catch (IOException e) {
                field_147145_h.error("Failed to unlock level {}", (Object)levelSave.func_237282_a_(), (Object)e);
            }
        }
    }

    @ModifyConstant(method={"tickServer"}, constant={@Constant(intValue=6000, ordinal=0)})
    private int getSaveTickInterval(int tickInterval) {
        if (!this.shadow$func_71262_S()) {
            return tickInterval;
        }
        if (!this.shadow$func_71278_l()) {
            return this.field_71315_w + 1;
        }
        int autoPlayerSaveInterval = SpongeConfigs.getCommon().get().world.playerAutoSaveInterval;
        if (autoPlayerSaveInterval > 0 && this.field_71315_w % autoPlayerSaveInterval == 0) {
            this.shadow$func_184103_al().func_72389_g();
        }
        this.func_213211_a(true, false, false);
        return this.field_71315_w + 1;
    }

    @Overwrite
    public boolean func_213211_a(boolean suppressLog, boolean flush, boolean isForced) {
        for (net.minecraft.world.server.ServerWorld world : this.shadow$func_212370_w()) {
            boolean log;
            SerializationBehavior serializationBehavior = ((ServerWorldInfoBridge)world.func_72912_H()).bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
            boolean bl = log = !suppressLog;
            if (!isForced) {
                boolean canSaveAtAll;
                InheritableConfigHandle<WorldConfig> adapter = ((ServerWorldInfoBridge)world.func_72912_H()).bridge$configAdapter();
                int autoSaveInterval = ((WorldConfig)adapter.get()).world.autoSaveInterval;
                if (log && this.bridge$performAutosaveChecks()) {
                    log = ((WorldConfig)adapter.get()).world.logAutoSave;
                }
                if (!this.shadow$func_71278_l() || this.field_71315_w % 6000 == 0) {
                    ((ServerWorldInfoBridge)world.func_72912_H()).bridge$configAdapter().save();
                }
                if (!(canSaveAtAll = serializationBehavior != SerializationBehavior.NONE) || this.bridge$performAutosaveChecks() && (autoSaveInterval <= 0 || serializationBehavior != SerializationBehavior.AUTOMATIC || this.field_71315_w % autoSaveInterval != 0)) continue;
                world.func_217445_a(null, false, world.field_73058_d);
                if (!log) continue;
                if (this.bridge$performAutosaveChecks()) {
                    field_147145_h.info("Auto-saving data for world '{}'", (Object)((ServerWorld)world).getKey());
                    continue;
                }
                field_147145_h.info("Saving data for world '{}'", (Object)((ServerWorld)world).getKey());
                continue;
            }
            if (log) {
                field_147145_h.info("Manually saving data for world '{}'", (Object)((ServerWorld)world).getKey());
            }
            ((ServerWorldInfoBridge)world.func_72912_H()).bridge$configAdapter().save();
            world.func_217445_a(null, false, world.field_73058_d);
        }
        return true;
    }

    @Overwrite
    public void func_147139_a(Difficulty difficulty, boolean forceDifficulty) {
        for (net.minecraft.world.server.ServerWorld world : this.shadow$func_212370_w()) {
            this.bridge$setDifficulty(world, difficulty, forceDifficulty);
        }
    }

    @Override
    public void bridge$setDifficulty(net.minecraft.world.server.ServerWorld world, Difficulty newDifficulty, boolean forceDifficulty) {
        if (world.func_72912_H().func_176123_z() && !forceDifficulty) {
            return;
        }
        if (forceDifficulty) {
            if (!((ServerWorldInfoBridge)world.func_72912_H()).bridge$customDifficulty()) {
                ((ServerWorldInfoBridge)world.func_72912_H()).bridge$forceSetDifficulty(newDifficulty);
            }
        } else {
            ((ServerWorldInfo)world.func_72912_H()).func_230409_a_(newDifficulty);
        }
    }

    @Override
    public void bridge$initServices(Game game, Injector injector) {
        if (this.impl$serviceProvider == null) {
            this.impl$serviceProvider = new SpongeServerScopedServiceProvider(this, game, injector);
            this.impl$serviceProvider.init();
        }
    }

    @ModifyVariable(method={"sendMessage"}, at=@At(value="HEAD"), argsOnly=true)
    private ITextComponent impl$applyTranslation(ITextComponent input) {
        return NativeComponentRenderer.apply((ITextComponent)input.func_230532_e_(), Locale.getDefault());
    }

    @Override
    public SpongeServerScopedServiceProvider bridge$getServiceProvider() {
        return this.impl$serviceProvider;
    }

    @Inject(method={"reloadResources"}, at={@At(value="HEAD")})
    public void impl$reloadResources(Collection<String> datapacksToLoad, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        SpongeDataPackManager.INSTANCE.callRegisterDataPackValueEvents();
        try {
            SpongeDataPackManager.INSTANCE.serialize(this.field_71310_m.func_237285_a_(FolderName.field_237251_g_), datapacksToLoad);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.shadow$func_195561_aH().func_198983_a();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

