/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.dedicated;

import com.mojang.authlib.GameProfile;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.storage.PlayerData;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.service.server.permission.SpongePermissionService;

@Mixin(value={DedicatedPlayerList.class})
public abstract class DedicatedPlayerListMixin
extends PlayerList {
    public DedicatedPlayerListMixin(MinecraftServer server, DynamicRegistries.Impl registryHolder, PlayerData playerIo, int maxPlayers) {
        super(server, registryHolder, playerIo, maxPlayers);
    }

    @Inject(method={"isWhiteListed"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$checkForWhitelistBypassPermission(GameProfile profile, CallbackInfoReturnable<Boolean> ci) {
        if (!this.func_72383_n() || this.func_152599_k().func_152705_a(profile)) {
            ci.setReturnValue((Object)true);
            return;
        }
        PermissionService permissionService = Sponge.getServer().getServiceProvider().permissionService();
        Subject subject = permissionService.getUserSubjects().getSubject(profile.getId().toString()).orElse(permissionService.getDefaults());
        ci.setReturnValue((Object)subject.hasPermission("minecraft.login.bypass-whitelist"));
    }

    @Inject(method={"canBypassPlayerLimit"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$checkForPlayerLimitBypassPermission(GameProfile profile, CallbackInfoReturnable<Boolean> ci) {
        PermissionService permissionService = Sponge.getServer().getServiceProvider().permissionService();
        Subject subject = permissionService.getUserSubjects().getSubject(profile.getId().toString()).orElse(permissionService.getDefaults());
        Tristate tristate = subject.getPermissionValue(SubjectData.GLOBAL_CONTEXT, "minecraft.login.bypass-player-limit");
        if (tristate == Tristate.UNDEFINED && permissionService instanceof SpongePermissionService) {
            return;
        }
        ci.setReturnValue((Object)tristate.asBoolean());
    }
}

