/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.management;

import com.mojang.authlib.GameProfile;
import java.net.SocketAddress;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.network.play.server.SJoinGamePacket;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.CustomServerBossInfoManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.adventure.Audiences;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.living.player.RespawnPlayerEvent;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.ServerPlayerConnection;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.network.play.server.SRespawnPacketAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.scoreboard.ServerScoreboardBridge;
import org.spongepowered.common.bridge.server.management.PlayerListBridge;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.storage.ServerWorldInfoBridge;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.server.PerWorldBorderListener;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={PlayerList.class})
public abstract class PlayerListMixin
implements PlayerListBridge {
    @Shadow
    @Final
    private static Logger field_148546_d;
    @Shadow
    @Final
    private MinecraftServer field_72400_f;
    @Shadow
    private int field_72402_d;
    private boolean impl$isGameMechanicRespawn = false;
    RegistryKey<World> impl$newDestination = null;
    RegistryKey<World> impl$originalDestination = null;

    @Shadow
    public abstract ITextComponent shadow$func_206258_a(SocketAddress var1, GameProfile var2);

    @Shadow
    public abstract MinecraftServer shadow$func_72365_p();

    @Shadow
    @Nullable
    public abstract CompoundNBT shadow$func_72380_a(ServerPlayerEntity var1);

    @Override
    public void bridge$setOriginalDestinationDimension(RegistryKey<World> dimension) {
        this.impl$originalDestination = dimension;
    }

    @Override
    public void bridge$setNewDestinationDimension(RegistryKey<World> dimension) {
        this.impl$newDestination = dimension;
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;load(Lnet/minecraft/entity/player/ServerPlayerEntity;)Lnet/minecraft/nbt/CompoundNBT;"))
    private CompoundNBT impl$setPlayerDataForNewPlayers(PlayerList playerList, ServerPlayerEntity playerIn) {
        CompoundNBT compound;
        SpongeUser user = (SpongeUser)((ServerPlayerEntityBridge)playerIn).bridge$getUserObject();
        if (user != null) {
            if (SpongeUser.dirtyUsers.contains(user)) {
                user.save();
            }
            user.invalidate();
        }
        if ((compound = this.shadow$func_72380_a(playerIn)) == null) {
            ((SpongeServer)SpongeCommon.getServer()).getPlayerDataManager().setPlayerInfo(playerIn.func_110124_au(), Instant.now(), Instant.now());
        }
        return compound;
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getLevel(Lnet/minecraft/util/RegistryKey;)Lnet/minecraft/world/server/ServerWorld;"))
    private net.minecraft.world.server.ServerWorld impl$onInitPlayer_getWorld(MinecraftServer minecraftServer, RegistryKey<World> dimension, NetworkManager networkManager, ServerPlayerEntity mcPlayer) {
        ITextComponent kickReason = this.shadow$func_206258_a(networkManager.func_74430_c(), mcPlayer.func_146103_bH());
        Object disconnectMessage = kickReason != null ? SpongeAdventure.asAdventure(kickReason) : Component.text((String)"You are not allowed to log in to this server.");
        net.minecraft.world.server.ServerWorld mcWorld = minecraftServer.func_71218_a(dimension);
        if (mcWorld == null) {
            SpongeCommon.getLogger().warn("The player '{}' was located in a world that isn't loaded or doesn't exist. This is not safe so the player will be moved to the spawn of the default world.", (Object)mcPlayer.func_146103_bH().getName());
            mcWorld = minecraftServer.func_241755_D_();
            BlockPos spawnPoint = mcWorld.func_241135_u_();
            mcPlayer.func_70107_b((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o() + 0.5, (double)spawnPoint.func_177952_p() + 0.5);
        }
        mcPlayer.func_70029_a((World)mcWorld);
        ServerPlayer player = (ServerPlayer)mcPlayer;
        ServerLocation location = player.getServerLocation();
        Vector3d rotation = player.getRotation();
        ServerSideConnection connection = (ServerSideConnection)networkManager.func_150729_e();
        User user = player.getUser();
        Cause cause = Cause.of(EventContext.empty(), connection, user);
        ServerSideConnectionEvent.Login event = SpongeEventFactory.createServerSideConnectionEventLogin(cause, disconnectMessage, disconnectMessage, location, location, rotation, rotation, connection, user);
        if (kickReason != null) {
            event.setCancelled(true);
        }
        if (SpongeCommon.postEvent(event)) {
            this.impl$disconnectClient(networkManager, event.getMessage(), player.getProfile());
            return null;
        }
        ServerLocation toLocation = event.getToLocation();
        Vector3d toRotation = event.getToRotation();
        mcPlayer.func_70080_a(toLocation.getX(), toLocation.getY(), toLocation.getZ(), (float)toRotation.getY(), (float)toRotation.getX());
        return (net.minecraft.world.server.ServerWorld)toLocation.getWorld();
    }

    @Inject(method={"placeNewPlayer"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getLevel(Lnet/minecraft/util/RegistryKey;)Lnet/minecraft/world/server/ServerWorld;", shift=At.Shift.AFTER)})
    private void impl$onInitPlayer_BeforeSetWorld(NetworkManager p_72355_1_, ServerPlayerEntity p_72355_2_, CallbackInfo ci) {
        if (p_72355_2_.field_70170_p == null) {
            ci.cancel();
        }
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;info(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", remap=false))
    private void impl$onInitPlayer_printPlayerWorldInJoinFeedback(Logger logger, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, NetworkManager manager, ServerPlayerEntity entity) {
        logger.info("{}[{}] logged in to world '{}' with entity id {} at ({}, {}, {})", p0, p1, (Object)((ServerWorld)entity.func_71121_q()).getKey(), p2, p3, p4, p5);
    }

    @Redirect(method={"placeNewPlayer"}, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;invalidateStatus()V"), to=@At(value="FIELD", opcode=178, target="Lnet/minecraft/util/text/TextFormatting;YELLOW:Lnet/minecraft/util/text/TextFormatting;")), at=@At(value="INVOKE", target="Ljava/lang/String;equalsIgnoreCase(Ljava/lang/String;)Z"))
    private boolean impl$onInitPlayer_dontClassSpongeNameAsModified(String currentName, String originalName) {
        if (originalName.equals("[sponge]")) {
            return true;
        }
        return currentName.equalsIgnoreCase(originalName);
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;broadcastMessage(Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/util/text/ChatType;Ljava/util/UUID;)V"))
    private void impl$onInitPlayer_delaySendMessage(PlayerList playerList, ITextComponent message, ChatType p_232641_2_, UUID p_232641_3_, NetworkManager manager, ServerPlayerEntity playerIn) {
        ((ServerPlayerEntityBridge)playerIn).bridge$setConnectionMessageToSend(message);
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="NEW", target="net/minecraft/network/play/server/SJoinGamePacket"))
    private SJoinGamePacket impl$usePerWorldViewDistance(int p_i242082_1_, GameType p_i242082_2_, GameType p_i242082_3_, long p_i242082_4_, boolean p_i242082_6_, Set<RegistryKey<World>> p_i242082_7_, DynamicRegistries.Impl p_i242082_8_, DimensionType p_i242082_9_, RegistryKey<World> p_i242082_10_, int p_i242082_11_, int p_i242082_12_, boolean p_i242082_13_, boolean p_i242082_14_, boolean p_i242082_15_, boolean p_i242082_16_, NetworkManager p_72355_1_, ServerPlayerEntity player) {
        return new SJoinGamePacket(p_i242082_1_, p_i242082_2_, p_i242082_3_, p_i242082_4_, p_i242082_6_, p_i242082_7_, p_i242082_8_, p_i242082_9_, p_i242082_10_, p_i242082_11_, ((ServerWorldInfoBridge)player.func_71121_q().func_72912_H()).bridge$viewDistance().orElse(this.field_72402_d).intValue(), p_i242082_13_, p_i242082_14_, p_i242082_15_, p_i242082_16_);
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getCustomBossEvents()Lnet/minecraft/server/CustomServerBossInfoManager;"))
    private CustomServerBossInfoManager impl$getPerWorldBossBarManager(MinecraftServer minecraftServer, NetworkManager netManager, ServerPlayerEntity playerIn) {
        return ((ServerWorldBridge)playerIn.func_71121_q()).bridge$getBossBarManager();
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;updateEntireScoreboard(Lnet/minecraft/scoreboard/ServerScoreboard;Lnet/minecraft/entity/player/ServerPlayerEntity;)V"))
    private void impl$sendScoreboard(PlayerList playerList, ServerScoreboard scoreboardIn, ServerPlayerEntity playerIn) {
        ((ServerPlayerEntityBridge)playerIn).bridge$initScoreboard();
    }

    @Inject(method={"placeNewPlayer"}, at={@At(value="RETURN")})
    private void impl$onInitPlayer_join(NetworkManager networkManager, ServerPlayerEntity mcPlayer, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)mcPlayer;
        ServerPlayerConnection connection = player.getConnection();
        Cause cause = Cause.of(EventContext.empty(), connection, player);
        Audience audience = Audiences.onlinePlayers();
        Component joinComponent = SpongeAdventure.asAdventure(((ServerPlayerEntityBridge)mcPlayer).bridge$getConnectionMessageToSend());
        ServerSideConnectionEvent.Join event = SpongeEventFactory.createServerSideConnectionEventJoin(cause, audience, Optional.of(audience), joinComponent, joinComponent, connection, player, false);
        SpongeCommon.postEvent(event);
        if (!event.isMessageCancelled()) {
            event.getAudience().ifPresent(audience1 -> audience1.sendMessage(Identity.nil(), event.getMessage()));
        }
        ((ServerPlayerEntityBridge)mcPlayer).bridge$setConnectionMessageToSend(null);
    }

    @Redirect(method={"remove"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getCustomBossEvents()Lnet/minecraft/server/CustomServerBossInfoManager;"))
    private CustomServerBossInfoManager impl$getPerWorldBossBarManager(MinecraftServer minecraftServer, ServerPlayerEntity playerIn) {
        return ((ServerWorldBridge)playerIn.func_71121_q()).bridge$getBossBarManager();
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    private void impl$RemovePlayerReferenceFromScoreboard(ServerPlayerEntity player, CallbackInfo ci) {
        ((ServerScoreboardBridge)((Object)((ServerPlayer)player).getScoreboard())).bridge$removePlayer(player, false);
    }

    @Redirect(method={"setLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/border/WorldBorder;addListener(Lnet/minecraft/world/border/IBorderListener;)V"))
    private void impl$usePerWorldBorderListener(WorldBorder worldBorder, IBorderListener listener, net.minecraft.world.server.ServerWorld serverWorld) {
        worldBorder.func_177737_a((IBorderListener)new PerWorldBorderListener(serverWorld));
    }

    @Redirect(method={"load"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;load(Lnet/minecraft/nbt/CompoundNBT;)V"))
    private void impl$setSpongePlayerDataForSinglePlayer(ServerPlayerEntity entity, CompoundNBT compound) {
        entity.func_70020_e(compound);
        ((SpongeServer)this.shadow$func_72365_p()).getPlayerDataManager().readPlayerData(compound, entity.func_110124_au(), null);
    }

    @Redirect(method={"respawn"}, at=@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z", remap=false), slice=@Slice(from=@At(value="INVOKE", target="Ljava/util/Optional;empty()Ljava/util/Optional;", remap=false), to=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;isDemo()Z")))
    private boolean impl$flagIfRespawnLocationIsGameMechanic(Optional<?> optional) {
        this.impl$isGameMechanicRespawn = optional.isPresent();
        return this.impl$isGameMechanicRespawn;
    }

    @Redirect(method={"respawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/play/ServerPlayNetHandler;send(Lnet/minecraft/network/IPacket;)V", ordinal=1))
    private void impl$callRespawnPlayerRecreateEvent(ServerPlayNetHandler serverPlayNetHandler, IPacket<?> packetIn, ServerPlayerEntity originalPlayer, boolean keepAllPlayerData) {
        ServerPlayerEntity recreatedPlayer = serverPlayNetHandler.field_147369_b;
        Vector3d originalPosition = VecHelper.toVector3d(originalPlayer.func_213303_ch());
        Vector3d destinationPosition = VecHelper.toVector3d(recreatedPlayer.func_213303_ch());
        ServerWorld originalWorld = (ServerWorld)originalPlayer.field_70170_p;
        ServerWorld originalDestinationWorld = (ServerWorld)this.field_72400_f.func_71218_a(this.impl$originalDestination == null ? World.field_234918_g_ : this.impl$originalDestination);
        ServerWorld destinationWorld = (ServerWorld)this.field_72400_f.func_71218_a(this.impl$newDestination == null ? World.field_234918_g_ : this.impl$newDestination);
        RespawnPlayerEvent.Recreate event = SpongeEventFactory.createRespawnPlayerEventRecreate(PhaseTracker.getCauseStackManager().getCurrentCause(), destinationPosition, originalWorld, originalPosition, destinationWorld, originalDestinationWorld, destinationPosition, (ServerPlayer)originalPlayer, (ServerPlayer)recreatedPlayer, this.impl$isGameMechanicRespawn, !keepAllPlayerData);
        SpongeCommon.postEvent(event);
        recreatedPlayer.func_70107_b(event.getDestinationPosition().getX(), event.getDestinationPosition().getY(), event.getDestinationPosition().getZ());
        this.impl$isGameMechanicRespawn = false;
        this.impl$originalDestination = null;
        this.impl$newDestination = null;
        net.minecraft.world.server.ServerWorld targetWorld = (net.minecraft.world.server.ServerWorld)event.getDestinationWorld();
        ((ServerPlayerEntityBridge)recreatedPlayer).bridge$sendChangeDimension(targetWorld.func_230315_m_(), ((SRespawnPacketAccessor)packetIn).accessor$dimension(), ((SRespawnPacketAccessor)packetIn).accessor$seed(), recreatedPlayer.field_71134_c.func_73081_b(), recreatedPlayer.field_71134_c.func_241815_c_(), targetWorld.func_234925_Z_(), targetWorld.func_241109_A_(), keepAllPlayerData);
    }

    @Redirect(method={"sendLevelInfo"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;overworld()Lnet/minecraft/world/server/ServerWorld;"))
    private net.minecraft.world.server.ServerWorld impl$usePerWorldWorldBorder(MinecraftServer minecraftServer, ServerPlayerEntity playerIn, net.minecraft.world.server.ServerWorld worldIn) {
        return worldIn;
    }

    private void impl$disconnectClient(NetworkManager netManager, Component disconnectMessage, @Nullable org.spongepowered.api.profile.GameProfile profile) {
        ITextComponent reason = SpongeAdventure.asVanilla(disconnectMessage);
        try {
            field_148546_d.info("Disconnecting " + (profile != null ? profile.toString() + " (" + netManager.func_74430_c().toString() + ")" : netManager.func_74430_c() + ": " + reason.getString()));
            netManager.func_179290_a((IPacket)new SDisconnectPacket(reason));
            netManager.func_150718_a(reason);
        }
        catch (Exception exception) {
            field_148546_d.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    @Inject(method={"saveAll()V"}, at={@At(value="RETURN")})
    private void impl$saveOrInvalidateUserDuringSaveAll(CallbackInfo ci) {
        for (SpongeUser user : SpongeUser.initializedUsers) {
            if (SpongeUser.dirtyUsers.contains(user)) {
                user.save();
                continue;
            }
            user.invalidate();
        }
    }

    @Inject(method={"remove"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;save(Lnet/minecraft/entity/player/ServerPlayerEntity;)V")})
    private void impl$invalidateUserOnSave(ServerPlayerEntity player, CallbackInfo ci) {
        User user = ((ServerPlayerEntityBridge)player).bridge$getUser();
        SpongeUser.dirtyUsers.remove(user);
        ((SpongeUser)user).invalidate();
    }
}

