/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.entity;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.entity.ChangeEntityEquipmentEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.bridge.entity.player.PlayerInventoryBridge;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.comp.HotbarLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.inventory.lens.impl.slot.BasicSlotLens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin_Inventory {
    private final EnumMap<EquipmentSlotType, SlotLens> impl$slotLens = new EnumMap(EquipmentSlotType.class);

    @Shadow
    public abstract void shadow$func_184201_a(EquipmentSlotType var1, ItemStack var2);

    @Shadow
    protected abstract ItemStack shadow$func_241347_e_(EquipmentSlotType var1);

    @Shadow
    protected abstract ItemStack shadow$func_241346_d_(EquipmentSlotType var1);

    @Inject(method={"handleHandSwap"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerChunkProvider;broadcast(Lnet/minecraft/entity/Entity;Lnet/minecraft/network/IPacket;)V")})
    private void inventory$onHandleHandSwap(Map<EquipmentSlotType, ItemStack> map, CallbackInfo ci) {
        if (this instanceof ServerPlayer) {
            return;
        }
        SlotAdapter mainHand = this.impl$getSpongeSlot(EquipmentSlotType.MAINHAND);
        boolean customMainHand = this.impl$throwEquipmentEvent(EquipmentSlotType.MAINHAND, mainHand, map.get(EquipmentSlotType.MAINHAND), this.shadow$func_241347_e_(EquipmentSlotType.MAINHAND));
        SlotAdapter offHand = this.impl$getSpongeSlot(EquipmentSlotType.OFFHAND);
        boolean customOffHand = this.impl$throwEquipmentEvent(EquipmentSlotType.OFFHAND, offHand, map.get(EquipmentSlotType.OFFHAND), this.shadow$func_241347_e_(EquipmentSlotType.OFFHAND));
        if (customMainHand || customOffHand) {
            ci.cancel();
        }
    }

    @Inject(method={"handleEquipmentChanges"}, at={@At(value="INVOKE", target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V")})
    private void inventory$onHandleEquipmentChanges(Map<EquipmentSlotType, ItemStack> map, CallbackInfo ci) {
        if (this instanceof PlayerEntity && ((Entity)this).field_70173_aa == 1) {
            return;
        }
        map.entrySet().removeIf(entry -> {
            SlotAdapter slotAdapter = this.impl$getSpongeSlot((EquipmentSlotType)entry.getKey());
            ItemStack oldStack = null;
            switch (((EquipmentSlotType)entry.getKey()).func_188453_a()) {
                case HAND: {
                    oldStack = this.shadow$func_241347_e_((EquipmentSlotType)entry.getKey());
                    break;
                }
                case ARMOR: {
                    oldStack = this.shadow$func_241346_d_((EquipmentSlotType)entry.getKey());
                }
            }
            return this.impl$throwEquipmentEvent((EquipmentSlotType)entry.getKey(), slotAdapter, (ItemStack)entry.getValue(), oldStack);
        });
    }

    private boolean impl$throwEquipmentEvent(EquipmentSlotType equipmentslottype, SlotAdapter slot, ItemStack newStack, ItemStack oldStack) {
        ChangeEntityEquipmentEvent event = InventoryEventFactory.callChangeEntityEquipmentEvent((LivingEntity)this, ItemStackUtil.snapshotOf(oldStack), ItemStackUtil.snapshotOf(newStack), slot);
        if (event.isCancelled()) {
            this.shadow$func_184201_a(equipmentslottype, oldStack);
            return true;
        }
        Transaction<ItemStackSnapshot> transaction = event.getTransaction();
        if (!transaction.isValid()) {
            this.shadow$func_184201_a(equipmentslottype, oldStack);
            return true;
        }
        Optional<ItemStackSnapshot> optional = transaction.getCustom();
        if (optional.isPresent()) {
            ItemStack custom = ItemStackUtil.fromSnapshotToNative(optional.get());
            this.shadow$func_184201_a(equipmentslottype, custom);
            return true;
        }
        return false;
    }

    private SlotAdapter impl$getSpongeSlot(EquipmentSlotType equipmentslottype) {
        Slot slotAdapter;
        if (this instanceof ServerPlayerEntity) {
            SlotLens slotLens;
            PlayerInventoryBridge inventory = (PlayerInventoryBridge)((ServerPlayerEntity)this).field_71071_by;
            Lens inventoryLens = ((InventoryAdapter)((Object)inventory)).inventoryAdapter$getRootLens();
            Fabric fabric = ((InventoryAdapter)((Object)inventory)).inventoryAdapter$getFabric();
            if (inventoryLens instanceof PlayerInventoryLens) {
                switch (equipmentslottype) {
                    case OFFHAND: {
                        slotLens = ((PlayerInventoryLens)inventoryLens).getOffhandLens();
                        break;
                    }
                    case MAINHAND: {
                        HotbarLens hotbarLens = ((PlayerInventoryLens)inventoryLens).getPrimaryInventoryLens().getHotbar();
                        slotLens = hotbarLens.getSlotLens(fabric, hotbarLens.getSelectedSlotIndex(fabric));
                        break;
                    }
                    default: {
                        slotLens = ((PlayerInventoryLens)inventoryLens).getEquipmentLens().getSlotLens(fabric, equipmentslottype.func_188454_b());
                        break;
                    }
                }
            } else {
                slotLens = inventoryLens.getSlotLens(fabric, equipmentslottype.func_188454_b());
            }
            slotAdapter = slotLens.getAdapter(fabric, (Inventory)((Object)inventory));
        } else {
            if (this.impl$slotLens.isEmpty()) {
                for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                    this.impl$slotLens.put(slot, new BasicSlotLens(slot.func_188454_b()));
                }
            }
            slotAdapter = this.impl$slotLens.get(equipmentslottype).getAdapter((Fabric)((Object)this), null);
        }
        return (SlotAdapter)slotAdapter;
    }
}

