/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.inventory.container;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.NonNullList;
import org.spongepowered.api.event.item.inventory.CraftItemEvent;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.entity.player.PlayerEntityBridge;
import org.spongepowered.common.bridge.inventory.ViewableInventoryBridge;
import org.spongepowered.common.bridge.inventory.container.MenuBridge;
import org.spongepowered.common.bridge.inventory.container.PlayerContainerBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedContainerBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.custom.SpongeInventoryMenu;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={net.minecraft.inventory.container.Container.class})
public abstract class ContainerMixin_Inventory
implements TrackedContainerBridge,
InventoryAdapter,
TrackedInventoryBridge {
    private boolean impl$shiftCraft = false;
    @Nullable
    private CraftItemEvent.Craft impl$lastCraft = null;
    @Nullable
    private ItemStack impl$previousCursor;
    private boolean impl$firePreview = true;
    private List<SlotTransaction> impl$capturedCraftPreviewTransactions = new ArrayList<SlotTransaction>();
    private boolean impl$captureSuccess = false;
    @Nullable
    private Object impl$viewed;
    private boolean impl$dropCancelled = false;
    private ItemStackSnapshot impl$itemStackSnapshot = ItemStackSnapshot.empty();
    @Nullable
    private net.minecraft.inventory.container.Slot impl$lastSlotUsed = null;
    @Final
    @Shadow
    private NonNullList<ItemStack> field_75153_a;
    @Final
    @Shadow
    public List<net.minecraft.inventory.container.Slot> field_75151_b;
    @Final
    @Shadow
    private List<IContainerListener> field_75149_d;
    @Final
    @Shadow
    private List<IntReferenceHolder> field_216964_d;

    @Override
    public void bridge$setShiftCrafting(boolean flag) {
        this.impl$shiftCraft = flag;
    }

    @Override
    public boolean bridge$isShiftCrafting() {
        return this.impl$shiftCraft;
    }

    @Override
    public void bridge$setLastCraft(CraftItemEvent.Craft event) {
        this.impl$lastCraft = event;
    }

    @Override
    @Nullable
    public CraftItemEvent.Craft bridge$getLastCraft() {
        return this.impl$lastCraft;
    }

    @Override
    public void bridge$setPreviousCursor(@Nullable ItemStack stack) {
        this.impl$previousCursor = stack;
    }

    @Override
    public ItemStack bridge$getPreviousCursor() {
        return this.impl$previousCursor;
    }

    @Override
    public void bridge$setFirePreview(boolean firePreview) {
        this.impl$firePreview = firePreview;
    }

    @Override
    public boolean bridge$firePreview() {
        return this.impl$firePreview;
    }

    @Override
    public List<SlotTransaction> bridge$getPreviewTransactions() {
        return this.impl$capturedCraftPreviewTransactions;
    }

    @Override
    public boolean bridge$capturePossible() {
        return this.impl$captureSuccess;
    }

    @Override
    public void bridge$setCapturePossible() {
        this.impl$captureSuccess = true;
    }

    @Override
    public void bridge$trackViewable(Object inventory) {
        if (inventory instanceof Carrier) {
            inventory = ((Carrier)((Object)inventory)).getInventory();
        }
        if (inventory instanceof Inventory) {
            ((Inventory)inventory).asViewable().ifPresent(i -> ((ViewableInventoryBridge)((Object)i)).viewableBridge$addContainer((net.minecraft.inventory.container.Container)this));
        }
        this.impl$setViewed(inventory);
    }

    private void impl$setViewed(@Nullable Object viewed) {
        if (viewed == null) {
            this.impl$unTrackViewable(this.impl$viewed);
        }
        this.impl$viewed = viewed;
    }

    private void impl$unTrackViewable(@Nullable Object inventory) {
        if (inventory instanceof Carrier) {
            inventory = ((Carrier)((Object)inventory)).getInventory();
        }
        if (inventory instanceof Inventory) {
            ((Inventory)inventory).asViewable().ifPresent(i -> ((ViewableInventoryBridge)((Object)i)).viewableBridge$removeContainer((net.minecraft.inventory.container.Container)this));
        }
    }

    @Shadow
    public abstract net.minecraft.inventory.container.Slot shadow$func_75139_a(int var1);

    @Inject(method={"setItem"}, at={@At(value="HEAD")})
    private void impl$addTransaction(int slotId, ItemStack itemstack, CallbackInfo ci) {
        net.minecraft.inventory.container.Slot slot;
        if (this.bridge$capturingInventory() && (slot = this.shadow$func_75139_a(slotId)) != null) {
            ItemStackSnapshot originalItem = ItemStackUtil.snapshotOf(slot.func_75211_c());
            ItemStackSnapshot newItem = ItemStackUtil.snapshotOf(itemstack);
            Slot adapter = this.inventoryAdapter$getSlot(slotId).get();
            this.bridge$getCapturedSlotTransactions().add(new SlotTransaction(adapter, originalItem, newItem));
        }
    }

    @Inject(method={"removed"}, at={@At(value="HEAD")})
    private void onOnContainerClosed(PlayerEntity player, CallbackInfo ci) {
        this.impl$setViewed(null);
    }

    @Nullable
    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;drop(Lnet/minecraft/item/ItemStack;Z)Lnet/minecraft/entity/item/ItemEntity;", ordinal=0))
    private ItemEntity impl$RestoreOnDragDrop(PlayerEntity player, ItemStack itemStackIn, boolean unused) {
        ItemStackSnapshot original = ItemStackUtil.snapshotOf(itemStackIn);
        ItemEntity entityItem = player.func_71019_a(itemStackIn, unused);
        if (!((PlayerEntityBridge)player).bridge$shouldRestoreInventory()) {
            return entityItem;
        }
        if (entityItem == null) {
            this.impl$dropCancelled = true;
            PacketPhaseUtil.handleCustomCursor(player, original);
        }
        return entityItem;
    }

    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;setCarried(Lnet/minecraft/item/ItemStack;)V", ordinal=1))
    private void impl$ClearOnSlot(PlayerInventory inventoryPlayer, ItemStack itemStackIn) {
        if (!this.impl$dropCancelled || !((PlayerEntityBridge)inventoryPlayer.field_70458_d).bridge$shouldRestoreInventory()) {
            inventoryPlayer.func_70437_b(itemStackIn);
        }
        ((PlayerEntityBridge)inventoryPlayer.field_70458_d).bridge$shouldRestoreInventory(false);
        this.impl$dropCancelled = false;
    }

    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;drop(Lnet/minecraft/item/ItemStack;Z)Lnet/minecraft/entity/item/ItemEntity;", ordinal=1))
    @Nullable
    private ItemEntity impl$restoreOnDragSplit(PlayerEntity player, ItemStack itemStackIn, boolean unused) {
        ItemEntity entityItem = player.func_71019_a(itemStackIn, unused);
        if (!((PlayerEntityBridge)player).bridge$shouldRestoreInventory()) {
            return entityItem;
        }
        if (entityItem == null) {
            ItemStack original;
            if (player.field_71071_by.func_70445_o().func_190926_b()) {
                original = itemStackIn;
            } else {
                player.field_71071_by.func_70445_o().func_190917_f(1);
                original = player.field_71071_by.func_70445_o();
            }
            player.field_71071_by.func_70437_b(original);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, original));
        }
        ((PlayerEntityBridge)player).bridge$shouldRestoreInventory(false);
        return entityItem;
    }

    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/container/Slot;mayPickup(Lnet/minecraft/entity/player/PlayerEntity;)Z", ordinal=4))
    public boolean onCanTakeStack(net.minecraft.inventory.container.Slot slot, PlayerEntity playerIn) {
        boolean result = slot.func_82869_a(playerIn);
        if (result) {
            this.impl$itemStackSnapshot = ItemStackUtil.snapshotOf(slot.func_75211_c());
            this.impl$lastSlotUsed = slot;
        } else {
            this.impl$itemStackSnapshot = ItemStackSnapshot.empty();
            this.impl$lastSlotUsed = null;
        }
        return result;
    }

    @Nullable
    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;drop(Lnet/minecraft/item/ItemStack;Z)Lnet/minecraft/entity/item/ItemEntity;", ordinal=3))
    private ItemEntity onThrowClick(PlayerEntity player, ItemStack itemStackIn, boolean unused) {
        ItemEntity entityItem = player.func_71019_a(itemStackIn, true);
        if (entityItem == null && ((PlayerEntityBridge)player).bridge$shouldRestoreInventory()) {
            ItemStack original = ItemStackUtil.fromSnapshotToNative(this.impl$itemStackSnapshot);
            this.impl$lastSlotUsed.func_75215_d(original);
            player.field_71070_bA.func_75142_b();
            ((ServerPlayerEntity)player).field_71137_h = false;
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(player.field_71070_bA.field_75152_c, this.impl$lastSlotUsed.field_75222_d, original));
        }
        this.impl$itemStackSnapshot = ItemStackSnapshot.empty();
        this.impl$lastSlotUsed = null;
        ((PlayerEntityBridge)player).bridge$shouldRestoreInventory(false);
        return entityItem;
    }

    @Inject(method={"doClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;grow(I)V", ordinal=1)})
    private void beforeOnTakeClickWithItem(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player, CallbackInfoReturnable<Integer> cir) {
        this.bridge$setPreviousCursor(player.field_71071_by.func_70445_o().func_77946_l());
    }

    @Inject(method={"doClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;setCarried(Lnet/minecraft/item/ItemStack;)V", ordinal=3)})
    private void beforeOnTakeClick(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player, CallbackInfoReturnable<Integer> cir) {
        this.bridge$setPreviousCursor(player.field_71071_by.func_70445_o().func_77946_l());
    }

    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/container/Slot;onTake(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;", ordinal=5))
    private ItemStack redirectOnTakeThrow(net.minecraft.inventory.container.Slot slot, PlayerEntity player, ItemStack stackToDrop) {
        this.bridge$setLastCraft(null);
        ItemStack result = slot.func_190901_a(player, stackToDrop);
        CraftItemEvent.Craft lastCraft = this.bridge$getLastCraft();
        if (lastCraft != null && slot instanceof CraftingResultSlot && lastCraft.isCancelled()) {
            stackToDrop.func_190920_e(0);
        }
        return result;
    }

    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/container/Container;quickMoveStack(Lnet/minecraft/entity/player/PlayerEntity;I)Lnet/minecraft/item/ItemStack;"))
    private ItemStack redirectTransferStackInSlot(net.minecraft.inventory.container.Container thisContainer, PlayerEntity player, int slotId) {
        net.minecraft.inventory.container.Slot slot = thisContainer.func_75139_a(slotId);
        if (!(slot instanceof CraftingResultSlot)) {
            return thisContainer.func_82846_b(player, slotId);
        }
        this.bridge$setLastCraft(null);
        this.bridge$setShiftCrafting(true);
        ItemStack result = thisContainer.func_82846_b(player, slotId);
        CraftItemEvent.Craft lastCraft = this.bridge$getLastCraft();
        if (lastCraft != null && lastCraft.isCancelled()) {
            result = ItemStack.field_190927_a;
        }
        this.bridge$setShiftCrafting(false);
        return result;
    }

    @Inject(method={"doClick"}, at={@At(value="RETURN")})
    private void onReturn(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player, CallbackInfoReturnable<ItemStack> cir) {
        this.bridge$setLastCraft(null);
        this.bridge$setPreviousCursor(null);
        if (this instanceof WorkbenchContainer || this instanceof PlayerContainer) {
            for (IContainerListener listener : this.field_75149_d) {
                if (slotId == 0) {
                    listener.func_71110_a((net.minecraft.inventory.container.Container)this, this.shadow$func_75138_a());
                    continue;
                }
                listener.func_71111_a((net.minecraft.inventory.container.Container)this, 0, (ItemStack)this.shadow$func_75138_a().get(0));
            }
        }
    }

    @Overwrite
    public void func_75142_b() {
        this.bridge$detectAndSendChanges(false);
        this.bridge$setCapturePossible();
    }

    @Shadow
    public abstract NonNullList<ItemStack> shadow$func_75138_a();

    @Override
    public void bridge$detectAndSendChanges(boolean captureOnly) {
        net.minecraft.inventory.container.Slot slot;
        ItemStack oldStack;
        SpongeInventoryMenu menu = ((MenuBridge)((Object)this)).bridge$getMenu();
        boolean readOnlyCancel = false;
        ArrayList<Integer> changes = new ArrayList<Integer>();
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            net.minecraft.inventory.container.Slot slot2 = this.field_75151_b.get(i);
            ItemStack newStack = slot2.func_75211_c();
            oldStack = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)newStack)) continue;
            changes.add(i);
            if (menu == null || !menu.isReadOnly() || slot2.field_75224_c != menu.getInventory()) continue;
            readOnlyCancel = true;
        }
        if (readOnlyCancel) {
            for (Integer i : changes) {
                slot = this.field_75151_b.get(i);
                oldStack = (ItemStack)this.field_75153_a.get(i.intValue());
                slot.func_75215_d(oldStack.func_77946_l());
                this.impl$sendSlotContents(i, oldStack);
                for (IContainerListener listener : this.field_75149_d) {
                    if (!(listener instanceof ServerPlayerEntity)) continue;
                    ((ServerPlayerEntity)listener).field_71071_by.func_70437_b(menu.getOldCursor());
                    ((ServerPlayerEntity)listener).func_71113_k();
                }
            }
        } else {
            for (Integer i : changes) {
                slot = this.field_75151_b.get(i);
                ItemStack newStack = slot.func_75211_c();
                ItemStack oldStack2 = (ItemStack)this.field_75153_a.get(i.intValue());
                if (menu != null && !menu.onChange(newStack, oldStack2, (Container)((Object)this), i, slot)) {
                    this.field_75153_a.set(i.intValue(), (Object)oldStack2.func_77946_l());
                    this.impl$sendSlotContents(i, oldStack2);
                    continue;
                }
                this.impl$capture(i, newStack, oldStack2);
                if (captureOnly) continue;
                oldStack2 = newStack.func_190926_b() ? ItemStack.field_190927_a : newStack.func_77946_l();
                this.field_75153_a.set(i.intValue(), (Object)oldStack2);
                for (IContainerListener listener : this.field_75149_d) {
                    listener.func_71111_a((net.minecraft.inventory.container.Container)this, i.intValue(), oldStack2);
                }
            }
        }
        if (menu != null) {
            menu.setOldCursor(null);
        }
        this.impl$detectAndSendPropertyChanges();
        if (this instanceof PlayerContainerBridge) {
            ((PlayerContainerBridge)((Object)this)).bridge$markClean();
        }
    }

    public void impl$sendSlotContents(Integer i, ItemStack oldStack) {
        for (IContainerListener listener : this.field_75149_d) {
            boolean isChangingQuantityOnly = true;
            if (listener instanceof ServerPlayerEntity) {
                isChangingQuantityOnly = ((ServerPlayerEntity)listener).field_71137_h;
                ((ServerPlayerEntity)listener).field_71137_h = false;
            }
            listener.func_71111_a((net.minecraft.inventory.container.Container)this, i.intValue(), oldStack);
            if (!(listener instanceof ServerPlayerEntity)) continue;
            ((ServerPlayerEntity)listener).field_71137_h = isChangingQuantityOnly;
        }
    }

    private void impl$detectAndSendPropertyChanges() {
        for (int j = 0; j < this.field_216964_d.size(); ++j) {
            IntReferenceHolder intreferenceholder = this.field_216964_d.get(j);
            if (!intreferenceholder.func_221496_c()) continue;
            for (IContainerListener icontainerlistener1 : this.field_75149_d) {
                icontainerlistener1.func_71112_a((net.minecraft.inventory.container.Container)this, j, intreferenceholder.func_221495_b());
            }
        }
    }

    private void impl$capture(Integer index, ItemStack itemstack, ItemStack itemstack1) {
        if (this.bridge$capturingInventory()) {
            ItemStackSnapshot originalItem = ItemStackUtil.snapshotOf(itemstack1);
            ItemStackSnapshot newItem = ItemStackUtil.snapshotOf(itemstack);
            try {
                Slot adapter = this.inventoryAdapter$getSlot(index).get();
                SlotTransaction newTransaction = new SlotTransaction(adapter, originalItem, newItem);
                List<SlotTransaction> previewTransactions = this.bridge$getPreviewTransactions();
                if (this.bridge$isShiftCrafting()) {
                    previewTransactions.add(newTransaction);
                } else {
                    SlotTransaction previewTransaction;
                    if (!previewTransactions.isEmpty() && (previewTransaction = previewTransactions.get(0)).equals(newTransaction)) {
                        newTransaction = null;
                    }
                    if (newTransaction != null) {
                        this.bridge$getCapturedSlotTransactions().add(newTransaction);
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                SpongeCommon.getLogger().error("SlotIndex out of LensBounds! Did the Container change after creation?", (Throwable)e);
            }
        }
    }
}

