/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.inventory.container;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.item.inventory.CraftItemEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.query.QueryTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.inventory.container.TrackedContainerBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={CraftingResultSlot.class})
public abstract class CraftingResultSlotMixin_Inventory
extends Slot {
    @Shadow
    @Final
    private PlayerEntity field_75238_b;
    @Shadow
    private int field_75237_g;
    @Shadow
    @Final
    private net.minecraft.inventory.CraftingInventory field_75239_a;
    @Nullable
    private CraftingRecipe impl$lastRecipe;
    @Nullable
    private ItemStack impl$craftedStack;
    private int impl$craftedStackQuantity;

    public CraftingResultSlotMixin_Inventory(IInventory inventoryIn, int index, int xPosition, int yPosition) {
        super(inventoryIn, index, xPosition, yPosition);
    }

    public void func_75215_d(@Nullable ItemStack stack) {
        super.func_75215_d(stack);
        if (this.field_75238_b instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)this.field_75238_b).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(0, 0, stack));
        }
    }

    @Inject(method={"checkTakeAchievements"}, at={@At(value="HEAD")})
    private void onCraftingHead(ItemStack itemStack, CallbackInfo ci) {
        this.impl$craftedStackQuantity = this.field_75237_g;
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")})
    private void beforeTake(PlayerEntity thePlayer, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        if (this.impl$lastRecipe == null || !((IRecipe)this.impl$lastRecipe).func_77569_a((IInventory)this.field_75239_a, thePlayer.field_70170_p)) {
            this.impl$lastRecipe = thePlayer.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.field_75239_a, thePlayer.field_70170_p).orElse(null);
        }
        if (((TrackedContainerBridge)thePlayer.field_71070_bA).bridge$isShiftCrafting()) {
            ((TrackedContainerBridge)thePlayer.field_71070_bA).bridge$detectAndSendChanges(true);
            ((TrackedContainerBridge)thePlayer.field_71070_bA).bridge$setShiftCrafting(false);
        }
        ((TrackedContainerBridge)thePlayer.field_71070_bA).bridge$setFirePreview(false);
        stack.func_190917_f(1);
        this.impl$craftedStack = stack.func_77946_l();
        if (this.field_75237_g != 0) {
            this.impl$craftedStackQuantity = this.field_75237_g;
        }
        this.impl$craftedStack.func_190920_e(this.impl$craftedStackQuantity);
        stack.func_190918_g(1);
    }

    @Redirect(method={"onTake"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/crafting/RecipeManager;getRemainingItemsFor(Lnet/minecraft/item/crafting/IRecipeType;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/world/World;)Lnet/minecraft/util/NonNullList;"))
    private <C extends IInventory, T extends IRecipe<C>> NonNullList<ItemStack> onGetRemainingItems(RecipeManager recipeManager, IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn) {
        if (this.impl$lastRecipe == null) {
            return NonNullList.func_191197_a((int)inventoryIn.func_70302_i_(), (Object)ItemStack.field_190927_a);
        }
        return worldIn.func_199532_z().func_215369_c(recipeTypeIn, inventoryIn, worldIn);
    }

    @Inject(method={"onTake"}, cancellable=true, at={@At(value="RETURN")})
    private void afterTake(PlayerEntity thePlayer, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        SlotTransaction last;
        ItemStackSnapshot craftedItem;
        if (((WorldBridge)thePlayer.field_70170_p).bridge$isFake()) {
            return;
        }
        ((TrackedContainerBridge)thePlayer.field_71070_bA).bridge$detectAndSendChanges(true);
        ((TrackedInventoryBridge)thePlayer.field_71070_bA).bridge$setCaptureInventory(false);
        Container container = thePlayer.field_71070_bA;
        Inventory craftInv = ((Inventory)container).query(QueryTypes.INVENTORY_TYPE.get().of(CraftingInventory.class));
        if (!(craftInv instanceof CraftingInventory)) {
            SpongeCommon.getLogger().warn("Detected crafting without a InventoryCrafting!? Crafting Event will not fire.");
            return;
        }
        Transaction first = null;
        List<SlotTransaction> capturedTransactions = ((TrackedInventoryBridge)container).bridge$getCapturedSlotTransactions();
        Iterator<SlotTransaction> iterator = capturedTransactions.iterator();
        while (iterator.hasNext()) {
            SlotTransaction trans = iterator.next();
            Optional<Integer> slotIndex = trans.getSlot().get(Keys.SLOT_INDEX);
            if (!slotIndex.isPresent() || slotIndex.get() != 0) continue;
            iterator.remove();
            if (first != null) continue;
            first = trans;
        }
        if (first != null) {
            capturedTransactions.add((SlotTransaction)first);
            craftedItem = (ItemStackSnapshot)((ItemStackSnapshot)first.getOriginal()).copy();
        } else {
            craftedItem = ItemStackUtil.snapshotOf(this.impl$craftedStack);
        }
        CraftingInventory craftingInventory = (CraftingInventory)craftInv;
        CraftItemEvent.Craft event = InventoryEventFactory.callCraftEventPost(thePlayer, craftingInventory, craftedItem, this.impl$lastRecipe, container, capturedTransactions);
        ((TrackedContainerBridge)container).bridge$setLastCraft(event);
        ((TrackedContainerBridge)container).bridge$setFirePreview(true);
        this.impl$craftedStack = null;
        ((TrackedInventoryBridge)thePlayer.field_71070_bA).bridge$setCaptureInventory(true);
        List<SlotTransaction> previewTransactions = ((TrackedContainerBridge)container).bridge$getPreviewTransactions();
        if (this.field_75239_a.func_191420_l()) {
            return;
        }
        if (previewTransactions.isEmpty()) {
            last = new SlotTransaction(craftingInventory.getResult(), ItemStackSnapshot.empty(), ItemStackUtil.snapshotOf(this.func_75211_c()));
            previewTransactions.add(last);
        } else {
            last = previewTransactions.get(0);
        }
        Optional newRecipe = thePlayer.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.field_75239_a, thePlayer.field_70170_p);
        InventoryEventFactory.callCraftEventPre(thePlayer, craftingInventory, last, newRecipe.orElse(null), container, previewTransactions);
        previewTransactions.clear();
    }
}

