/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.mcp.entity;

import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;

@Mixin(value={Entity.class}, priority=1500)
public abstract class EntityMixin_Optimization_Collision {
    @Inject(method={"checkInsideBlocks"}, at={@At(value="HEAD")}, cancellable=true)
    private void activeCollision$checkForNeighboringChunkIfAvailable(CallbackInfo ci) {
        ChunkBridge activeChunk = ((ActiveChunkReferantBridge)((Object)this)).bridge$getActiveChunk();
        if (activeChunk == null || !activeChunk.bridge$areNeighborsLoaded() || activeChunk.bridge$isQueuedForUnload()) {
            ci.cancel();
        }
    }

    @Redirect(method={"checkInsideBlocks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;hasChunksAt(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean activeCollision$ignoreWorldIsAreaLoaded(World world, BlockPos from, BlockPos to) {
        return true;
    }

    @Inject(method={"updateFluidHeightAndDoFluidPushing"}, at={@At(value="HEAD")}, cancellable=true)
    private void activeCollision$BailIfNeighborsAreInactive(ITag<Fluid> p_210500_1_, double p_201500_2_, CallbackInfoReturnable<Boolean> cir) {
        ChunkBridge activeChunk = ((ActiveChunkReferantBridge)((Object)this)).bridge$getActiveChunk();
        if (activeChunk == null || activeChunk.bridge$isQueuedForUnload() || !activeChunk.bridge$areNeighborsLoaded()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"updateFluidHeightAndDoFluidPushing"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;hasChunksAt(IIIIII)Z"))
    private boolean activeCollision$IgnoreAreaIsLoaded(World world, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd) {
        if (((WorldBridge)world).bridge$isFake()) {
            return world.func_217344_a(xStart, yStart, zStart, xEnd, yEnd, zEnd);
        }
        return true;
    }
}

