/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.login.client.CCustomPayloadLoginPacket;
import net.minecraft.network.login.server.SCustomPayloadLoginPacket;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.util.ResourceLocation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.packet.Packet;
import org.spongepowered.common.accessor.network.login.client.CCustomPayloadLoginPacketAccessor;
import org.spongepowered.common.accessor.network.login.server.SCustomPayloadLoginPacketAccessor;
import org.spongepowered.common.accessor.network.play.client.CCustomPayloadPacketAccessor;
import org.spongepowered.common.accessor.network.play.server.SCustomPayloadPlayPacketAccessor;

public final class PacketUtil {
    public static IPacket<?> createLoginPayloadResponse(@Nullable ChannelBuf payload, int transactionId) {
        CCustomPayloadLoginPacket packet = new CCustomPayloadLoginPacket();
        CCustomPayloadLoginPacketAccessor accessor = (CCustomPayloadLoginPacketAccessor)packet;
        accessor.accessor$transactionId(transactionId);
        accessor.accessor$data((PacketBuffer)payload);
        return packet;
    }

    public static IPacket<?> createLoginPayloadRequest(ResourceKey channel, ChannelBuf payload, int transactionId) {
        SCustomPayloadLoginPacket packet = new SCustomPayloadLoginPacket();
        SCustomPayloadLoginPacketAccessor accessor = (SCustomPayloadLoginPacketAccessor)packet;
        accessor.accessor$identifier((ResourceLocation)channel);
        accessor.accessor$transactionId(transactionId);
        accessor.accessor$data((PacketBuffer)payload);
        return packet;
    }

    public static IPacket<?> createPlayPayload(ResourceKey channel, ChannelBuf payload, EngineConnectionSide<?> side) {
        if (side == EngineConnectionSide.CLIENT) {
            CCustomPayloadPacketAccessor packet = (CCustomPayloadPacketAccessor)new CCustomPayloadPacket();
            packet.accessor$identifier((ResourceLocation)channel);
            packet.accessor$data((PacketBuffer)payload);
            return (IPacket)packet;
        }
        if (side == EngineConnectionSide.SERVER) {
            SCustomPayloadPlayPacketAccessor packet = (SCustomPayloadPlayPacketAccessor)new SCustomPayloadPlayPacket();
            packet.accessor$identifier((ResourceLocation)channel);
            packet.accessor$data((PacketBuffer)payload);
            return (IPacket)packet;
        }
        throw new UnsupportedOperationException();
    }

    public static <P extends Packet> Supplier<P> getConstructor(Class<P> packetClass) {
        Constructor constructor;
        try {
            constructor = packetClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        return () -> {
            try {
                return (Packet)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        };
    }

    private PacketUtil() {
    }
}

