/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.packet;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.ClientSideConnection;
import org.spongepowered.api.network.EngineConnectionTypes;
import org.spongepowered.api.network.channel.packet.PacketChannel;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.network.channel.SpongeChannelRegistry;
import org.spongepowered.common.network.packet.ChangeViewerEnvironmentPacket;
import org.spongepowered.common.network.packet.RequestBlockTrackerDataPacket;
import org.spongepowered.common.network.packet.RequestEntityTrackerDataPacket;
import org.spongepowered.common.network.packet.TrackerDataResponsePacket;

public final class SpongePacketHandler {
    private static PacketChannel channel;

    public static void init(SpongeChannelRegistry registry) {
        channel = registry.createChannel(ResourceKey.sponge("default"), PacketChannel.class);
        channel.registerTransactional(RequestBlockTrackerDataPacket.class, TrackerDataResponsePacket.class, 0).setRequestHandler(EngineConnectionTypes.SERVER_PLAYER, (requestPacket, connection, response) -> {
            ServerPlayer player = connection.getPlayer();
            if (!player.hasPermission("sponge.debug.block-tracking")) {
                return;
            }
            ServerPlayerEntity sender = (ServerPlayerEntity)player;
            BlockPos pos = new BlockPos(requestPacket.x, requestPacket.y, requestPacket.z);
            if (!sender.field_70170_p.func_175667_e(pos)) {
                return;
            }
            ChunkBridge chunkBridge = (ChunkBridge)sender.field_70170_p.func_175726_f(pos);
            Optional<User> owner = chunkBridge.bridge$getBlockCreator(pos);
            Optional<User> notifier = chunkBridge.bridge$getBlockNotifier(pos);
            response.success(SpongePacketHandler.createTrackerDataResponse(owner, notifier));
        });
        channel.registerTransactional(RequestEntityTrackerDataPacket.class, TrackerDataResponsePacket.class, 1).setRequestHandler(EngineConnectionTypes.SERVER_PLAYER, (requestPacket, connection, response) -> {
            ServerPlayer player = connection.getPlayer();
            if (!player.hasPermission("sponge.debug.entity-tracking")) {
                return;
            }
            ServerPlayerEntity sender = (ServerPlayerEntity)player;
            Entity entity = sender.field_70170_p.func_73045_a(requestPacket.entityId);
            if (!(entity instanceof CreatorTrackedBridge)) {
                return;
            }
            CreatorTrackedBridge creatorTrackedBridge = (CreatorTrackedBridge)entity;
            Optional<User> owner = creatorTrackedBridge.tracked$getCreatorReference();
            Optional<User> notifier = creatorTrackedBridge.tracked$getNotifierReference();
            response.success(SpongePacketHandler.createTrackerDataResponse(owner, notifier));
        });
        channel.register(ChangeViewerEnvironmentPacket.class, 3).addHandler(ClientSideConnection.class, (packet, connection) -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return;
            }
            DimensionType dimensionType = (DimensionType)SpongeCommon.getServer().func_244267_aX().func_230520_a_().func_82594_a(packet.dimensionLogic);
            ((WorldBridge)world).bridge$adjustDimensionLogic(dimensionType);
        });
    }

    private static TrackerDataResponsePacket createTrackerDataResponse(Optional<User> owner, Optional<User> notifier) {
        String ownerName = owner.map(User::getName).orElse("");
        String notifierName = notifier.map(User::getName).orElse("");
        return new TrackerDataResponsePacket(ownerName, notifierName);
    }

    public static PacketChannel getChannel() {
        return Objects.requireNonNull(channel);
    }
}

