/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.placeholder;

import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.SystemSubject;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.placeholder.PlaceholderContext;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.placeholder.SpongePlaceholderContext;

public class SpongePlaceholderContextBuilder
implements PlaceholderContext.Builder {
    @Nullable
    private Supplier<Object> associatedObjectSupplier;
    @Nullable
    private String argument = null;

    @Override
    public PlaceholderContext.Builder setAssociatedObject(@Nullable Object associatedObject) {
        if (associatedObject == null) {
            this.associatedObjectSupplier = null;
        } else {
            if (associatedObject instanceof Supplier) {
                return this.setAssociatedObject((Supplier)associatedObject);
            }
            if (associatedObject instanceof SystemSubject) {
                this.associatedObjectSupplier = Sponge::getSystemSubject;
            } else if (associatedObject instanceof Server) {
                this.associatedObjectSupplier = Sponge::getServer;
            } else {
                if (associatedObject instanceof Player) {
                    return this.setAssociatedObject((Player)associatedObject);
                }
                if (associatedObject instanceof ServerWorld) {
                    ResourceKey key = ((ServerWorld)associatedObject).getKey();
                    this.associatedObjectSupplier = () -> SpongeCommon.getGame().getServer().getWorldManager().world(key).orElse(null);
                } else if (associatedObject instanceof Entity) {
                    Entity entity = (Entity)associatedObject;
                    ResourceKey key = ((ServerWorld)entity.getServerLocation().getWorld()).getKey();
                    UUID entityUuid = ((Entity)associatedObject).getUniqueId();
                    this.associatedObjectSupplier = () -> SpongeCommon.getGame().getServer().getWorldManager().world(key).flatMap(x -> x.getEntity(entityUuid)).orElse(null);
                } else {
                    WeakReference<Object> objectWeakReference = new WeakReference<Object>(associatedObject);
                    this.associatedObjectSupplier = objectWeakReference::get;
                }
            }
        }
        return this;
    }

    @Override
    public PlaceholderContext.Builder setAssociatedObject(@Nullable Supplier<Object> associatedObjectSupplier) {
        this.associatedObjectSupplier = associatedObjectSupplier;
        return this;
    }

    @Override
    public PlaceholderContext.Builder setArgumentString(@Nullable String argument) {
        this.argument = argument == null || argument.isEmpty() ? null : argument;
        return this;
    }

    @Override
    public PlaceholderContext build() throws IllegalStateException {
        return new SpongePlaceholderContext(this.associatedObjectSupplier, this.argument);
    }

    @Override
    public PlaceholderContext.Builder reset() {
        this.associatedObjectSupplier = null;
        this.argument = null;
        return this;
    }
}

