/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.profile;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.properties.Property;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.common.util.Constants;

public final class SpongeGameProfile
implements GameProfile {
    private static final Gson GSON = new Gson();
    public static final UUID EMPTY_UUID = new UUID(0L, 0L);
    private final UUID uniqueId;
    private final @Nullable String name;
    private final List<ProfileProperty> properties;

    public static SpongeGameProfile of(com.mojang.authlib.GameProfile mcProfile) {
        UUID uniqueId = mcProfile.getId() == null ? EMPTY_UUID : mcProfile.getId();
        String name = mcProfile.getName();
        ImmutableList properties = ImmutableList.copyOf((Collection)mcProfile.getProperties().values());
        return new SpongeGameProfile(uniqueId, name, (List<ProfileProperty>)properties);
    }

    public static SpongeGameProfile basicOf(com.mojang.authlib.GameProfile mcProfile) {
        UUID uniqueId = mcProfile.getId() == null ? EMPTY_UUID : mcProfile.getId();
        String name = mcProfile.getName();
        return new SpongeGameProfile(uniqueId, name);
    }

    public static com.mojang.authlib.GameProfile toMcProfile(GameProfile profile) {
        return ((SpongeGameProfile)profile).toMcProfile();
    }

    public static GameProfile unsignedOf(GameProfile profile) {
        if (profile.getProperties().isEmpty()) {
            return profile;
        }
        return new SpongeGameProfile(profile.getUniqueId(), profile.getName().orElse(null), (List)profile.getProperties().stream().map(SpongeGameProfile::withoutSignature).collect(ImmutableList.toImmutableList()));
    }

    private static String decodeBase64(String value) {
        return new String(Base64.getDecoder().decode(value.getBytes(StandardCharsets.UTF_8)), Charsets.UTF_8);
    }

    private static String encodeBase64(String value) {
        return new String(Base64.getEncoder().encode(value.getBytes(StandardCharsets.UTF_8)), Charsets.UTF_8);
    }

    private static ProfileProperty withoutSignature(ProfileProperty property) {
        JsonObject json;
        if (!property.hasSignature()) {
            return property;
        }
        String decoded = SpongeGameProfile.decodeBase64(property.getValue());
        try {
            json = GSON.fromJson(decoded, JsonObject.class);
        }
        catch (Throwable t) {
            return property;
        }
        if (!json.has("signatureRequired")) {
            return property;
        }
        json.remove("signatureRequired");
        String encoded = SpongeGameProfile.encodeBase64(GSON.toJson(json));
        return ProfileProperty.of(property.getName(), encoded);
    }

    public SpongeGameProfile(UUID uniqueId, @Nullable String name) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        this.uniqueId = uniqueId;
        this.name = name;
        this.properties = ImmutableList.of();
    }

    public SpongeGameProfile(UUID uniqueId, @Nullable String name, List<ProfileProperty> properties) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        Objects.requireNonNull(properties, "properties");
        this.uniqueId = uniqueId;
        this.name = name;
        this.properties = ImmutableList.copyOf(properties);
    }

    public com.mojang.authlib.GameProfile toMcProfile() {
        UUID uniqueId = this.uniqueId.equals(EMPTY_UUID) ? null : this.uniqueId;
        String name = this.name;
        com.mojang.authlib.GameProfile mcProfile = new com.mojang.authlib.GameProfile(uniqueId, name);
        for (ProfileProperty property : this.properties) {
            mcProfile.getProperties().put((Object)property.getName(), (Object)((Property)property));
        }
        return mcProfile;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public GameProfile withName(@Nullable String name) {
        return new SpongeGameProfile(this.uniqueId, name, this.properties);
    }

    @Override
    public List<ProfileProperty> getProperties() {
        return this.properties;
    }

    @Override
    public GameProfile withoutProperties() {
        return new SpongeGameProfile(this.uniqueId, this.name);
    }

    @Override
    public GameProfile withProperties(Iterable<ProfileProperty> properties) {
        return new SpongeGameProfile(this.uniqueId, this.name, (List<ProfileProperty>)ImmutableList.builder().addAll(this.properties).addAll(properties).build());
    }

    @Override
    public GameProfile withProperty(ProfileProperty property) {
        return new SpongeGameProfile(this.uniqueId, this.name, (List<ProfileProperty>)ImmutableList.builder().addAll(this.properties).add((Object)property).build());
    }

    @Override
    public GameProfile withoutProperties(Iterable<ProfileProperty> properties) {
        List toRemove = properties instanceof Collection ? (List)properties : ImmutableList.copyOf(properties);
        return new SpongeGameProfile(this.uniqueId, this.name, (List)this.properties.stream().filter(property -> !toRemove.contains(property)).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public GameProfile withoutProperty(ProfileProperty propertyToRemove) {
        return new SpongeGameProfile(this.uniqueId, this.name, (List)this.properties.stream().filter(property -> !propertyToRemove.equals(property)).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public GameProfile withoutProperties(Predicate<ProfileProperty> filter) {
        return new SpongeGameProfile(this.uniqueId, this.name, (List)this.properties.stream().filter(property -> !filter.test((ProfileProperty)property)).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.getContentVersion()).set(Constants.Profile.UUID, this.getUniqueId().toString());
        if (this.name != null) {
            container.set(Constants.Profile.NAME, this.name);
        }
        if (!this.properties.isEmpty()) {
            ArrayList<DataContainer> entries = new ArrayList<DataContainer>(this.properties.size());
            for (ProfileProperty property : this.properties) {
                DataContainer entry = DataContainer.createNew().set(Constants.Profile.NAME, property.getName()).set(Constants.Profile.VALUE, property.getValue());
                property.getSignature().ifPresent(signature -> entry.set(Constants.Profile.SIGNATURE, signature));
                entries.add(entry);
            }
            container.set(Constants.Profile.PROPERTIES, entries);
        }
        return container;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeGameProfile that = (SpongeGameProfile)o;
        return this.uniqueId.equals(that.uniqueId) && Objects.equals(this.name, that.name) && this.properties.size() == that.properties.size() && this.properties.containsAll(that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.name, Arrays.hashCode(this.properties.toArray()));
    }

    public String toString() {
        return new StringJoiner(", ", SpongeGameProfile.class.getSimpleName() + "[", "]").add("uniqueId=" + this.uniqueId).add("name=" + this.name).toString();
    }

    public static final class Factory
    implements GameProfile.Factory {
        @Override
        public GameProfile of(UUID uniqueId, @Nullable String name) {
            Objects.requireNonNull(uniqueId);
            return new SpongeGameProfile(uniqueId, name);
        }
    }
}

